# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CacheArgs', 'Cache']

@pulumi.input_type
class CacheArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[_builtins.int],
                 family: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 access_keys_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['CacheIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ssl_port_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 patch_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]]] = None,
                 private_static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 redis_configuration: Optional[pulumi.Input['CacheRedisConfigurationArgs']] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_master: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas_per_primary: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cache resource.
        :param pulumi.Input[_builtins.int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        :param pulumi.Input[_builtins.str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
               
               > **Note** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[_builtins.bool] access_keys_authentication_enabled: Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        :param pulumi.Input['CacheIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The location of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.
               
               > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] non_ssl_port_enabled: Enable the non-SSL port (6379) - disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]] patch_schedules: A list of `patch_schedule` blocks as defined below.
        :param pulumi.Input[_builtins.str] private_static_ip_address: The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        :param pulumi.Input['CacheRedisConfigurationArgs'] redis_configuration: A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        :param pulumi.Input[_builtins.str] redis_version: Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        :param pulumi.Input[_builtins.int] replicas_per_master: Amount of replicas to create per master for this Redis Cache.
               
               > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        :param pulumi.Input[_builtins.int] replicas_per_primary: Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        :param pulumi.Input[_builtins.int] shard_count: *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[_builtins.str] subnet_id: *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tenant_settings: A mapping of tenant settings to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.
               
               > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if access_keys_authentication_enabled is not None:
            pulumi.set(__self__, "access_keys_authentication_enabled", access_keys_authentication_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_ssl_port_enabled is not None:
            pulumi.set(__self__, "non_ssl_port_enabled", non_ssl_port_enabled)
        if patch_schedules is not None:
            pulumi.set(__self__, "patch_schedules", patch_schedules)
        if private_static_ip_address is not None:
            pulumi.set(__self__, "private_static_ip_address", private_static_ip_address)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if redis_configuration is not None:
            pulumi.set(__self__, "redis_configuration", redis_configuration)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if replicas_per_master is not None:
            pulumi.set(__self__, "replicas_per_master", replicas_per_master)
        if replicas_per_primary is not None:
            pulumi.set(__self__, "replicas_per_primary", replicas_per_primary)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_settings is not None:
            pulumi.set(__self__, "tenant_settings", tenant_settings)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.

        > **Note** Downgrading the SKU will force a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="accessKeysAuthenticationEnabled")
    def access_keys_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        """
        return pulumi.get(self, "access_keys_authentication_enabled")

    @access_keys_authentication_enabled.setter
    def access_keys_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_keys_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CacheIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CacheIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.

        > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonSslPortEnabled")
    def non_ssl_port_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the non-SSL port (6379) - disabled by default.
        """
        return pulumi.get(self, "non_ssl_port_enabled")

    @non_ssl_port_enabled.setter
    def non_ssl_port_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "non_ssl_port_enabled", value)

    @_builtins.property
    @pulumi.getter(name="patchSchedules")
    def patch_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]]]:
        """
        A list of `patch_schedule` blocks as defined below.
        """
        return pulumi.get(self, "patch_schedules")

    @patch_schedules.setter
    def patch_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]]]):
        pulumi.set(self, "patch_schedules", value)

    @_builtins.property
    @pulumi.getter(name="privateStaticIpAddress")
    def private_static_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_static_ip_address")

    @private_static_ip_address.setter
    def private_static_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_static_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="redisConfiguration")
    def redis_configuration(self) -> Optional[pulumi.Input['CacheRedisConfigurationArgs']]:
        """
        A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        """
        return pulumi.get(self, "redis_configuration")

    @redis_configuration.setter
    def redis_configuration(self, value: Optional[pulumi.Input['CacheRedisConfigurationArgs']]):
        pulumi.set(self, "redis_configuration", value)

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_version", value)

    @_builtins.property
    @pulumi.getter(name="replicasPerMaster")
    def replicas_per_master(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of replicas to create per master for this Redis Cache.

        > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        """
        return pulumi.get(self, "replicas_per_master")

    @replicas_per_master.setter
    def replicas_per_master(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas_per_master", value)

    @_builtins.property
    @pulumi.getter(name="replicasPerPrimary")
    def replicas_per_primary(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        """
        return pulumi.get(self, "replicas_per_primary")

    @replicas_per_primary.setter
    def replicas_per_primary(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas_per_primary", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantSettings")
    def tenant_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tenant settings to assign to the resource.
        """
        return pulumi.get(self, "tenant_settings")

    @tenant_settings.setter
    def tenant_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tenant_settings", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.

        > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _CacheState:
    def __init__(__self__, *,
                 access_keys_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['CacheIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ssl_port_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 patch_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 private_static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 redis_configuration: Optional[pulumi.Input['CacheRedisConfigurationArgs']] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_master: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas_per_primary: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_port: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cache resources.
        :param pulumi.Input[_builtins.bool] access_keys_authentication_enabled: Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        :param pulumi.Input[_builtins.int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        :param pulumi.Input[_builtins.str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[_builtins.str] hostname: The Hostname of the Redis Instance
        :param pulumi.Input['CacheIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The location of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.
               
               > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] non_ssl_port_enabled: Enable the non-SSL port (6379) - disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]] patch_schedules: A list of `patch_schedule` blocks as defined below.
        :param pulumi.Input[_builtins.int] port: The non-SSL Port of the Redis Instance
        :param pulumi.Input[_builtins.str] primary_access_key: The Primary Access Key for the Redis Instance
        :param pulumi.Input[_builtins.str] primary_connection_string: The primary connection string of the Redis Instance.
        :param pulumi.Input[_builtins.str] private_static_ip_address: The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        :param pulumi.Input['CacheRedisConfigurationArgs'] redis_configuration: A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        :param pulumi.Input[_builtins.str] redis_version: Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        :param pulumi.Input[_builtins.int] replicas_per_master: Amount of replicas to create per master for this Redis Cache.
               
               > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        :param pulumi.Input[_builtins.int] replicas_per_primary: Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The Secondary Access Key for the Redis Instance
        :param pulumi.Input[_builtins.str] secondary_connection_string: The secondary connection string of the Redis Instance.
        :param pulumi.Input[_builtins.int] shard_count: *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
               
               > **Note** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[_builtins.int] ssl_port: The SSL Port of the Redis Instance
        :param pulumi.Input[_builtins.str] subnet_id: *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tenant_settings: A mapping of tenant settings to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.
               
               > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        if access_keys_authentication_enabled is not None:
            pulumi.set(__self__, "access_keys_authentication_enabled", access_keys_authentication_enabled)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_ssl_port_enabled is not None:
            pulumi.set(__self__, "non_ssl_port_enabled", non_ssl_port_enabled)
        if patch_schedules is not None:
            pulumi.set(__self__, "patch_schedules", patch_schedules)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if private_static_ip_address is not None:
            pulumi.set(__self__, "private_static_ip_address", private_static_ip_address)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if redis_configuration is not None:
            pulumi.set(__self__, "redis_configuration", redis_configuration)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if replicas_per_master is not None:
            pulumi.set(__self__, "replicas_per_master", replicas_per_master)
        if replicas_per_primary is not None:
            pulumi.set(__self__, "replicas_per_primary", replicas_per_primary)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if ssl_port is not None:
            pulumi.set(__self__, "ssl_port", ssl_port)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_settings is not None:
            pulumi.set(__self__, "tenant_settings", tenant_settings)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="accessKeysAuthenticationEnabled")
    def access_keys_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        """
        return pulumi.get(self, "access_keys_authentication_enabled")

    @access_keys_authentication_enabled.setter
    def access_keys_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_keys_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Hostname of the Redis Instance
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CacheIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CacheIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.

        > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @minimum_tls_version.setter
    def minimum_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "minimum_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonSslPortEnabled")
    def non_ssl_port_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the non-SSL port (6379) - disabled by default.
        """
        return pulumi.get(self, "non_ssl_port_enabled")

    @non_ssl_port_enabled.setter
    def non_ssl_port_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "non_ssl_port_enabled", value)

    @_builtins.property
    @pulumi.getter(name="patchSchedules")
    def patch_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]]]:
        """
        A list of `patch_schedule` blocks as defined below.
        """
        return pulumi.get(self, "patch_schedules")

    @patch_schedules.setter
    def patch_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CachePatchScheduleArgs']]]]):
        pulumi.set(self, "patch_schedules", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The non-SSL Port of the Redis Instance
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Access Key for the Redis Instance
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary connection string of the Redis Instance.
        """
        return pulumi.get(self, "primary_connection_string")

    @primary_connection_string.setter
    def primary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="privateStaticIpAddress")
    def private_static_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_static_ip_address")

    @private_static_ip_address.setter
    def private_static_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_static_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="redisConfiguration")
    def redis_configuration(self) -> Optional[pulumi.Input['CacheRedisConfigurationArgs']]:
        """
        A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        """
        return pulumi.get(self, "redis_configuration")

    @redis_configuration.setter
    def redis_configuration(self, value: Optional[pulumi.Input['CacheRedisConfigurationArgs']]):
        pulumi.set(self, "redis_configuration", value)

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_version", value)

    @_builtins.property
    @pulumi.getter(name="replicasPerMaster")
    def replicas_per_master(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of replicas to create per master for this Redis Cache.

        > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        """
        return pulumi.get(self, "replicas_per_master")

    @replicas_per_master.setter
    def replicas_per_master(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas_per_master", value)

    @_builtins.property
    @pulumi.getter(name="replicasPerPrimary")
    def replicas_per_primary(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        """
        return pulumi.get(self, "replicas_per_primary")

    @replicas_per_primary.setter
    def replicas_per_primary(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas_per_primary", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Access Key for the Redis Instance
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary connection string of the Redis Instance.
        """
        return pulumi.get(self, "secondary_connection_string")

    @secondary_connection_string.setter
    def secondary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.

        > **Note** Downgrading the SKU will force a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="sslPort")
    def ssl_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SSL Port of the Redis Instance
        """
        return pulumi.get(self, "ssl_port")

    @ssl_port.setter
    def ssl_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ssl_port", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantSettings")
    def tenant_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tenant settings to assign to the resource.
        """
        return pulumi.get(self, "tenant_settings")

    @tenant_settings.setter
    def tenant_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tenant_settings", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.

        > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:redis/cache:Cache")
class Cache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_keys_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ssl_port_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 patch_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CachePatchScheduleArgs', 'CachePatchScheduleArgsDict']]]]] = None,
                 private_static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 redis_configuration: Optional[pulumi.Input[Union['CacheRedisConfigurationArgs', 'CacheRedisConfigurationArgsDict']]] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_master: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas_per_primary: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Redis Cache.

        > **Note:** Redis version 4 is being retired and no longer supports creating new instances. Version 4 will be removed in a future release. [Redis Version 4 Retirement](https://learn.microsoft.com/azure/azure-cache-for-redis/cache-retired-features#important-upgrade-timelines)

        ## Example Usage

        This example provisions a Standard Redis Cache.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        # NOTE: the Name used for Redis needs to be globally unique
        example_cache = azure.redis.Cache("example",
            name="example-cache",
            location=example.location,
            resource_group_name=example.name,
            capacity=2,
            family="C",
            sku_name="Standard",
            non_ssl_port_enabled=False,
            minimum_tls_version="1.2",
            redis_configuration={})
        ```

        ## Relevant Links

        * [Azure Cache for Redis planning](https://docs.microsoft.com/azure/azure-cache-for-redis/cache-planning-faq)
        * [Redis: Available Configuration Settings](https://redis.io/topics/config)

        ## Import

        Redis Cache's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/cache:Cache cache1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redis/cache1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] access_keys_authentication_enabled: Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        :param pulumi.Input[_builtins.int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        :param pulumi.Input[_builtins.str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The location of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.
               
               > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] non_ssl_port_enabled: Enable the non-SSL port (6379) - disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CachePatchScheduleArgs', 'CachePatchScheduleArgsDict']]]] patch_schedules: A list of `patch_schedule` blocks as defined below.
        :param pulumi.Input[_builtins.str] private_static_ip_address: The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        :param pulumi.Input[Union['CacheRedisConfigurationArgs', 'CacheRedisConfigurationArgsDict']] redis_configuration: A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        :param pulumi.Input[_builtins.str] redis_version: Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        :param pulumi.Input[_builtins.int] replicas_per_master: Amount of replicas to create per master for this Redis Cache.
               
               > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        :param pulumi.Input[_builtins.int] replicas_per_primary: Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] shard_count: *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
               
               > **Note** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tenant_settings: A mapping of tenant settings to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.
               
               > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Redis Cache.

        > **Note:** Redis version 4 is being retired and no longer supports creating new instances. Version 4 will be removed in a future release. [Redis Version 4 Retirement](https://learn.microsoft.com/azure/azure-cache-for-redis/cache-retired-features#important-upgrade-timelines)

        ## Example Usage

        This example provisions a Standard Redis Cache.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        # NOTE: the Name used for Redis needs to be globally unique
        example_cache = azure.redis.Cache("example",
            name="example-cache",
            location=example.location,
            resource_group_name=example.name,
            capacity=2,
            family="C",
            sku_name="Standard",
            non_ssl_port_enabled=False,
            minimum_tls_version="1.2",
            redis_configuration={})
        ```

        ## Relevant Links

        * [Azure Cache for Redis planning](https://docs.microsoft.com/azure/azure-cache-for-redis/cache-planning-faq)
        * [Redis: Available Configuration Settings](https://redis.io/topics/config)

        ## Import

        Redis Cache's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:redis/cache:Cache cache1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Cache/redis/cache1
        ```

        :param str resource_name: The name of the resource.
        :param CacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_keys_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_ssl_port_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 patch_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CachePatchScheduleArgs', 'CachePatchScheduleArgsDict']]]]] = None,
                 private_static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 redis_configuration: Optional[pulumi.Input[Union['CacheRedisConfigurationArgs', 'CacheRedisConfigurationArgsDict']]] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas_per_master: Optional[pulumi.Input[_builtins.int]] = None,
                 replicas_per_primary: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CacheArgs.__new__(CacheArgs)

            __props__.__dict__["access_keys_authentication_enabled"] = access_keys_authentication_enabled
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            if family is None and not opts.urn:
                raise TypeError("Missing required property 'family'")
            __props__.__dict__["family"] = family
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["minimum_tls_version"] = minimum_tls_version
            __props__.__dict__["name"] = name
            __props__.__dict__["non_ssl_port_enabled"] = non_ssl_port_enabled
            __props__.__dict__["patch_schedules"] = patch_schedules
            __props__.__dict__["private_static_ip_address"] = private_static_ip_address
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["redis_configuration"] = redis_configuration
            __props__.__dict__["redis_version"] = redis_version
            __props__.__dict__["replicas_per_master"] = replicas_per_master
            __props__.__dict__["replicas_per_primary"] = replicas_per_primary
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["shard_count"] = shard_count
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_settings"] = tenant_settings
            __props__.__dict__["zones"] = zones
            __props__.__dict__["hostname"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["primary_connection_string"] = None
            __props__.__dict__["secondary_access_key"] = None
            __props__.__dict__["secondary_connection_string"] = None
            __props__.__dict__["ssl_port"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "primaryConnectionString", "secondaryAccessKey", "secondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cache, __self__).__init__(
            'azure:redis/cache:Cache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_keys_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            family: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            minimum_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            non_ssl_port_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            patch_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CachePatchScheduleArgs', 'CachePatchScheduleArgsDict']]]]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            private_static_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            redis_configuration: Optional[pulumi.Input[Union['CacheRedisConfigurationArgs', 'CacheRedisConfigurationArgsDict']]] = None,
            redis_version: Optional[pulumi.Input[_builtins.str]] = None,
            replicas_per_master: Optional[pulumi.Input[_builtins.int]] = None,
            replicas_per_primary: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_port: Optional[pulumi.Input[_builtins.int]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Cache':
        """
        Get an existing Cache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] access_keys_authentication_enabled: Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        :param pulumi.Input[_builtins.int] capacity: The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        :param pulumi.Input[_builtins.str] family: The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        :param pulumi.Input[_builtins.str] hostname: The Hostname of the Redis Instance
        :param pulumi.Input[Union['CacheIdentityArgs', 'CacheIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The location of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] minimum_tls_version: The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.
               
               > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param pulumi.Input[_builtins.str] name: The name of the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] non_ssl_port_enabled: Enable the non-SSL port (6379) - disabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CachePatchScheduleArgs', 'CachePatchScheduleArgsDict']]]] patch_schedules: A list of `patch_schedule` blocks as defined below.
        :param pulumi.Input[_builtins.int] port: The non-SSL Port of the Redis Instance
        :param pulumi.Input[_builtins.str] primary_access_key: The Primary Access Key for the Redis Instance
        :param pulumi.Input[_builtins.str] primary_connection_string: The primary connection string of the Redis Instance.
        :param pulumi.Input[_builtins.str] private_static_ip_address: The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        :param pulumi.Input[Union['CacheRedisConfigurationArgs', 'CacheRedisConfigurationArgsDict']] redis_configuration: A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        :param pulumi.Input[_builtins.str] redis_version: Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        :param pulumi.Input[_builtins.int] replicas_per_master: Amount of replicas to create per master for this Redis Cache.
               
               > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        :param pulumi.Input[_builtins.int] replicas_per_primary: Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The Secondary Access Key for the Redis Instance
        :param pulumi.Input[_builtins.str] secondary_connection_string: The secondary connection string of the Redis Instance.
        :param pulumi.Input[_builtins.int] shard_count: *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.
               
               > **Note** Downgrading the SKU will force a new resource to be created.
        :param pulumi.Input[_builtins.int] ssl_port: The SSL Port of the Redis Instance
        :param pulumi.Input[_builtins.str] subnet_id: *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tenant_settings: A mapping of tenant settings to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.
               
               > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CacheState.__new__(_CacheState)

        __props__.__dict__["access_keys_authentication_enabled"] = access_keys_authentication_enabled
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["family"] = family
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["minimum_tls_version"] = minimum_tls_version
        __props__.__dict__["name"] = name
        __props__.__dict__["non_ssl_port_enabled"] = non_ssl_port_enabled
        __props__.__dict__["patch_schedules"] = patch_schedules
        __props__.__dict__["port"] = port
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["primary_connection_string"] = primary_connection_string
        __props__.__dict__["private_static_ip_address"] = private_static_ip_address
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["redis_configuration"] = redis_configuration
        __props__.__dict__["redis_version"] = redis_version
        __props__.__dict__["replicas_per_master"] = replicas_per_master
        __props__.__dict__["replicas_per_primary"] = replicas_per_primary
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["secondary_connection_string"] = secondary_connection_string
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["ssl_port"] = ssl_port
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_settings"] = tenant_settings
        __props__.__dict__["zones"] = zones
        return Cache(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeysAuthenticationEnabled")
    def access_keys_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether access key authentication is enabled? Defaults to `true`. `active_directory_authentication_enabled` must be set to `true` to disable access key authentication.
        """
        return pulumi.get(self, "access_keys_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the Redis cache to deploy. Valid values for a SKU `family` of C (Basic/Standard) are `0, 1, 2, 3, 4, 5, 6`, and for P (Premium) `family` are `1, 2, 3, 4, 5`.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def family(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU family/pricing group to use. Valid values are `C` (for Basic/Standard SKU family) and `P` (for `Premium`)
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The Hostname of the Redis Instance
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.CacheIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimum TLS version. Possible values are `1.0`, `1.1` and `1.2`. Defaults to `1.0`.

        > **NOTE:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "minimum_tls_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nonSslPortEnabled")
    def non_ssl_port_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the non-SSL port (6379) - disabled by default.
        """
        return pulumi.get(self, "non_ssl_port_enabled")

    @_builtins.property
    @pulumi.getter(name="patchSchedules")
    def patch_schedules(self) -> pulumi.Output[Optional[Sequence['outputs.CachePatchSchedule']]]:
        """
        A list of `patch_schedule` blocks as defined below.
        """
        return pulumi.get(self, "patch_schedules")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The non-SSL Port of the Redis Instance
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Access Key for the Redis Instance
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The primary connection string of the Redis Instance.
        """
        return pulumi.get(self, "primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="privateStaticIpAddress")
    def private_static_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The Static IP Address to assign to the Redis Cache when hosted inside the Virtual Network. This argument implies the use of `subnet_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_static_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not public network access is allowed for this Redis Cache. `true` means this resource could be accessed by both public and private endpoint. `false` means only private endpoint access is allowed. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="redisConfiguration")
    def redis_configuration(self) -> pulumi.Output['outputs.CacheRedisConfiguration']:
        """
        A `redis_configuration` block as defined below - with some limitations by SKU - defaults/details are shown below.
        """
        return pulumi.get(self, "redis_configuration")

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Redis version. Only major version needed. Possible values are `4` and `6`. Defaults to `6`.
        """
        return pulumi.get(self, "redis_version")

    @_builtins.property
    @pulumi.getter(name="replicasPerMaster")
    def replicas_per_master(self) -> pulumi.Output[_builtins.int]:
        """
        Amount of replicas to create per master for this Redis Cache.

        > **Note:** Configuring the number of replicas per master is only available when using the Premium SKU and cannot be used in conjunction with shards.
        """
        return pulumi.get(self, "replicas_per_master")

    @_builtins.property
    @pulumi.getter(name="replicasPerPrimary")
    def replicas_per_primary(self) -> pulumi.Output[_builtins.int]:
        """
        Amount of replicas to create per primary for this Redis Cache. If both `replicas_per_primary` and `replicas_per_master` are set, they need to be equal.
        """
        return pulumi.get(self, "replicas_per_primary")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Redis instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary Access Key for the Redis Instance
        """
        return pulumi.get(self, "secondary_access_key")

    @_builtins.property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary connection string of the Redis Instance.
        """
        return pulumi.get(self, "secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        *Only available when using the Premium SKU* The number of Shards to create on the Redis Cluster.
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU of Redis to use. Possible values are `Basic`, `Standard` and `Premium`.

        > **Note** Downgrading the SKU will force a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="sslPort")
    def ssl_port(self) -> pulumi.Output[_builtins.int]:
        """
        The SSL Port of the Redis Instance
        """
        return pulumi.get(self, "ssl_port")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        *Only available when using the Premium SKU* The ID of the Subnet within which the Redis Cache should be deployed. This Subnet must only contain Azure Cache for Redis instances without any other type of resources. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantSettings")
    def tenant_settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tenant settings to assign to the resource.
        """
        return pulumi.get(self, "tenant_settings")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Redis Cache should be located. Changing this forces a new Redis Cache to be created.

        > **Please Note:** Availability Zones are [in Preview and only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview) - as such you must be opted into the Preview to use this functionality. You can [opt into the Availability Zones Preview in the Azure Portal](https://aka.ms/azenroll).
        """
        return pulumi.get(self, "zones")

