# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerVulnerabilityAssessmentVirtualMachineArgs', 'ServerVulnerabilityAssessmentVirtualMachine']

@pulumi.input_type
class ServerVulnerabilityAssessmentVirtualMachineArgs:
    def __init__(__self__, *,
                 virtual_machine_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ServerVulnerabilityAssessmentVirtualMachine resource.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.input_type
class _ServerVulnerabilityAssessmentVirtualMachineState:
    def __init__(__self__, *,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerVulnerabilityAssessmentVirtualMachine resources.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:securitycenter/serverVulnerabilityAssessmentVirtualMachine:ServerVulnerabilityAssessmentVirtualMachine")
class ServerVulnerabilityAssessmentVirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Server Vulnerability Assessment (Qualys) to a VM.

        > **Note:** Azure Defender has to be enabled on the subscription in order for this resource to work.
        See this [documentation](https://docs.microsoft.com/azure/security-center/security-center-get-started) to get started.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            resource_group_name=example.name,
            address_spaces=["192.168.1.0/24"],
            location=example.location)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["192.168.1.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "vm-example",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-vm",
            location=example.location,
            resource_group_name=example.name,
            size="Standard_B1s",
            admin_username="testadmin",
            admin_password="Password1234!",
            disable_password_authentication=False,
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            network_interface_ids=[example_network_interface.id])
        example_server_vulnerability_assessment_virtual_machine = azure.securitycenter.ServerVulnerabilityAssessmentVirtualMachine("example", virtual_machine_id=example_linux_virtual_machine.id)
        ```

        ## Import

        Server Vulnerability Assessments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/serverVulnerabilityAssessmentVirtualMachine:ServerVulnerabilityAssessmentVirtualMachine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.Compute/virtualMachines/vm-name/providers/Microsoft.Security/serverVulnerabilityAssessments/Default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerVulnerabilityAssessmentVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Server Vulnerability Assessment (Qualys) to a VM.

        > **Note:** Azure Defender has to be enabled on the subscription in order for this resource to work.
        See this [documentation](https://docs.microsoft.com/azure/security-center/security-center-get-started) to get started.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            resource_group_name=example.name,
            address_spaces=["192.168.1.0/24"],
            location=example.location)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["192.168.1.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "vm-example",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-vm",
            location=example.location,
            resource_group_name=example.name,
            size="Standard_B1s",
            admin_username="testadmin",
            admin_password="Password1234!",
            disable_password_authentication=False,
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            network_interface_ids=[example_network_interface.id])
        example_server_vulnerability_assessment_virtual_machine = azure.securitycenter.ServerVulnerabilityAssessmentVirtualMachine("example", virtual_machine_id=example_linux_virtual_machine.id)
        ```

        ## Import

        Server Vulnerability Assessments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:securitycenter/serverVulnerabilityAssessmentVirtualMachine:ServerVulnerabilityAssessmentVirtualMachine example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.Compute/virtualMachines/vm-name/providers/Microsoft.Security/serverVulnerabilityAssessments/Default
        ```

        :param str resource_name: The name of the resource.
        :param ServerVulnerabilityAssessmentVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerVulnerabilityAssessmentVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerVulnerabilityAssessmentVirtualMachineArgs.__new__(ServerVulnerabilityAssessmentVirtualMachineArgs)

            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:securitycenter/serverVulnerabilityAssessment:ServerVulnerabilityAssessment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ServerVulnerabilityAssessmentVirtualMachine, __self__).__init__(
            'azure:securitycenter/serverVulnerabilityAssessmentVirtualMachine:ServerVulnerabilityAssessmentVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerVulnerabilityAssessmentVirtualMachine':
        """
        Get an existing ServerVulnerabilityAssessmentVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerVulnerabilityAssessmentVirtualMachineState.__new__(_ServerVulnerabilityAssessmentVirtualMachineState)

        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return ServerVulnerabilityAssessmentVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual machine to be monitored by vulnerability assessment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

