# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertRuleFusionArgs', 'AlertRuleFusion']

@pulumi.input_type
class AlertRuleFusionArgs:
    def __init__(__self__, *,
                 alert_rule_template_guid: pulumi.Input[_builtins.str],
                 log_analytics_workspace_id: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]]] = None):
        """
        The set of arguments for constructing a AlertRuleFusion resource.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]] sources: One or more `source` blocks as defined below.
        """
        pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            warnings.warn("""the `name` is deprecated and will be removed in v5.0 version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: the `name` is deprecated and will be removed in v5.0 version of the provider.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> pulumi.Input[_builtins.str]:
        """
        The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""the `name` is deprecated and will be removed in v5.0 version of the provider.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]]]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]]]):
        pulumi.set(self, "sources", value)


@pulumi.input_type
class _AlertRuleFusionState:
    def __init__(__self__, *,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]]] = None):
        """
        Input properties used for looking up and filtering AlertRuleFusion resources.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]] sources: One or more `source` blocks as defined below.
        """
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            warnings.warn("""the `name` is deprecated and will be removed in v5.0 version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: the `name` is deprecated and will be removed in v5.0 version of the provider.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""the `name` is deprecated and will be removed in v5.0 version of the provider.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]]]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleFusionSourceArgs']]]]):
        pulumi.set(self, "sources", value)


@pulumi.type_token("azure:sentinel/alertRuleFusion:AlertRuleFusion")
class AlertRuleFusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleFusionSourceArgs', 'AlertRuleFusionSourceArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Sentinel Fusion Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_fusion = azure.sentinel.AlertRuleFusion("example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            alert_rule_template_guid="f71aba3d-28fb-450b-b192-4e76a83015c8")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2023-12-01-preview

        ## Import

        Sentinel Fusion Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleFusion:AlertRuleFusion example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleFusionSourceArgs', 'AlertRuleFusionSourceArgsDict']]]] sources: One or more `source` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertRuleFusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Fusion Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_fusion = azure.sentinel.AlertRuleFusion("example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            alert_rule_template_guid="f71aba3d-28fb-450b-b192-4e76a83015c8")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2023-12-01-preview

        ## Import

        Sentinel Fusion Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleFusion:AlertRuleFusion example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param AlertRuleFusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertRuleFusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleFusionSourceArgs', 'AlertRuleFusionSourceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertRuleFusionArgs.__new__(AlertRuleFusionArgs)

            if alert_rule_template_guid is None and not opts.urn:
                raise TypeError("Missing required property 'alert_rule_template_guid'")
            __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
            __props__.__dict__["enabled"] = enabled
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            __props__.__dict__["sources"] = sources
        super(AlertRuleFusion, __self__).__init__(
            'azure:sentinel/alertRuleFusion:AlertRuleFusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleFusionSourceArgs', 'AlertRuleFusionSourceArgsDict']]]]] = None) -> 'AlertRuleFusion':
        """
        Get an existing AlertRuleFusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[_builtins.bool] enabled: Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleFusionSourceArgs', 'AlertRuleFusionSourceArgsDict']]]] sources: One or more `source` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertRuleFusionState.__new__(_AlertRuleFusionState)

        __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["sources"] = sources
        return AlertRuleFusion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> pulumi.Output[_builtins.str]:
        """
        The GUID of the alert rule template which is used for this Sentinel Fusion Alert Rule. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Sentinel Fusion Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel Fusion Alert Rule belongs to. Changing this forces a new Sentinel Fusion Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""the `name` is deprecated and will be removed in v5.0 version of the provider.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence['outputs.AlertRuleFusionSource']]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "sources")

