# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertRuleScheduledArgs', 'AlertRuleScheduled']

@pulumi.input_type
class AlertRuleScheduledArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 log_analytics_workspace_id: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 severity: pulumi.Input[_builtins.str],
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]]] = None,
                 event_grouping: Optional[pulumi.Input['AlertRuleScheduledEventGroupingArgs']] = None,
                 incident: Optional[pulumi.Input['AlertRuleScheduledIncidentArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 query_period: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AlertRuleScheduled resource.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input['AlertRuleScheduledEventGroupingArgs'] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input['AlertRuleScheduledIncidentArgs'] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query_frequency: The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.str] query_period: The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.
               
               > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
               
               > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        :param pulumi.Input[_builtins.str] trigger_operator: The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        :param pulumi.Input[_builtins.int] trigger_threshold: The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "severity", severity)
        if alert_details_overrides is not None:
            pulumi.set(__self__, "alert_details_overrides", alert_details_overrides)
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if alert_rule_template_version is not None:
            pulumi.set(__self__, "alert_rule_template_version", alert_rule_template_version)
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_mappings is not None:
            pulumi.set(__self__, "entity_mappings", entity_mappings)
        if event_grouping is not None:
            pulumi.set(__self__, "event_grouping", event_grouping)
        if incident is not None:
            pulumi.set(__self__, "incident", incident)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_frequency is not None:
            pulumi.set(__self__, "query_frequency", query_frequency)
        if query_period is not None:
            pulumi.set(__self__, "query_period", query_period)
        if sentinel_entity_mappings is not None:
            pulumi.set(__self__, "sentinel_entity_mappings", sentinel_entity_mappings)
        if suppression_duration is not None:
            pulumi.set(__self__, "suppression_duration", suppression_duration)
        if suppression_enabled is not None:
            pulumi.set(__self__, "suppression_enabled", suppression_enabled)
        if tactics is not None:
            pulumi.set(__self__, "tactics", tactics)
        if techniques is not None:
            pulumi.set(__self__, "techniques", techniques)
        if trigger_operator is not None:
            pulumi.set(__self__, "trigger_operator", trigger_operator)
        if trigger_threshold is not None:
            pulumi.set(__self__, "trigger_threshold", trigger_threshold)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The friendly name of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        The query of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.str]:
        """
        The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="alertDetailsOverrides")
    def alert_details_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]]]:
        """
        An `alert_details_override` block as defined below.
        """
        return pulumi.get(self, "alert_details_overrides")

    @alert_details_overrides.setter
    def alert_details_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]]]):
        pulumi.set(self, "alert_details_overrides", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateVersion")
    def alert_rule_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "alert_rule_template_version")

    @alert_rule_template_version.setter
    def alert_rule_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_version", value)

    @_builtins.property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        """
        return pulumi.get(self, "custom_details")

    @custom_details.setter
    def custom_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_details", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityMappings")
    def entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]]]:
        """
        A list of `entity_mapping` blocks as defined below.
        """
        return pulumi.get(self, "entity_mappings")

    @entity_mappings.setter
    def entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]]]):
        pulumi.set(self, "entity_mappings", value)

    @_builtins.property
    @pulumi.getter(name="eventGrouping")
    def event_grouping(self) -> Optional[pulumi.Input['AlertRuleScheduledEventGroupingArgs']]:
        """
        A `event_grouping` block as defined below.
        """
        return pulumi.get(self, "event_grouping")

    @event_grouping.setter
    def event_grouping(self, value: Optional[pulumi.Input['AlertRuleScheduledEventGroupingArgs']]):
        pulumi.set(self, "event_grouping", value)

    @_builtins.property
    @pulumi.getter
    def incident(self) -> Optional[pulumi.Input['AlertRuleScheduledIncidentArgs']]:
        """
        A `incident` block as defined below.
        """
        return pulumi.get(self, "incident")

    @incident.setter
    def incident(self, value: Optional[pulumi.Input['AlertRuleScheduledIncidentArgs']]):
        pulumi.set(self, "incident", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryFrequency")
    def query_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        """
        return pulumi.get(self, "query_frequency")

    @query_frequency.setter
    def query_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_frequency", value)

    @_builtins.property
    @pulumi.getter(name="queryPeriod")
    def query_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.

        > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        """
        return pulumi.get(self, "query_period")

    @query_period.setter
    def query_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_period", value)

    @_builtins.property
    @pulumi.getter(name="sentinelEntityMappings")
    def sentinel_entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]]]:
        """
        A list of `sentinel_entity_mapping` blocks as defined below.

        > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        """
        return pulumi.get(self, "sentinel_entity_mappings")

    @sentinel_entity_mappings.setter
    def sentinel_entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]]]):
        pulumi.set(self, "sentinel_entity_mappings", value)

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.

        > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        """
        return pulumi.get(self, "suppression_duration")

    @suppression_duration.setter
    def suppression_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suppression_duration", value)

    @_builtins.property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        """
        return pulumi.get(self, "suppression_enabled")

    @suppression_enabled.setter
    def suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppression_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        """
        return pulumi.get(self, "tactics")

    @tactics.setter
    def tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tactics", value)

    @_builtins.property
    @pulumi.getter
    def techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @techniques.setter
    def techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "techniques", value)

    @_builtins.property
    @pulumi.getter(name="triggerOperator")
    def trigger_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        """
        return pulumi.get(self, "trigger_operator")

    @trigger_operator.setter
    def trigger_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_operator", value)

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        return pulumi.get(self, "trigger_threshold")

    @trigger_threshold.setter
    def trigger_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "trigger_threshold", value)


@pulumi.input_type
class _AlertRuleScheduledState:
    def __init__(__self__, *,
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]]] = None,
                 event_grouping: Optional[pulumi.Input['AlertRuleScheduledEventGroupingArgs']] = None,
                 incident: Optional[pulumi.Input['AlertRuleScheduledIncidentArgs']] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 query_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 query_period: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AlertRuleScheduled resources.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input['AlertRuleScheduledEventGroupingArgs'] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input['AlertRuleScheduledIncidentArgs'] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] query_frequency: The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.str] query_period: The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.
               
               > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
               
               > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        :param pulumi.Input[_builtins.str] trigger_operator: The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        :param pulumi.Input[_builtins.int] trigger_threshold: The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        if alert_details_overrides is not None:
            pulumi.set(__self__, "alert_details_overrides", alert_details_overrides)
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if alert_rule_template_version is not None:
            pulumi.set(__self__, "alert_rule_template_version", alert_rule_template_version)
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_mappings is not None:
            pulumi.set(__self__, "entity_mappings", entity_mappings)
        if event_grouping is not None:
            pulumi.set(__self__, "event_grouping", event_grouping)
        if incident is not None:
            pulumi.set(__self__, "incident", incident)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if query_frequency is not None:
            pulumi.set(__self__, "query_frequency", query_frequency)
        if query_period is not None:
            pulumi.set(__self__, "query_period", query_period)
        if sentinel_entity_mappings is not None:
            pulumi.set(__self__, "sentinel_entity_mappings", sentinel_entity_mappings)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if suppression_duration is not None:
            pulumi.set(__self__, "suppression_duration", suppression_duration)
        if suppression_enabled is not None:
            pulumi.set(__self__, "suppression_enabled", suppression_enabled)
        if tactics is not None:
            pulumi.set(__self__, "tactics", tactics)
        if techniques is not None:
            pulumi.set(__self__, "techniques", techniques)
        if trigger_operator is not None:
            pulumi.set(__self__, "trigger_operator", trigger_operator)
        if trigger_threshold is not None:
            pulumi.set(__self__, "trigger_threshold", trigger_threshold)

    @_builtins.property
    @pulumi.getter(name="alertDetailsOverrides")
    def alert_details_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]]]:
        """
        An `alert_details_override` block as defined below.
        """
        return pulumi.get(self, "alert_details_overrides")

    @alert_details_overrides.setter
    def alert_details_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledAlertDetailsOverrideArgs']]]]):
        pulumi.set(self, "alert_details_overrides", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateVersion")
    def alert_rule_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "alert_rule_template_version")

    @alert_rule_template_version.setter
    def alert_rule_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_version", value)

    @_builtins.property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        """
        return pulumi.get(self, "custom_details")

    @custom_details.setter
    def custom_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_details", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The friendly name of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityMappings")
    def entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]]]:
        """
        A list of `entity_mapping` blocks as defined below.
        """
        return pulumi.get(self, "entity_mappings")

    @entity_mappings.setter
    def entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledEntityMappingArgs']]]]):
        pulumi.set(self, "entity_mappings", value)

    @_builtins.property
    @pulumi.getter(name="eventGrouping")
    def event_grouping(self) -> Optional[pulumi.Input['AlertRuleScheduledEventGroupingArgs']]:
        """
        A `event_grouping` block as defined below.
        """
        return pulumi.get(self, "event_grouping")

    @event_grouping.setter
    def event_grouping(self, value: Optional[pulumi.Input['AlertRuleScheduledEventGroupingArgs']]):
        pulumi.set(self, "event_grouping", value)

    @_builtins.property
    @pulumi.getter
    def incident(self) -> Optional[pulumi.Input['AlertRuleScheduledIncidentArgs']]:
        """
        A `incident` block as defined below.
        """
        return pulumi.get(self, "incident")

    @incident.setter
    def incident(self, value: Optional[pulumi.Input['AlertRuleScheduledIncidentArgs']]):
        pulumi.set(self, "incident", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The query of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="queryFrequency")
    def query_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        """
        return pulumi.get(self, "query_frequency")

    @query_frequency.setter
    def query_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_frequency", value)

    @_builtins.property
    @pulumi.getter(name="queryPeriod")
    def query_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.

        > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        """
        return pulumi.get(self, "query_period")

    @query_period.setter
    def query_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_period", value)

    @_builtins.property
    @pulumi.getter(name="sentinelEntityMappings")
    def sentinel_entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]]]:
        """
        A list of `sentinel_entity_mapping` blocks as defined below.

        > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        """
        return pulumi.get(self, "sentinel_entity_mappings")

    @sentinel_entity_mappings.setter
    def sentinel_entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleScheduledSentinelEntityMappingArgs']]]]):
        pulumi.set(self, "sentinel_entity_mappings", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.

        > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        """
        return pulumi.get(self, "suppression_duration")

    @suppression_duration.setter
    def suppression_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suppression_duration", value)

    @_builtins.property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        """
        return pulumi.get(self, "suppression_enabled")

    @suppression_enabled.setter
    def suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppression_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        """
        return pulumi.get(self, "tactics")

    @tactics.setter
    def tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tactics", value)

    @_builtins.property
    @pulumi.getter
    def techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @techniques.setter
    def techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "techniques", value)

    @_builtins.property
    @pulumi.getter(name="triggerOperator")
    def trigger_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        """
        return pulumi.get(self, "trigger_operator")

    @trigger_operator.setter
    def trigger_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_operator", value)

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        return pulumi.get(self, "trigger_threshold")

    @trigger_threshold.setter
    def trigger_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "trigger_threshold", value)


@pulumi.type_token("azure:sentinel/alertRuleScheduled:AlertRuleScheduled")
class AlertRuleScheduled(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledAlertDetailsOverrideArgs', 'AlertRuleScheduledAlertDetailsOverrideArgsDict']]]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledEntityMappingArgs', 'AlertRuleScheduledEntityMappingArgsDict']]]]] = None,
                 event_grouping: Optional[pulumi.Input[Union['AlertRuleScheduledEventGroupingArgs', 'AlertRuleScheduledEventGroupingArgsDict']]] = None,
                 incident: Optional[pulumi.Input[Union['AlertRuleScheduledIncidentArgs', 'AlertRuleScheduledIncidentArgsDict']]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 query_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 query_period: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledSentinelEntityMappingArgs', 'AlertRuleScheduledSentinelEntityMappingArgsDict']]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Sentinel Scheduled Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_scheduled = azure.sentinel.AlertRuleScheduled("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example",
            severity="High",
            query=\"\"\"AzureActivity |
          where OperationName == "Create or Update Virtual Machine" or OperationName =="Create Deployment" |
          where ActivityStatus == "Succeeded" |
          make-series dcount(ResourceId) default=0 on EventSubmissionTimestamp in range(ago(7d), now(), 1d) by Caller
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2023-12-01-preview

        ## Import

        Sentinel Scheduled Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleScheduled:AlertRuleScheduled example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledAlertDetailsOverrideArgs', 'AlertRuleScheduledAlertDetailsOverrideArgsDict']]]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledEntityMappingArgs', 'AlertRuleScheduledEntityMappingArgsDict']]]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input[Union['AlertRuleScheduledEventGroupingArgs', 'AlertRuleScheduledEventGroupingArgsDict']] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input[Union['AlertRuleScheduledIncidentArgs', 'AlertRuleScheduledIncidentArgsDict']] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] query_frequency: The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.str] query_period: The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.
               
               > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledSentinelEntityMappingArgs', 'AlertRuleScheduledSentinelEntityMappingArgsDict']]]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
               
               > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        :param pulumi.Input[_builtins.str] trigger_operator: The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        :param pulumi.Input[_builtins.int] trigger_threshold: The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertRuleScheduledArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel Scheduled Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_scheduled = azure.sentinel.AlertRuleScheduled("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example",
            severity="High",
            query=\"\"\"AzureActivity |
          where OperationName == "Create or Update Virtual Machine" or OperationName =="Create Deployment" |
          where ActivityStatus == "Succeeded" |
          make-series dcount(ResourceId) default=0 on EventSubmissionTimestamp in range(ago(7d), now(), 1d) by Caller
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2023-12-01-preview

        ## Import

        Sentinel Scheduled Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleScheduled:AlertRuleScheduled example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param AlertRuleScheduledArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertRuleScheduledArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledAlertDetailsOverrideArgs', 'AlertRuleScheduledAlertDetailsOverrideArgsDict']]]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledEntityMappingArgs', 'AlertRuleScheduledEntityMappingArgsDict']]]]] = None,
                 event_grouping: Optional[pulumi.Input[Union['AlertRuleScheduledEventGroupingArgs', 'AlertRuleScheduledEventGroupingArgsDict']]] = None,
                 incident: Optional[pulumi.Input[Union['AlertRuleScheduledIncidentArgs', 'AlertRuleScheduledIncidentArgsDict']]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 query_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 query_period: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledSentinelEntityMappingArgs', 'AlertRuleScheduledSentinelEntityMappingArgsDict']]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 trigger_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertRuleScheduledArgs.__new__(AlertRuleScheduledArgs)

            __props__.__dict__["alert_details_overrides"] = alert_details_overrides
            __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
            __props__.__dict__["alert_rule_template_version"] = alert_rule_template_version
            __props__.__dict__["custom_details"] = custom_details
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["entity_mappings"] = entity_mappings
            __props__.__dict__["event_grouping"] = event_grouping
            __props__.__dict__["incident"] = incident
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["query_frequency"] = query_frequency
            __props__.__dict__["query_period"] = query_period
            __props__.__dict__["sentinel_entity_mappings"] = sentinel_entity_mappings
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["suppression_duration"] = suppression_duration
            __props__.__dict__["suppression_enabled"] = suppression_enabled
            __props__.__dict__["tactics"] = tactics
            __props__.__dict__["techniques"] = techniques
            __props__.__dict__["trigger_operator"] = trigger_operator
            __props__.__dict__["trigger_threshold"] = trigger_threshold
        super(AlertRuleScheduled, __self__).__init__(
            'azure:sentinel/alertRuleScheduled:AlertRuleScheduled',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledAlertDetailsOverrideArgs', 'AlertRuleScheduledAlertDetailsOverrideArgsDict']]]]] = None,
            alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
            alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
            custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledEntityMappingArgs', 'AlertRuleScheduledEntityMappingArgsDict']]]]] = None,
            event_grouping: Optional[pulumi.Input[Union['AlertRuleScheduledEventGroupingArgs', 'AlertRuleScheduledEventGroupingArgsDict']]] = None,
            incident: Optional[pulumi.Input[Union['AlertRuleScheduledIncidentArgs', 'AlertRuleScheduledIncidentArgsDict']]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            query_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            query_period: Optional[pulumi.Input[_builtins.str]] = None,
            sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledSentinelEntityMappingArgs', 'AlertRuleScheduledSentinelEntityMappingArgsDict']]]]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
            suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            trigger_operator: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None) -> 'AlertRuleScheduled':
        """
        Get an existing AlertRuleScheduled resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledAlertDetailsOverrideArgs', 'AlertRuleScheduledAlertDetailsOverrideArgsDict']]]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledEntityMappingArgs', 'AlertRuleScheduledEntityMappingArgsDict']]]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input[Union['AlertRuleScheduledEventGroupingArgs', 'AlertRuleScheduledEventGroupingArgsDict']] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input[Union['AlertRuleScheduledIncidentArgs', 'AlertRuleScheduledIncidentArgsDict']] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel Scheduled Alert Rule.
        :param pulumi.Input[_builtins.str] query_frequency: The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.str] query_period: The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.
               
               > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleScheduledSentinelEntityMappingArgs', 'AlertRuleScheduledSentinelEntityMappingArgsDict']]]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
               
               > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        :param pulumi.Input[_builtins.str] trigger_operator: The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        :param pulumi.Input[_builtins.int] trigger_threshold: The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertRuleScheduledState.__new__(_AlertRuleScheduledState)

        __props__.__dict__["alert_details_overrides"] = alert_details_overrides
        __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
        __props__.__dict__["alert_rule_template_version"] = alert_rule_template_version
        __props__.__dict__["custom_details"] = custom_details
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_mappings"] = entity_mappings
        __props__.__dict__["event_grouping"] = event_grouping
        __props__.__dict__["incident"] = incident
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["query_frequency"] = query_frequency
        __props__.__dict__["query_period"] = query_period
        __props__.__dict__["sentinel_entity_mappings"] = sentinel_entity_mappings
        __props__.__dict__["severity"] = severity
        __props__.__dict__["suppression_duration"] = suppression_duration
        __props__.__dict__["suppression_enabled"] = suppression_enabled
        __props__.__dict__["tactics"] = tactics
        __props__.__dict__["techniques"] = techniques
        __props__.__dict__["trigger_operator"] = trigger_operator
        __props__.__dict__["trigger_threshold"] = trigger_threshold
        return AlertRuleScheduled(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertDetailsOverrides")
    def alert_details_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRuleScheduledAlertDetailsOverride']]]:
        """
        An `alert_details_override` block as defined below.
        """
        return pulumi.get(self, "alert_details_overrides")

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateVersion")
    def alert_rule_template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of the alert rule template which is used for this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "alert_rule_template_version")

    @_builtins.property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of string key-value pairs of columns to be attached to this Sentinel Scheduled Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        """
        return pulumi.get(self, "custom_details")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The friendly name of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Sentinel Scheduled Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="entityMappings")
    def entity_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRuleScheduledEntityMapping']]]:
        """
        A list of `entity_mapping` blocks as defined below.
        """
        return pulumi.get(self, "entity_mappings")

    @_builtins.property
    @pulumi.getter(name="eventGrouping")
    def event_grouping(self) -> pulumi.Output[Optional['outputs.AlertRuleScheduledEventGrouping']]:
        """
        A `event_grouping` block as defined below.
        """
        return pulumi.get(self, "event_grouping")

    @_builtins.property
    @pulumi.getter
    def incident(self) -> pulumi.Output['outputs.AlertRuleScheduledIncident']:
        """
        A `incident` block as defined below.
        """
        return pulumi.get(self, "incident")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel Scheduled Alert Rule belongs to. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Sentinel Scheduled Alert Rule. Changing this forces a new Sentinel Scheduled Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The query of this Sentinel Scheduled Alert Rule.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryFrequency")
    def query_frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ISO 8601 timespan duration between two consecutive queries. Defaults to `PT5H`.
        """
        return pulumi.get(self, "query_frequency")

    @_builtins.property
    @pulumi.getter(name="queryPeriod")
    def query_period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ISO 8601 timespan duration, which determine the time period of the data covered by the query. For example, it can query the past 10 minutes of data, or the past 6 hours of data. Defaults to `PT5H`.

        > **Note:** `query_period` must larger than or equal to `query_frequency`, which ensures there is no gaps in the overall query coverage.
        """
        return pulumi.get(self, "query_period")

    @_builtins.property
    @pulumi.getter(name="sentinelEntityMappings")
    def sentinel_entity_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRuleScheduledSentinelEntityMapping']]]:
        """
        A list of `sentinel_entity_mapping` blocks as defined below.

        > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 10.
        """
        return pulumi.get(self, "sentinel_entity_mappings")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        The alert severity of this Sentinel Scheduled Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.

        > **Note:** `suppression_duration` must larger than or equal to `query_frequency`, otherwise the suppression has no actual effect since no query will happen during the suppression duration.
        """
        return pulumi.get(self, "suppression_duration")

    @_builtins.property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Sentinel Scheduled Alert Rulea stop running query after alert is generated? Defaults to `false`.
        """
        return pulumi.get(self, "suppression_enabled")

    @_builtins.property
    @pulumi.getter
    def tactics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `ImpairProcessControl`, `InhibitResponseFunction`, `Impact`, `InitialAccess`, `LateralMovement`, `Persistence`, `PrivilegeEscalation`, `PreAttack`, `Reconnaissance` and `ResourceDevelopment`.
        """
        return pulumi.get(self, "tactics")

    @_builtins.property
    @pulumi.getter
    def techniques(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @_builtins.property
    @pulumi.getter(name="triggerOperator")
    def trigger_operator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The alert trigger operator, combined with `trigger_threshold`, setting alert threshold of this Sentinel Scheduled Alert Rule. Possible values are `Equal`, `GreaterThan`, `LessThan`, `NotEqual`. Defaults to `GreaterThan`.
        """
        return pulumi.get(self, "trigger_operator")

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The baseline number of query results generated, combined with `trigger_operator`, setting alert threshold of this Sentinel Scheduled Alert Rule. Defaults to `0`.
        """
        return pulumi.get(self, "trigger_threshold")

