# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedClusterArgs', 'ManagedCluster']

@pulumi.input_type
class ManagedClusterArgs:
    def __init__(__self__, *,
                 client_connection_port: pulumi.Input[_builtins.int],
                 http_gateway_port: pulumi.Input[_builtins.int],
                 lb_rules: pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 authentication: Optional[pulumi.Input['ManagedClusterAuthenticationArgs']] = None,
                 backup_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_wave: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedCluster resource.
        :param pulumi.Input[_builtins.int] client_connection_port: Port to use when connecting to the cluster.
        :param pulumi.Input[_builtins.int] http_gateway_port: Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]] lb_rules: One or more `lb_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input['ManagedClusterAuthenticationArgs'] authentication: Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        :param pulumi.Input[_builtins.bool] backup_service_enabled: If true, backup service is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]] custom_fabric_settings: One or more `custom_fabric_setting` blocks as defined below.
        :param pulumi.Input[_builtins.str] dns_name: Hostname for the cluster. If unset the cluster's name will be used..
        :param pulumi.Input[_builtins.bool] dns_service_enabled: If true, DNS service is enabled.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] password: Administrator password for the VMs that will be created as part of this cluster.
        :param pulumi.Input[_builtins.str] sku: SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Group.
        :param pulumi.Input[_builtins.str] upgrade_wave: Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        :param pulumi.Input[_builtins.str] username: Administrator password for the VMs that will be created as part of this cluster.
        """
        pulumi.set(__self__, "client_connection_port", client_connection_port)
        pulumi.set(__self__, "http_gateway_port", http_gateway_port)
        pulumi.set(__self__, "lb_rules", lb_rules)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if backup_service_enabled is not None:
            pulumi.set(__self__, "backup_service_enabled", backup_service_enabled)
        if custom_fabric_settings is not None:
            pulumi.set(__self__, "custom_fabric_settings", custom_fabric_settings)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dns_service_enabled is not None:
            pulumi.set(__self__, "dns_service_enabled", dns_service_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_types is not None:
            pulumi.set(__self__, "node_types", node_types)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_wave is not None:
            pulumi.set(__self__, "upgrade_wave", upgrade_wave)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="clientConnectionPort")
    def client_connection_port(self) -> pulumi.Input[_builtins.int]:
        """
        Port to use when connecting to the cluster.
        """
        return pulumi.get(self, "client_connection_port")

    @client_connection_port.setter
    def client_connection_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "client_connection_port", value)

    @_builtins.property
    @pulumi.getter(name="httpGatewayPort")
    def http_gateway_port(self) -> pulumi.Input[_builtins.int]:
        """
        Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        """
        return pulumi.get(self, "http_gateway_port")

    @http_gateway_port.setter
    def http_gateway_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "http_gateway_port", value)

    @_builtins.property
    @pulumi.getter(name="lbRules")
    def lb_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]]:
        """
        One or more `lb_rule` blocks as defined below.
        """
        return pulumi.get(self, "lb_rules")

    @lb_rules.setter
    def lb_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]]):
        pulumi.set(self, "lb_rules", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['ManagedClusterAuthenticationArgs']]:
        """
        Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['ManagedClusterAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="backupServiceEnabled")
    def backup_service_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, backup service is enabled.
        """
        return pulumi.get(self, "backup_service_enabled")

    @backup_service_enabled.setter
    def backup_service_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backup_service_enabled", value)

    @_builtins.property
    @pulumi.getter(name="customFabricSettings")
    def custom_fabric_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]]]:
        """
        One or more `custom_fabric_setting` blocks as defined below.
        """
        return pulumi.get(self, "custom_fabric_settings")

    @custom_fabric_settings.setter
    def custom_fabric_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]]]):
        pulumi.set(self, "custom_fabric_settings", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname for the cluster. If unset the cluster's name will be used..
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsServiceEnabled")
    def dns_service_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, DNS service is enabled.
        """
        return pulumi.get(self, "dns_service_enabled")

    @dns_service_enabled.setter
    def dns_service_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dns_service_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeTypes")
    def node_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]]]:
        """
        One or more `node_type` blocks as defined below.
        """
        return pulumi.get(self, "node_types")

    @node_types.setter
    def node_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]]]):
        pulumi.set(self, "node_types", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator password for the VMs that will be created as part of this cluster.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Resource Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradeWave")
    def upgrade_wave(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        """
        return pulumi.get(self, "upgrade_wave")

    @upgrade_wave.setter
    def upgrade_wave(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_wave", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator password for the VMs that will be created as part of this cluster.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ManagedClusterState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['ManagedClusterAuthenticationArgs']] = None,
                 backup_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_gateway_port: Optional[pulumi.Input[_builtins.int]] = None,
                 lb_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_wave: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedCluster resources.
        :param pulumi.Input['ManagedClusterAuthenticationArgs'] authentication: Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        :param pulumi.Input[_builtins.bool] backup_service_enabled: If true, backup service is enabled.
        :param pulumi.Input[_builtins.int] client_connection_port: Port to use when connecting to the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]] custom_fabric_settings: One or more `custom_fabric_setting` blocks as defined below.
        :param pulumi.Input[_builtins.str] dns_name: Hostname for the cluster. If unset the cluster's name will be used..
        :param pulumi.Input[_builtins.bool] dns_service_enabled: If true, DNS service is enabled.
        :param pulumi.Input[_builtins.int] http_gateway_port: Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]] lb_rules: One or more `lb_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] password: Administrator password for the VMs that will be created as part of this cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] sku: SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Group.
        :param pulumi.Input[_builtins.str] upgrade_wave: Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        :param pulumi.Input[_builtins.str] username: Administrator password for the VMs that will be created as part of this cluster.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if backup_service_enabled is not None:
            pulumi.set(__self__, "backup_service_enabled", backup_service_enabled)
        if client_connection_port is not None:
            pulumi.set(__self__, "client_connection_port", client_connection_port)
        if custom_fabric_settings is not None:
            pulumi.set(__self__, "custom_fabric_settings", custom_fabric_settings)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dns_service_enabled is not None:
            pulumi.set(__self__, "dns_service_enabled", dns_service_enabled)
        if http_gateway_port is not None:
            pulumi.set(__self__, "http_gateway_port", http_gateway_port)
        if lb_rules is not None:
            pulumi.set(__self__, "lb_rules", lb_rules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_types is not None:
            pulumi.set(__self__, "node_types", node_types)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_wave is not None:
            pulumi.set(__self__, "upgrade_wave", upgrade_wave)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['ManagedClusterAuthenticationArgs']]:
        """
        Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['ManagedClusterAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="backupServiceEnabled")
    def backup_service_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, backup service is enabled.
        """
        return pulumi.get(self, "backup_service_enabled")

    @backup_service_enabled.setter
    def backup_service_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backup_service_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientConnectionPort")
    def client_connection_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port to use when connecting to the cluster.
        """
        return pulumi.get(self, "client_connection_port")

    @client_connection_port.setter
    def client_connection_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_connection_port", value)

    @_builtins.property
    @pulumi.getter(name="customFabricSettings")
    def custom_fabric_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]]]:
        """
        One or more `custom_fabric_setting` blocks as defined below.
        """
        return pulumi.get(self, "custom_fabric_settings")

    @custom_fabric_settings.setter
    def custom_fabric_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterCustomFabricSettingArgs']]]]):
        pulumi.set(self, "custom_fabric_settings", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname for the cluster. If unset the cluster's name will be used..
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsServiceEnabled")
    def dns_service_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, DNS service is enabled.
        """
        return pulumi.get(self, "dns_service_enabled")

    @dns_service_enabled.setter
    def dns_service_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dns_service_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpGatewayPort")
    def http_gateway_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        """
        return pulumi.get(self, "http_gateway_port")

    @http_gateway_port.setter
    def http_gateway_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_gateway_port", value)

    @_builtins.property
    @pulumi.getter(name="lbRules")
    def lb_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]]]:
        """
        One or more `lb_rule` blocks as defined below.
        """
        return pulumi.get(self, "lb_rules")

    @lb_rules.setter
    def lb_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterLbRuleArgs']]]]):
        pulumi.set(self, "lb_rules", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeTypes")
    def node_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]]]:
        """
        One or more `node_type` blocks as defined below.
        """
        return pulumi.get(self, "node_types")

    @node_types.setter
    def node_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterNodeTypeArgs']]]]):
        pulumi.set(self, "node_types", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator password for the VMs that will be created as part of this cluster.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Resource Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradeWave")
    def upgrade_wave(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        """
        return pulumi.get(self, "upgrade_wave")

    @upgrade_wave.setter
    def upgrade_wave(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_wave", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator password for the VMs that will be created as part of this cluster.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("azure:servicefabric/managedCluster:ManagedCluster")
class ManagedCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['ManagedClusterAuthenticationArgs', 'ManagedClusterAuthenticationArgsDict']]] = None,
                 backup_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterCustomFabricSettingArgs', 'ManagedClusterCustomFabricSettingArgsDict']]]]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_gateway_port: Optional[pulumi.Input[_builtins.int]] = None,
                 lb_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterLbRuleArgs', 'ManagedClusterLbRuleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterNodeTypeArgs', 'ManagedClusterNodeTypeArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_wave: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Resource Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.servicefabric.ManagedCluster("example",
            name="example",
            resource_group_name="example",
            location="West Europe",
            http_gateway_port=4567,
            lb_rules=[{
                "backend_port": 38080,
                "frontend_port": 80,
                "probe_protocol": "http",
                "probe_request_path": "/test",
                "protocol": "tcp",
            }],
            client_connection_port=12345,
            node_types=[{
                "data_disk_size_gb": 130,
                "name": "test1",
                "primary": True,
                "application_port_range": "30000-49000",
                "ephemeral_port_range": "10000-20000",
                "vm_size": "Standard_DS1_v2",
                "vm_image_publisher": "MicrosoftWindowsServer",
                "vm_image_sku": "2019-Datacenter-with-Containers",
                "vm_image_offer": "WindowsServer",
                "vm_image_version": "latest",
                "vm_instance_count": 5,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceFabric`: 2024-04-01

        ## Import

        Resource Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicefabric/managedCluster:ManagedCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.ServiceFabric/managedClusters/clusterName1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedClusterAuthenticationArgs', 'ManagedClusterAuthenticationArgsDict']] authentication: Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        :param pulumi.Input[_builtins.bool] backup_service_enabled: If true, backup service is enabled.
        :param pulumi.Input[_builtins.int] client_connection_port: Port to use when connecting to the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterCustomFabricSettingArgs', 'ManagedClusterCustomFabricSettingArgsDict']]]] custom_fabric_settings: One or more `custom_fabric_setting` blocks as defined below.
        :param pulumi.Input[_builtins.str] dns_name: Hostname for the cluster. If unset the cluster's name will be used..
        :param pulumi.Input[_builtins.bool] dns_service_enabled: If true, DNS service is enabled.
        :param pulumi.Input[_builtins.int] http_gateway_port: Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterLbRuleArgs', 'ManagedClusterLbRuleArgsDict']]]] lb_rules: One or more `lb_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterNodeTypeArgs', 'ManagedClusterNodeTypeArgsDict']]]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] password: Administrator password for the VMs that will be created as part of this cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] sku: SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Group.
        :param pulumi.Input[_builtins.str] upgrade_wave: Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        :param pulumi.Input[_builtins.str] username: Administrator password for the VMs that will be created as part of this cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Resource Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.servicefabric.ManagedCluster("example",
            name="example",
            resource_group_name="example",
            location="West Europe",
            http_gateway_port=4567,
            lb_rules=[{
                "backend_port": 38080,
                "frontend_port": 80,
                "probe_protocol": "http",
                "probe_request_path": "/test",
                "protocol": "tcp",
            }],
            client_connection_port=12345,
            node_types=[{
                "data_disk_size_gb": 130,
                "name": "test1",
                "primary": True,
                "application_port_range": "30000-49000",
                "ephemeral_port_range": "10000-20000",
                "vm_size": "Standard_DS1_v2",
                "vm_image_publisher": "MicrosoftWindowsServer",
                "vm_image_sku": "2019-Datacenter-with-Containers",
                "vm_image_offer": "WindowsServer",
                "vm_image_version": "latest",
                "vm_instance_count": 5,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceFabric`: 2024-04-01

        ## Import

        Resource Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicefabric/managedCluster:ManagedCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.ServiceFabric/managedClusters/clusterName1
        ```

        :param str resource_name: The name of the resource.
        :param ManagedClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['ManagedClusterAuthenticationArgs', 'ManagedClusterAuthenticationArgsDict']]] = None,
                 backup_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_connection_port: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterCustomFabricSettingArgs', 'ManagedClusterCustomFabricSettingArgsDict']]]]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_gateway_port: Optional[pulumi.Input[_builtins.int]] = None,
                 lb_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterLbRuleArgs', 'ManagedClusterLbRuleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterNodeTypeArgs', 'ManagedClusterNodeTypeArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_wave: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedClusterArgs.__new__(ManagedClusterArgs)

            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["backup_service_enabled"] = backup_service_enabled
            if client_connection_port is None and not opts.urn:
                raise TypeError("Missing required property 'client_connection_port'")
            __props__.__dict__["client_connection_port"] = client_connection_port
            __props__.__dict__["custom_fabric_settings"] = custom_fabric_settings
            __props__.__dict__["dns_name"] = dns_name
            __props__.__dict__["dns_service_enabled"] = dns_service_enabled
            if http_gateway_port is None and not opts.urn:
                raise TypeError("Missing required property 'http_gateway_port'")
            __props__.__dict__["http_gateway_port"] = http_gateway_port
            if lb_rules is None and not opts.urn:
                raise TypeError("Missing required property 'lb_rules'")
            __props__.__dict__["lb_rules"] = lb_rules
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["node_types"] = node_types
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku"] = sku
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgrade_wave"] = upgrade_wave
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedCluster, __self__).__init__(
            'azure:servicefabric/managedCluster:ManagedCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['ManagedClusterAuthenticationArgs', 'ManagedClusterAuthenticationArgsDict']]] = None,
            backup_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_connection_port: Optional[pulumi.Input[_builtins.int]] = None,
            custom_fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterCustomFabricSettingArgs', 'ManagedClusterCustomFabricSettingArgsDict']]]]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_service_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            http_gateway_port: Optional[pulumi.Input[_builtins.int]] = None,
            lb_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterLbRuleArgs', 'ManagedClusterLbRuleArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterNodeTypeArgs', 'ManagedClusterNodeTypeArgsDict']]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            upgrade_wave: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedCluster':
        """
        Get an existing ManagedCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedClusterAuthenticationArgs', 'ManagedClusterAuthenticationArgsDict']] authentication: Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        :param pulumi.Input[_builtins.bool] backup_service_enabled: If true, backup service is enabled.
        :param pulumi.Input[_builtins.int] client_connection_port: Port to use when connecting to the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterCustomFabricSettingArgs', 'ManagedClusterCustomFabricSettingArgsDict']]]] custom_fabric_settings: One or more `custom_fabric_setting` blocks as defined below.
        :param pulumi.Input[_builtins.str] dns_name: Hostname for the cluster. If unset the cluster's name will be used..
        :param pulumi.Input[_builtins.bool] dns_service_enabled: If true, DNS service is enabled.
        :param pulumi.Input[_builtins.int] http_gateway_port: Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterLbRuleArgs', 'ManagedClusterLbRuleArgsDict']]]] lb_rules: One or more `lb_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedClusterNodeTypeArgs', 'ManagedClusterNodeTypeArgsDict']]]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] password: Administrator password for the VMs that will be created as part of this cluster.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[_builtins.str] sku: SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Group.
        :param pulumi.Input[_builtins.str] upgrade_wave: Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        :param pulumi.Input[_builtins.str] username: Administrator password for the VMs that will be created as part of this cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedClusterState.__new__(_ManagedClusterState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["backup_service_enabled"] = backup_service_enabled
        __props__.__dict__["client_connection_port"] = client_connection_port
        __props__.__dict__["custom_fabric_settings"] = custom_fabric_settings
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["dns_service_enabled"] = dns_service_enabled
        __props__.__dict__["http_gateway_port"] = http_gateway_port
        __props__.__dict__["lb_rules"] = lb_rules
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["node_types"] = node_types
        __props__.__dict__["password"] = password
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["upgrade_wave"] = upgrade_wave
        __props__.__dict__["username"] = username
        return ManagedCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[Optional['outputs.ManagedClusterAuthentication']]:
        """
        Controls how connections to the cluster are authenticated. A `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="backupServiceEnabled")
    def backup_service_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, backup service is enabled.
        """
        return pulumi.get(self, "backup_service_enabled")

    @_builtins.property
    @pulumi.getter(name="clientConnectionPort")
    def client_connection_port(self) -> pulumi.Output[_builtins.int]:
        """
        Port to use when connecting to the cluster.
        """
        return pulumi.get(self, "client_connection_port")

    @_builtins.property
    @pulumi.getter(name="customFabricSettings")
    def custom_fabric_settings(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedClusterCustomFabricSetting']]]:
        """
        One or more `custom_fabric_setting` blocks as defined below.
        """
        return pulumi.get(self, "custom_fabric_settings")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        Hostname for the cluster. If unset the cluster's name will be used..
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnsServiceEnabled")
    def dns_service_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, DNS service is enabled.
        """
        return pulumi.get(self, "dns_service_enabled")

    @_builtins.property
    @pulumi.getter(name="httpGatewayPort")
    def http_gateway_port(self) -> pulumi.Output[_builtins.int]:
        """
        Port that should be used by the Service Fabric Explorer to visualize applications and cluster status.
        """
        return pulumi.get(self, "http_gateway_port")

    @_builtins.property
    @pulumi.getter(name="lbRules")
    def lb_rules(self) -> pulumi.Output[Sequence['outputs.ManagedClusterLbRule']]:
        """
        One or more `lb_rule` blocks as defined below.
        """
        return pulumi.get(self, "lb_rules")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Resource Group. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeTypes")
    def node_types(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedClusterNodeType']]]:
        """
        One or more `node_type` blocks as defined below.
        """
        return pulumi.get(self, "node_types")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Administrator password for the VMs that will be created as part of this cluster.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Resource Group should exist. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SKU for this cluster. Changing this forces a new resource to be created. Default is `Basic`, allowed values are either `Basic` or `Standard`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource ID of the Subnet. Changing this forces a new Resource Group to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Resource Group.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="upgradeWave")
    def upgrade_wave(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Upgrade wave for the fabric runtime. Default is `Wave0`, allowed value must be one of `Wave0`, `Wave1`, or `Wave2`.
        """
        return pulumi.get(self, "upgrade_wave")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Administrator password for the VMs that will be created as part of this cluster.
        """
        return pulumi.get(self, "username")

