# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceCustomCertificateArgs', 'ServiceCustomCertificate']

@pulumi.input_type
class ServiceCustomCertificateArgs:
    def __init__(__self__, *,
                 custom_certificate_id: pulumi.Input[_builtins.str],
                 signalr_service_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceCustomCertificate resource.
        :param pulumi.Input[_builtins.str] custom_certificate_id: The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.
               
               > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        :param pulumi.Input[_builtins.str] signalr_service_id: The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.
               
               > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        :param pulumi.Input[_builtins.str] name: The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "custom_certificate_id", custom_certificate_id)
        pulumi.set(__self__, "signalr_service_id", signalr_service_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="customCertificateId")
    def custom_certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.

        > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        """
        return pulumi.get(self, "custom_certificate_id")

    @custom_certificate_id.setter
    def custom_certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="signalrServiceId")
    def signalr_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.

        > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        """
        return pulumi.get(self, "signalr_service_id")

    @signalr_service_id.setter
    def signalr_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signalr_service_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ServiceCustomCertificateState:
    def __init__(__self__, *,
                 certificate_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceCustomCertificate resources.
        :param pulumi.Input[_builtins.str] certificate_version: The certificate version of the SignalR Custom Certificate service.
        :param pulumi.Input[_builtins.str] custom_certificate_id: The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.
               
               > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        :param pulumi.Input[_builtins.str] name: The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.
               
               > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        """
        if certificate_version is not None:
            pulumi.set(__self__, "certificate_version", certificate_version)
        if custom_certificate_id is not None:
            pulumi.set(__self__, "custom_certificate_id", custom_certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signalr_service_id is not None:
            pulumi.set(__self__, "signalr_service_id", signalr_service_id)

    @_builtins.property
    @pulumi.getter(name="certificateVersion")
    def certificate_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate version of the SignalR Custom Certificate service.
        """
        return pulumi.get(self, "certificate_version")

    @certificate_version.setter
    def certificate_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_version", value)

    @_builtins.property
    @pulumi.getter(name="customCertificateId")
    def custom_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.

        > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        """
        return pulumi.get(self, "custom_certificate_id")

    @custom_certificate_id.setter
    def custom_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="signalrServiceId")
    def signalr_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.

        > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        """
        return pulumi.get(self, "signalr_service_id")

    @signalr_service_id.setter
    def signalr_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signalr_service_id", value)


@pulumi.type_token("azure:signalr/serviceCustomCertificate:ServiceCustomCertificate")
class ServiceCustomCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure SignalR Custom Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.signalr.Service("example",
            name="example-signalr",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            sku={
                "name": "Premium_P1",
                "capacity": 1,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": test_azurerm_signalr_service["identity"][0]["principalId"],
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        test = azure.signalr.ServiceCustomCertificate("test",
            name="example-cert",
            signalr_service_id=example_service.id,
            custom_certificate_id=example_certificate.id,
            opts = pulumi.ResourceOptions(depends_on=[example_azurerm_key_vault_access_policy]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Custom Certificate for a SignalR service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:signalr/serviceCustomCertificate:ServiceCustomCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/signalR/signalr1/customCertificates/cert1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_certificate_id: The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.
               
               > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        :param pulumi.Input[_builtins.str] name: The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.
               
               > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceCustomCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure SignalR Custom Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.signalr.Service("example",
            name="example-signalr",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            sku={
                "name": "Premium_P1",
                "capacity": 1,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": test_azurerm_signalr_service["identity"][0]["principalId"],
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        test = azure.signalr.ServiceCustomCertificate("test",
            name="example-cert",
            signalr_service_id=example_service.id,
            custom_certificate_id=example_certificate.id,
            opts = pulumi.ResourceOptions(depends_on=[example_azurerm_key_vault_access_policy]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Custom Certificate for a SignalR service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:signalr/serviceCustomCertificate:ServiceCustomCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/signalR/signalr1/customCertificates/cert1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceCustomCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceCustomCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceCustomCertificateArgs.__new__(ServiceCustomCertificateArgs)

            if custom_certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_certificate_id'")
            __props__.__dict__["custom_certificate_id"] = custom_certificate_id
            __props__.__dict__["name"] = name
            if signalr_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'signalr_service_id'")
            __props__.__dict__["signalr_service_id"] = signalr_service_id
            __props__.__dict__["certificate_version"] = None
        super(ServiceCustomCertificate, __self__).__init__(
            'azure:signalr/serviceCustomCertificate:ServiceCustomCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_version: Optional[pulumi.Input[_builtins.str]] = None,
            custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceCustomCertificate':
        """
        Get an existing ServiceCustomCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_version: The certificate version of the SignalR Custom Certificate service.
        :param pulumi.Input[_builtins.str] custom_certificate_id: The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.
               
               > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        :param pulumi.Input[_builtins.str] name: The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.
               
               > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceCustomCertificateState.__new__(_ServiceCustomCertificateState)

        __props__.__dict__["certificate_version"] = certificate_version
        __props__.__dict__["custom_certificate_id"] = custom_certificate_id
        __props__.__dict__["name"] = name
        __props__.__dict__["signalr_service_id"] = signalr_service_id
        return ServiceCustomCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateVersion")
    def certificate_version(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate version of the SignalR Custom Certificate service.
        """
        return pulumi.get(self, "certificate_version")

    @_builtins.property
    @pulumi.getter(name="customCertificateId")
    def custom_certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate id of the SignalR Custom Certificate service. Changing this forces a new resource to be created.

        > **Note:** Self assigned certificate is not supported and the provisioning status will fail.
        """
        return pulumi.get(self, "custom_certificate_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SignalR Custom Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signalrServiceId")
    def signalr_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The SignalR ID of the SignalR Custom Certificate. Changing this forces a new resource to be created.

        > **Note:** Custom Certificate is only available for SignalR Premium tier. Please enable managed identity in the corresponding SignalR Service and give the managed identity access to the key vault, the required permission is Get Certificate and Secret.
        """
        return pulumi.get(self, "signalr_service_id")

