# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HciClusterArgs', 'HciCluster']

@pulumi.input_type
class HciClusterArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 automanage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['HciClusterIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HciCluster resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] automanage_configuration_id: The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['HciClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
               
               > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if automanage_configuration_id is not None:
            pulumi.set(__self__, "automanage_configuration_id", automanage_configuration_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="automanageConfigurationId")
    def automanage_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "automanage_configuration_id")

    @automanage_configuration_id.setter
    def automanage_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automanage_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['HciClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['HciClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.

        > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _HciClusterState:
    def __init__(__self__, *,
                 automanage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['HciClusterIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_provider_object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HciCluster resources.
        :param pulumi.Input[_builtins.str] automanage_configuration_id: The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cloud_id: An immutable UUID for the Azure Stack HCI Cluster.
        :param pulumi.Input['HciClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_provider_object_id: The object ID of the Resource Provider Service Principal.
        :param pulumi.Input[_builtins.str] service_endpoint: The region specific Data Path Endpoint of the Azure Stack HCI Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
               
               > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        if automanage_configuration_id is not None:
            pulumi.set(__self__, "automanage_configuration_id", automanage_configuration_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_provider_object_id is not None:
            pulumi.set(__self__, "resource_provider_object_id", resource_provider_object_id)
        if service_endpoint is not None:
            pulumi.set(__self__, "service_endpoint", service_endpoint)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="automanageConfigurationId")
    def automanage_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "automanage_configuration_id")

    @automanage_configuration_id.setter
    def automanage_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automanage_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An immutable UUID for the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['HciClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['HciClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceProviderObjectId")
    def resource_provider_object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object ID of the Resource Provider Service Principal.
        """
        return pulumi.get(self, "resource_provider_object_id")

    @resource_provider_object_id.setter
    def resource_provider_object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_provider_object_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region specific Data Path Endpoint of the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "service_endpoint")

    @service_endpoint.setter
    def service_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.

        > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:stack/hciCluster:HciCluster")
class HciCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automanage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['HciClusterIdentityArgs', 'HciClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Stack HCI Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azuread.get_application(display_name="Allowed resource types")
        current = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_hci_cluster = azure.stack.HciCluster("example",
            name="example-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            client_id=example.application_id,
            tenant_id=current.tenant_id,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AutoManage`: 2022-05-04

        * `Microsoft.AzureStackHCI`: 2024-01-01, 2022-05-04

        ## Import

        Azure Stack HCI Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciCluster:HciCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AzureStackHCI/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automanage_configuration_id: The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HciClusterIdentityArgs', 'HciClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
               
               > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HciClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Stack HCI Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azuread.get_application(display_name="Allowed resource types")
        current = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_hci_cluster = azure.stack.HciCluster("example",
            name="example-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            client_id=example.application_id,
            tenant_id=current.tenant_id,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AutoManage`: 2022-05-04

        * `Microsoft.AzureStackHCI`: 2024-01-01, 2022-05-04

        ## Import

        Azure Stack HCI Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciCluster:HciCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AzureStackHCI/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param HciClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HciClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automanage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['HciClusterIdentityArgs', 'HciClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HciClusterArgs.__new__(HciClusterArgs)

            __props__.__dict__["automanage_configuration_id"] = automanage_configuration_id
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["cloud_id"] = None
            __props__.__dict__["resource_provider_object_id"] = None
            __props__.__dict__["service_endpoint"] = None
        super(HciCluster, __self__).__init__(
            'azure:stack/hciCluster:HciCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automanage_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['HciClusterIdentityArgs', 'HciClusterIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_provider_object_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'HciCluster':
        """
        Get an existing HciCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automanage_configuration_id: The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] client_id: The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cloud_id: An immutable UUID for the Azure Stack HCI Cluster.
        :param pulumi.Input[Union['HciClusterIdentityArgs', 'HciClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_provider_object_id: The object ID of the Resource Provider Service Principal.
        :param pulumi.Input[_builtins.str] service_endpoint: The region specific Data Path Endpoint of the Azure Stack HCI Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
               
               > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HciClusterState.__new__(_HciClusterState)

        __props__.__dict__["automanage_configuration_id"] = automanage_configuration_id
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["resource_provider_object_id"] = resource_provider_object_id
        __props__.__dict__["service_endpoint"] = service_endpoint
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return HciCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automanageConfigurationId")
    def automanage_configuration_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Automanage Configuration assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "automanage_configuration_id")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client ID of the Azure Active Directory Application which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        An immutable UUID for the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.HciClusterIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Stack HCI Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="resourceProviderObjectId")
    def resource_provider_object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The object ID of the Resource Provider Service Principal.
        """
        return pulumi.get(self, "resource_provider_object_id")

    @_builtins.property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The region specific Data Path Endpoint of the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "service_endpoint")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.

        > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        return pulumi.get(self, "tenant_id")

