# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBlobResult',
    'AwaitableGetBlobResult',
    'get_blob',
    'get_blob_output',
]

@pulumi.output_type
class GetBlobResult:
    """
    A collection of values returned by getBlob.
    """
    def __init__(__self__, access_tier=None, content_md5=None, content_type=None, encryption_scope=None, id=None, metadata=None, name=None, storage_account_name=None, storage_container_name=None, type=None, url=None):
        if access_tier and not isinstance(access_tier, str):
            raise TypeError("Expected argument 'access_tier' to be a str")
        pulumi.set(__self__, "access_tier", access_tier)
        if content_md5 and not isinstance(content_md5, str):
            raise TypeError("Expected argument 'content_md5' to be a str")
        pulumi.set(__self__, "content_md5", content_md5)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if encryption_scope and not isinstance(encryption_scope, str):
            raise TypeError("Expected argument 'encryption_scope' to be a str")
        pulumi.set(__self__, "encryption_scope", encryption_scope)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if storage_account_name and not isinstance(storage_account_name, str):
            raise TypeError("Expected argument 'storage_account_name' to be a str")
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_container_name and not isinstance(storage_container_name, str):
            raise TypeError("Expected argument 'storage_container_name' to be a str")
        pulumi.set(__self__, "storage_container_name", storage_container_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> _builtins.str:
        """
        The access tier of the storage blob.
        """
        return pulumi.get(self, "access_tier")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> _builtins.str:
        """
        The MD5 sum of the blob contents.
        """
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The content type of the storage blob.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="encryptionScope")
    def encryption_scope(self) -> _builtins.str:
        """
        The encryption scope for this blob.
        """
        return pulumi.get(self, "encryption_scope")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        A map of custom blob metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> _builtins.str:
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> _builtins.str:
        return pulumi.get(self, "storage_container_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the storage blob
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The URL of the storage blob.
        """
        return pulumi.get(self, "url")


class AwaitableGetBlobResult(GetBlobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBlobResult(
            access_tier=self.access_tier,
            content_md5=self.content_md5,
            content_type=self.content_type,
            encryption_scope=self.encryption_scope,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            storage_account_name=self.storage_account_name,
            storage_container_name=self.storage_container_name,
            type=self.type,
            url=self.url)


def get_blob(metadata: Optional[Mapping[str, _builtins.str]] = None,
             name: Optional[_builtins.str] = None,
             storage_account_name: Optional[_builtins.str] = None,
             storage_container_name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBlobResult:
    """
    Use this data source to access information about an existing Storage Blob.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_blob(name="example-blob-name",
        storage_account_name="example-storage-account-name",
        storage_container_name="example-storage-container-name")
    ```


    :param Mapping[str, _builtins.str] metadata: A map of custom blob metadata.
    :param _builtins.str name: The name of the Blob.
    :param _builtins.str storage_account_name: The name of the Storage Account where the Container exists.
    :param _builtins.str storage_container_name: The name of the Storage Container where the Blob exists.
    """
    __args__ = dict()
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['storageAccountName'] = storage_account_name
    __args__['storageContainerName'] = storage_container_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getBlob:getBlob', __args__, opts=opts, typ=GetBlobResult).value

    return AwaitableGetBlobResult(
        access_tier=pulumi.get(__ret__, 'access_tier'),
        content_md5=pulumi.get(__ret__, 'content_md5'),
        content_type=pulumi.get(__ret__, 'content_type'),
        encryption_scope=pulumi.get(__ret__, 'encryption_scope'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        storage_account_name=pulumi.get(__ret__, 'storage_account_name'),
        storage_container_name=pulumi.get(__ret__, 'storage_container_name'),
        type=pulumi.get(__ret__, 'type'),
        url=pulumi.get(__ret__, 'url'))
def get_blob_output(metadata: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    name: Optional[pulumi.Input[_builtins.str]] = None,
                    storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                    storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBlobResult]:
    """
    Use this data source to access information about an existing Storage Blob.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_blob(name="example-blob-name",
        storage_account_name="example-storage-account-name",
        storage_container_name="example-storage-container-name")
    ```


    :param Mapping[str, _builtins.str] metadata: A map of custom blob metadata.
    :param _builtins.str name: The name of the Blob.
    :param _builtins.str storage_account_name: The name of the Storage Account where the Container exists.
    :param _builtins.str storage_container_name: The name of the Storage Container where the Blob exists.
    """
    __args__ = dict()
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['storageAccountName'] = storage_account_name
    __args__['storageContainerName'] = storage_container_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getBlob:getBlob', __args__, opts=opts, typ=GetBlobResult)
    return __ret__.apply(lambda __response__: GetBlobResult(
        access_tier=pulumi.get(__response__, 'access_tier'),
        content_md5=pulumi.get(__response__, 'content_md5'),
        content_type=pulumi.get(__response__, 'content_type'),
        encryption_scope=pulumi.get(__response__, 'encryption_scope'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        storage_account_name=pulumi.get(__response__, 'storage_account_name'),
        storage_container_name=pulumi.get(__response__, 'storage_container_name'),
        type=pulumi.get(__response__, 'type'),
        url=pulumi.get(__response__, 'url')))
