# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LocalUserArgs', 'LocalUser']

@pulumi.input_type
class LocalUserArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[_builtins.str],
                 home_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]]] = None,
                 ssh_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_password_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LocalUser resource.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        :param pulumi.Input[_builtins.str] home_directory: The home directory of the Storage Account Local User.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        :param pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]] permission_scopes: One or more `permission_scope` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]] ssh_authorized_keys: One or more `ssh_authorized_key` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ssh_key_enabled: Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] ssh_password_enabled: Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if home_directory is not None:
            pulumi.set(__self__, "home_directory", home_directory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission_scopes is not None:
            pulumi.set(__self__, "permission_scopes", permission_scopes)
        if ssh_authorized_keys is not None:
            pulumi.set(__self__, "ssh_authorized_keys", ssh_authorized_keys)
        if ssh_key_enabled is not None:
            pulumi.set(__self__, "ssh_key_enabled", ssh_key_enabled)
        if ssh_password_enabled is not None:
            pulumi.set(__self__, "ssh_password_enabled", ssh_password_enabled)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The home directory of the Storage Account Local User.
        """
        return pulumi.get(self, "home_directory")

    @home_directory.setter
    def home_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_directory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="permissionScopes")
    def permission_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]]]:
        """
        One or more `permission_scope` blocks as defined below.
        """
        return pulumi.get(self, "permission_scopes")

    @permission_scopes.setter
    def permission_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]]]):
        pulumi.set(self, "permission_scopes", value)

    @_builtins.property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]]]:
        """
        One or more `ssh_authorized_key` blocks as defined below.
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @ssh_authorized_keys.setter
    def ssh_authorized_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]]]):
        pulumi.set(self, "ssh_authorized_keys", value)

    @_builtins.property
    @pulumi.getter(name="sshKeyEnabled")
    def ssh_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ssh_key_enabled")

    @ssh_key_enabled.setter
    def ssh_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sshPasswordEnabled")
    def ssh_password_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ssh_password_enabled")

    @ssh_password_enabled.setter
    def ssh_password_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_password_enabled", value)


@pulumi.input_type
class _LocalUserState:
    def __init__(__self__, *,
                 home_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]]] = None,
                 sid: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]]] = None,
                 ssh_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_password_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LocalUser resources.
        :param pulumi.Input[_builtins.str] home_directory: The home directory of the Storage Account Local User.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        :param pulumi.Input[_builtins.str] password: The value of the password, which is only available when `ssh_password_enabled` is set to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]] permission_scopes: One or more `permission_scope` blocks as defined below.
        :param pulumi.Input[_builtins.str] sid: The unique Security Identifier of this Storage Account Local User.
        :param pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]] ssh_authorized_keys: One or more `ssh_authorized_key` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ssh_key_enabled: Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] ssh_password_enabled: Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        """
        if home_directory is not None:
            pulumi.set(__self__, "home_directory", home_directory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permission_scopes is not None:
            pulumi.set(__self__, "permission_scopes", permission_scopes)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if ssh_authorized_keys is not None:
            pulumi.set(__self__, "ssh_authorized_keys", ssh_authorized_keys)
        if ssh_key_enabled is not None:
            pulumi.set(__self__, "ssh_key_enabled", ssh_key_enabled)
        if ssh_password_enabled is not None:
            pulumi.set(__self__, "ssh_password_enabled", ssh_password_enabled)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The home directory of the Storage Account Local User.
        """
        return pulumi.get(self, "home_directory")

    @home_directory.setter
    def home_directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_directory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the password, which is only available when `ssh_password_enabled` is set to `true`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="permissionScopes")
    def permission_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]]]:
        """
        One or more `permission_scope` blocks as defined below.
        """
        return pulumi.get(self, "permission_scopes")

    @permission_scopes.setter
    def permission_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserPermissionScopeArgs']]]]):
        pulumi.set(self, "permission_scopes", value)

    @_builtins.property
    @pulumi.getter
    def sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique Security Identifier of this Storage Account Local User.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sid", value)

    @_builtins.property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]]]:
        """
        One or more `ssh_authorized_key` blocks as defined below.
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @ssh_authorized_keys.setter
    def ssh_authorized_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalUserSshAuthorizedKeyArgs']]]]):
        pulumi.set(self, "ssh_authorized_keys", value)

    @_builtins.property
    @pulumi.getter(name="sshKeyEnabled")
    def ssh_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ssh_key_enabled")

    @ssh_key_enabled.setter
    def ssh_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sshPasswordEnabled")
    def ssh_password_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ssh_password_enabled")

    @ssh_password_enabled.setter
    def ssh_password_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_password_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.type_token("azure:storage/localUser:LocalUser")
class LocalUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 home_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocalUserPermissionScopeArgs', 'LocalUserPermissionScopeArgsDict']]]]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocalUserSshAuthorizedKeyArgs', 'LocalUserSshAuthorizedKeyArgsDict']]]]] = None,
                 ssh_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_password_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Storage Account Local User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="WestEurope")
        example_account = azure.storage.Account("example",
            name="example-account",
            resource_group_name=example.name,
            location=example.location,
            account_kind="StorageV2",
            account_tier="Standard",
            account_replication_type="LRS",
            is_hns_enabled=True)
        example_container = azure.storage.Container("example",
            name="example-container",
            storage_account_name=example_account.name)
        example_local_user = azure.storage.LocalUser("example",
            name="user1",
            storage_account_id=example_account.id,
            ssh_key_enabled=True,
            ssh_password_enabled=True,
            home_directory="example_path",
            ssh_authorized_keys=[
                {
                    "description": "key1",
                    "key": first_public_key,
                },
                {
                    "description": "key2",
                    "key": second_public_key,
                },
            ],
            permission_scopes=[{
                "permissions": {
                    "read": True,
                    "create": True,
                },
                "service": "blob",
                "resource_name": example_container.name,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Account Local Users can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/localUser:LocalUser example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Storage/storageAccounts/storageAccount1/localUsers/user1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] home_directory: The home directory of the Storage Account Local User.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LocalUserPermissionScopeArgs', 'LocalUserPermissionScopeArgsDict']]]] permission_scopes: One or more `permission_scope` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LocalUserSshAuthorizedKeyArgs', 'LocalUserSshAuthorizedKeyArgsDict']]]] ssh_authorized_keys: One or more `ssh_authorized_key` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ssh_key_enabled: Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] ssh_password_enabled: Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocalUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Account Local User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="WestEurope")
        example_account = azure.storage.Account("example",
            name="example-account",
            resource_group_name=example.name,
            location=example.location,
            account_kind="StorageV2",
            account_tier="Standard",
            account_replication_type="LRS",
            is_hns_enabled=True)
        example_container = azure.storage.Container("example",
            name="example-container",
            storage_account_name=example_account.name)
        example_local_user = azure.storage.LocalUser("example",
            name="user1",
            storage_account_id=example_account.id,
            ssh_key_enabled=True,
            ssh_password_enabled=True,
            home_directory="example_path",
            ssh_authorized_keys=[
                {
                    "description": "key1",
                    "key": first_public_key,
                },
                {
                    "description": "key2",
                    "key": second_public_key,
                },
            ],
            permission_scopes=[{
                "permissions": {
                    "read": True,
                    "create": True,
                },
                "service": "blob",
                "resource_name": example_container.name,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Storage`: 2023-05-01

        ## Import

        Storage Account Local Users can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/localUser:LocalUser example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Storage/storageAccounts/storageAccount1/localUsers/user1
        ```

        :param str resource_name: The name of the resource.
        :param LocalUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocalUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 home_directory: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocalUserPermissionScopeArgs', 'LocalUserPermissionScopeArgsDict']]]]] = None,
                 ssh_authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocalUserSshAuthorizedKeyArgs', 'LocalUserSshAuthorizedKeyArgsDict']]]]] = None,
                 ssh_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_password_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocalUserArgs.__new__(LocalUserArgs)

            __props__.__dict__["home_directory"] = home_directory
            __props__.__dict__["name"] = name
            __props__.__dict__["permission_scopes"] = permission_scopes
            __props__.__dict__["ssh_authorized_keys"] = ssh_authorized_keys
            __props__.__dict__["ssh_key_enabled"] = ssh_key_enabled
            __props__.__dict__["ssh_password_enabled"] = ssh_password_enabled
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["password"] = None
            __props__.__dict__["sid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "sid"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LocalUser, __self__).__init__(
            'azure:storage/localUser:LocalUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            home_directory: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            permission_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocalUserPermissionScopeArgs', 'LocalUserPermissionScopeArgsDict']]]]] = None,
            sid: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_authorized_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LocalUserSshAuthorizedKeyArgs', 'LocalUserSshAuthorizedKeyArgsDict']]]]] = None,
            ssh_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ssh_password_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LocalUser':
        """
        Get an existing LocalUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] home_directory: The home directory of the Storage Account Local User.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        :param pulumi.Input[_builtins.str] password: The value of the password, which is only available when `ssh_password_enabled` is set to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LocalUserPermissionScopeArgs', 'LocalUserPermissionScopeArgsDict']]]] permission_scopes: One or more `permission_scope` blocks as defined below.
        :param pulumi.Input[_builtins.str] sid: The unique Security Identifier of this Storage Account Local User.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LocalUserSshAuthorizedKeyArgs', 'LocalUserSshAuthorizedKeyArgsDict']]]] ssh_authorized_keys: One or more `ssh_authorized_key` blocks as defined below.
        :param pulumi.Input[_builtins.bool] ssh_key_enabled: Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] ssh_password_enabled: Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocalUserState.__new__(_LocalUserState)

        __props__.__dict__["home_directory"] = home_directory
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["permission_scopes"] = permission_scopes
        __props__.__dict__["sid"] = sid
        __props__.__dict__["ssh_authorized_keys"] = ssh_authorized_keys
        __props__.__dict__["ssh_key_enabled"] = ssh_key_enabled
        __props__.__dict__["ssh_password_enabled"] = ssh_password_enabled
        __props__.__dict__["storage_account_id"] = storage_account_id
        return LocalUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The home directory of the Storage Account Local User.
        """
        return pulumi.get(self, "home_directory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Storage Account Local User. Changing this forces a new Storage Account Local User to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the password, which is only available when `ssh_password_enabled` is set to `true`.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="permissionScopes")
    def permission_scopes(self) -> pulumi.Output[Optional[Sequence['outputs.LocalUserPermissionScope']]]:
        """
        One or more `permission_scope` blocks as defined below.
        """
        return pulumi.get(self, "permission_scopes")

    @_builtins.property
    @pulumi.getter
    def sid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique Security Identifier of this Storage Account Local User.
        """
        return pulumi.get(self, "sid")

    @_builtins.property
    @pulumi.getter(name="sshAuthorizedKeys")
    def ssh_authorized_keys(self) -> pulumi.Output[Optional[Sequence['outputs.LocalUserSshAuthorizedKey']]]:
        """
        One or more `ssh_authorized_key` blocks as defined below.
        """
        return pulumi.get(self, "ssh_authorized_keys")

    @_builtins.property
    @pulumi.getter(name="sshKeyEnabled")
    def ssh_key_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether SSH Key Authentication is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ssh_key_enabled")

    @_builtins.property
    @pulumi.getter(name="sshPasswordEnabled")
    def ssh_password_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether SSH Password Authentication is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "ssh_password_enabled")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Storage Account that this Storage Account Local User resides in. Changing this forces a new Storage Account Local User to be created.
        """
        return pulumi.get(self, "storage_account_id")

