# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MoverTargetEndpointArgs', 'MoverTargetEndpoint']

@pulumi.input_type
class MoverTargetEndpointArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[_builtins.str],
                 storage_container_name: pulumi.Input[_builtins.str],
                 storage_mover_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MoverTargetEndpoint resource.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_container_name: Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Target Endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        pulumi.set(__self__, "storage_container_name", storage_container_name)
        pulumi.set(__self__, "storage_mover_id", storage_mover_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_name")

    @storage_container_name.setter
    def storage_container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_name", value)

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_mover_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a description for the Storage Mover Target Endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MoverTargetEndpointState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MoverTargetEndpoint resources.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Target Endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_container_name: Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_container_name is not None:
            pulumi.set(__self__, "storage_container_name", storage_container_name)
        if storage_mover_id is not None:
            pulumi.set(__self__, "storage_mover_id", storage_mover_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a description for the Storage Mover Target Endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_name")

    @storage_container_name.setter
    def storage_container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_name", value)

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_mover_id", value)


@pulumi.type_token("azure:storage/moverTargetEndpoint:MoverTargetEndpoint")
class MoverTargetEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Storage Mover Target Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestr",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            allow_nested_items_to_be_public=True)
        example_container = azure.storage.Container("example",
            name="example-sc",
            storage_account_name=example_account.name,
            container_access_type="blob")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name,
            location="West Europe")
        example_mover_target_endpoint = azure.storage.MoverTargetEndpoint("example",
            name="example-se",
            storage_mover_id=example_mover.id,
            storage_account_id=example_account.id,
            storage_container_name=example_container.name,
            description="Example Storage Container Endpoint Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover`: 2023-03-01

        ## Import

        Storage Mover Target Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverTargetEndpoint:MoverTargetEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/endpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Target Endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_container_name: Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MoverTargetEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Mover Target Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestr",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            allow_nested_items_to_be_public=True)
        example_container = azure.storage.Container("example",
            name="example-sc",
            storage_account_name=example_account.name,
            container_access_type="blob")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name,
            location="West Europe")
        example_mover_target_endpoint = azure.storage.MoverTargetEndpoint("example",
            name="example-se",
            storage_mover_id=example_mover.id,
            storage_account_id=example_account.id,
            storage_container_name=example_container.name,
            description="Example Storage Container Endpoint Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover`: 2023-03-01

        ## Import

        Storage Mover Target Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverTargetEndpoint:MoverTargetEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/endpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param MoverTargetEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MoverTargetEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MoverTargetEndpointArgs.__new__(MoverTargetEndpointArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            if storage_container_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_name'")
            __props__.__dict__["storage_container_name"] = storage_container_name
            if storage_mover_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_mover_id'")
            __props__.__dict__["storage_mover_id"] = storage_mover_id
        super(MoverTargetEndpoint, __self__).__init__(
            'azure:storage/moverTargetEndpoint:MoverTargetEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MoverTargetEndpoint':
        """
        Get an existing MoverTargetEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Target Endpoint.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_container_name: Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MoverTargetEndpointState.__new__(_MoverTargetEndpointState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["storage_container_name"] = storage_container_name
        __props__.__dict__["storage_mover_id"] = storage_mover_id
        return MoverTargetEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a description for the Storage Mover Target Endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the storage account for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the storage blob container for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_container_name")

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the storage mover for this Storage Mover Target Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

