# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OutputTableArgs', 'OutputTable']

@pulumi.input_type
class OutputTableArgs:
    def __init__(__self__, *,
                 batch_size: pulumi.Input[_builtins.int],
                 partition_key: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 row_key: pulumi.Input[_builtins.str],
                 storage_account_key: pulumi.Input[_builtins.str],
                 storage_account_name: pulumi.Input[_builtins.str],
                 stream_analytics_job_name: pulumi.Input[_builtins.str],
                 table: pulumi.Input[_builtins.str],
                 columns_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OutputTable resource.
        :param pulumi.Input[_builtins.int] batch_size: The number of records for a batch operation. Must be between `1` and `100`.
        :param pulumi.Input[_builtins.str] partition_key: The name of the output column that contains the partition key.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The name of the output column that contains the row key.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table: The name of the table where the stream should be output to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns_to_removes: A list of the column names to be removed from output event entities.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "batch_size", batch_size)
        pulumi.set(__self__, "partition_key", partition_key)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "row_key", row_key)
        pulumi.set(__self__, "storage_account_key", storage_account_key)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        pulumi.set(__self__, "table", table)
        if columns_to_removes is not None:
            pulumi.set(__self__, "columns_to_removes", columns_to_removes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Input[_builtins.int]:
        """
        The number of records for a batch operation. Must be between `1` and `100`.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "batch_size", value)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the output column that contains the partition key.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "partition_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the output column that contains the row key.
        """
        return pulumi.get(self, "row_key")

    @row_key.setter
    def row_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "row_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> pulumi.Input[_builtins.str]:
        """
        The Access Key which should be used to connect to this Storage Account.
        """
        return pulumi.get(self, "storage_account_key")

    @storage_account_key.setter
    def storage_account_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Storage Account.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the table where the stream should be output to.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="columnsToRemoves")
    def columns_to_removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the column names to be removed from output event entities.
        """
        return pulumi.get(self, "columns_to_removes")

    @columns_to_removes.setter
    def columns_to_removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "columns_to_removes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Output. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OutputTableState:
    def __init__(__self__, *,
                 batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 columns_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OutputTable resources.
        :param pulumi.Input[_builtins.int] batch_size: The number of records for a batch operation. Must be between `1` and `100`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns_to_removes: A list of the column names to be removed from output event entities.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The name of the output column that contains the partition key.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The name of the output column that contains the row key.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table: The name of the table where the stream should be output to.
        """
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if columns_to_removes is not None:
            pulumi.set(__self__, "columns_to_removes", columns_to_removes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if row_key is not None:
            pulumi.set(__self__, "row_key", row_key)
        if storage_account_key is not None:
            pulumi.set(__self__, "storage_account_key", storage_account_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if stream_analytics_job_name is not None:
            pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of records for a batch operation. Must be between `1` and `100`.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_size", value)

    @_builtins.property
    @pulumi.getter(name="columnsToRemoves")
    def columns_to_removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the column names to be removed from output event entities.
        """
        return pulumi.get(self, "columns_to_removes")

    @columns_to_removes.setter
    def columns_to_removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "columns_to_removes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Output. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the output column that contains the partition key.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the output column that contains the row key.
        """
        return pulumi.get(self, "row_key")

    @row_key.setter
    def row_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "row_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access Key which should be used to connect to this Storage Account.
        """
        return pulumi.get(self, "storage_account_key")

    @storage_account_key.setter
    def storage_account_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Storage Account.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table where the stream should be output to.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)


@pulumi.type_token("azure:streamanalytics/outputTable:OutputTable")
class OutputTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 columns_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Output Table.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_table = azure.storage.Table("example",
            name="exampletable",
            storage_account_name=example_account.name)
        example_output_table = azure.streamanalytics.OutputTable("example",
            name="output-to-storage-table",
            stream_analytics_job_name=example.name,
            resource_group_name=example.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            table=example_table.name,
            partition_key="foo",
            row_key="bar",
            batch_size=100)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2021-10-01-preview

        ## Import

        Stream Analytics Output to Table can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/outputTable:OutputTable example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/outputs/output1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] batch_size: The number of records for a batch operation. Must be between `1` and `100`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns_to_removes: A list of the column names to be removed from output event entities.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The name of the output column that contains the partition key.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The name of the output column that contains the row key.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table: The name of the table where the stream should be output to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutputTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Output Table.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_table = azure.storage.Table("example",
            name="exampletable",
            storage_account_name=example_account.name)
        example_output_table = azure.streamanalytics.OutputTable("example",
            name="output-to-storage-table",
            stream_analytics_job_name=example.name,
            resource_group_name=example.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            table=example_table.name,
            partition_key="foo",
            row_key="bar",
            batch_size=100)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics`: 2021-10-01-preview

        ## Import

        Stream Analytics Output to Table can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/outputTable:OutputTable example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/outputs/output1
        ```

        :param str resource_name: The name of the resource.
        :param OutputTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutputTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_size: Optional[pulumi.Input[_builtins.int]] = None,
                 columns_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutputTableArgs.__new__(OutputTableArgs)

            if batch_size is None and not opts.urn:
                raise TypeError("Missing required property 'batch_size'")
            __props__.__dict__["batch_size"] = batch_size
            __props__.__dict__["columns_to_removes"] = columns_to_removes
            __props__.__dict__["name"] = name
            if partition_key is None and not opts.urn:
                raise TypeError("Missing required property 'partition_key'")
            __props__.__dict__["partition_key"] = partition_key
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if row_key is None and not opts.urn:
                raise TypeError("Missing required property 'row_key'")
            __props__.__dict__["row_key"] = row_key
            if storage_account_key is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_key'")
            __props__.__dict__["storage_account_key"] = None if storage_account_key is None else pulumi.Output.secret(storage_account_key)
            if storage_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_name'")
            __props__.__dict__["storage_account_name"] = storage_account_name
            if stream_analytics_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_name'")
            __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
            if table is None and not opts.urn:
                raise TypeError("Missing required property 'table'")
            __props__.__dict__["table"] = table
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OutputTable, __self__).__init__(
            'azure:streamanalytics/outputTable:OutputTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            batch_size: Optional[pulumi.Input[_builtins.int]] = None,
            columns_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition_key: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            row_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            table: Optional[pulumi.Input[_builtins.str]] = None) -> 'OutputTable':
        """
        Get an existing OutputTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] batch_size: The number of records for a batch operation. Must be between `1` and `100`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns_to_removes: A list of the column names to be removed from output event entities.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Output. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] partition_key: The name of the output column that contains the partition key.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The name of the output column that contains the row key.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] table: The name of the table where the stream should be output to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutputTableState.__new__(_OutputTableState)

        __props__.__dict__["batch_size"] = batch_size
        __props__.__dict__["columns_to_removes"] = columns_to_removes
        __props__.__dict__["name"] = name
        __props__.__dict__["partition_key"] = partition_key
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["row_key"] = row_key
        __props__.__dict__["storage_account_key"] = storage_account_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
        __props__.__dict__["table"] = table
        return OutputTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Output[_builtins.int]:
        """
        The number of records for a batch operation. Must be between `1` and `100`.
        """
        return pulumi.get(self, "batch_size")

    @_builtins.property
    @pulumi.getter(name="columnsToRemoves")
    def columns_to_removes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the column names to be removed from output event entities.
        """
        return pulumi.get(self, "columns_to_removes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Output. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the output column that contains the partition key.
        """
        return pulumi.get(self, "partition_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the output column that contains the row key.
        """
        return pulumi.get(self, "row_key")

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Access Key which should be used to connect to this Storage Account.
        """
        return pulumi.get(self, "storage_account_key")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Storage Account.
        """
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the table where the stream should be output to.
        """
        return pulumi.get(self, "table")

