import { Component } from "../component";
import { JsonFile } from "../json";
import { Project } from "../project";
/**
 * CDK V1 feature flags configuration.
 * @deprecated CDK V1 is EOS. Upgrade to CDK V2.
 */
export declare class CdkFeatureFlagsV1 implements ICdkFeatureFlags {
    /**
     * Disable all feature flags.
     */
    static readonly NONE: CdkFeatureFlagsV1;
    /**
     * Enable all CDK V1 feature flags.
     */
    static readonly ALL: CdkFeatureFlagsV1;
    readonly flags: Record<string, unknown>;
    private constructor();
}
/**
 * CDK V2 feature flags configuration.
 */
export declare class CdkFeatureFlagsV2 implements ICdkFeatureFlags {
    /**
     * Disable all feature flags.
     */
    static readonly NONE: CdkFeatureFlagsV2;
    /**
     * Enable all CDK V2 feature flags known to projen.
     * These might not include feature flags, if your version of projen isn't up-to-date.
     *
     * Make sure to double-check any changes to feature flags in `cdk.json` before deploying.
     * Unexpected changes may cause breaking changes in your CDK app.
     * You can overwrite any feature flag by passing it into the context field.
     */
    static readonly ALL: CdkFeatureFlagsV2;
    /**
     * Attempt to load the feature flags from the `aws-cdk-lib/recommended-feature-flags.json` in a locally available npm package.
     * This file is typically only present in AWS CDK TypeScript projects, but can yield more accurate results.
     *
     * Falls back to all known feature flags if not found.
     */
    static fromLocalAwsCdkLib(): CdkFeatureFlagsV2;
    readonly flags: Record<string, unknown>;
    private constructor();
}
/**
 *
 * @subclassable
 */
export interface ICdkFeatureFlags {
    readonly flags: Record<string, unknown>;
}
/**
 * CDK feature flags configuration.
 */
export declare class CdkFeatureFlags implements ICdkFeatureFlags {
    /**
     * CDK V1 feature flags configuration.
     * @deprecated CDK V1 is EOS. Upgrade to CDK V2.
     */
    static readonly V1: typeof CdkFeatureFlagsV1;
    /**
     * CDK V2 feature flags configuration.
     */
    static readonly V2: typeof CdkFeatureFlagsV2;
    readonly flags: Record<string, unknown>;
    private constructor();
}
/**
 * Common options for `cdk.json`.
 */
export interface CdkConfigCommonOptions {
    /**
     * Additional context to include in `cdk.json`.
     *
     * @default - no additional context
     */
    readonly context?: {
        [key: string]: any;
    };
    /**
     * Feature flags that should be enabled in `cdk.json`.
     *
     * Make sure to double-check any changes to feature flags in `cdk.json` before deploying.
     * Unexpected changes may cause breaking changes in your CDK app.
     * You can overwrite any feature flag by passing it into the context field.
     *
     * @default - no feature flags are enabled by default
     */
    readonly featureFlags?: ICdkFeatureFlags;
    /**
     * To protect you against unintended changes that affect your security posture,
     * the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.
     *
     * @default ApprovalLevel.BROADENING
     */
    readonly requireApproval?: ApprovalLevel;
    /**
     * cdk.out directory.
     *
     * @default "cdk.out"
     */
    readonly cdkout?: string;
    /**
     * A command to execute before synthesis. This command will be called when
     * running `cdk synth` or when `cdk watch` identifies a change in your source
     * code before redeployment.
     *
     * @default - no build command
     */
    readonly buildCommand?: string;
    /**
     * Glob patterns to include in `cdk watch`.
     *
     * @default []
     */
    readonly watchIncludes?: string[];
    /**
     * Glob patterns to exclude from `cdk watch`.
     *
     * @default []
     */
    readonly watchExcludes?: string[];
}
/**
 * Options for `CdkJson`.
 */
export interface CdkConfigOptions extends CdkConfigCommonOptions {
    /**
     * The command line to execute in order to synthesize the CDK application
     * (language specific).
     */
    readonly app: string;
}
/**
 * Represents cdk.json file.
 */
export declare class CdkConfig extends Component {
    /**
     * Represents the JSON file.
     */
    readonly json: JsonFile;
    /**
     * Name of the cdk.out directory.
     */
    readonly cdkout: string;
    /**
     * List of glob patterns to be included by CDK.
     */
    private readonly _include;
    /**
     * List of glob patterns to be excluded by CDK.
     */
    private readonly _exclude;
    /**
     * The context to write to cdk.json.
     */
    private readonly _context;
    constructor(project: Project, options: CdkConfigOptions);
    /**
     * Add includes to `cdk.json`.
     * @param patterns The includes to add.
     */
    addIncludes(...patterns: string[]): void;
    /**
     * Add excludes to `cdk.json`.
     * @param patterns The excludes to add.
     */
    addExcludes(...patterns: string[]): void;
    /**
     * List of glob patterns to be included by CDK.
     */
    get include(): string[];
    /**
     * List of glob patterns to be excluded by CDK.
     */
    get exclude(): string[];
    /**
     * The context to write to cdk.json.
     */
    get context(): Record<string, unknown>;
}
/**
 * Which approval is required when deploying CDK apps.
 */
export declare enum ApprovalLevel {
    /**
     * Approval is never required
     */
    NEVER = "never",
    /**
     * Requires approval on any IAM or security-group-related change
     */
    ANY_CHANGE = "any-change",
    /**
     * Requires approval when IAM statements or traffic rules are added; removals don't require approval
     */
    BROADENING = "broadening"
}
