"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkTasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Adds standard AWS CDK tasks to your project.
 */
class CdkTasks extends component_1.Component {
    constructor(project) {
        super(project);
        this.synth = project.addTask("synth", {
            description: "Synthesizes your cdk app into cdk.out",
            exec: "cdk synth",
        });
        this.synthSilent = project.addTask("synth:silent", {
            description: 'Synthesizes your cdk app into cdk.out and suppresses the template in stdout (part of "yarn build")',
            exec: "cdk synth -q",
        });
        this.deploy = project.addTask("deploy", {
            description: "Deploys your CDK app to the AWS cloud",
            exec: "cdk deploy",
            receiveArgs: true,
        });
        this.destroy = project.addTask("destroy", {
            description: "Destroys your cdk app in the AWS cloud",
            exec: "cdk destroy",
            receiveArgs: true,
        });
        this.diff = project.addTask("diff", {
            description: "Diffs the currently deployed app against your code",
            exec: "cdk diff",
        });
        // typescript projects already have a "watch" task, we will repurpose it
        const watch = project.tasks.tryFind("watch") ?? project.addTask("watch");
        watch.reset();
        watch.description =
            "Watches changes in your source code and rebuilds and deploys to the current account";
        // deploy first because surprisingly watch is not deploying first
        // see https://github.com/aws/aws-cdk/issues/17776
        watch.exec("cdk deploy --hotswap");
        // now we are ready to watch
        watch.exec("cdk watch");
        this.watch = watch;
    }
}
exports.CdkTasks = CdkTasks;
_a = JSII_RTTI_SYMBOL_1;
CdkTasks[_a] = { fqn: "projen.awscdk.CdkTasks", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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