"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiDocgen = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
/**
 * Creates a markdown file based on the jsii manifest:
 * - Adds a `docgen` script to package.json
 * - Runs `jsii-docgen` after compilation
 * - Enforces that markdown file is checked in
 */
class JsiiDocgen extends component_1.Component {
    constructor(scope, options = {}) {
        super(scope);
        const version = options.version ?? "*";
        if (!this.project.deps.isDependencySatisfied("jsii-docgen", dependencies_1.DependencyType.BUILD, version)) {
            this.project.deps.addDependency(`jsii-docgen@${version}`, dependencies_1.DependencyType.BUILD);
        }
        const filePath = options.filePath ?? "API.md";
        const docgen = this.project.addTask("docgen", {
            description: "Generate API.md from .jsii manifest",
            exec: `jsii-docgen -o ${filePath}`,
        });
        // spawn docgen after compilation (requires the .jsii manifest).
        this.project.postCompileTask.spawn(docgen);
        this.project.gitignore.include(`/${filePath}`);
        this.project.annotateGenerated(`/${filePath}`);
    }
}
exports.JsiiDocgen = JsiiDocgen;
_a = JSII_RTTI_SYMBOL_1;
JsiiDocgen[_a] = { fqn: "projen.cdk.JsiiDocgen", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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