import { GoPublishOptions, MavenPublishOptions, NugetPublishOptions, PyPiPublishOptions } from "../release";
import { TypeScriptProject, TypeScriptProjectOptions } from "../typescript";
export interface JsiiProjectOptions extends TypeScriptProjectOptions {
    /**
     * @default "."
     */
    readonly rootdir?: string;
    /**
     * Git repository URL.
     * @default $GIT_REMOTE
     */
    readonly repositoryUrl: string;
    /**
     * The name of the library author.
     * @default $GIT_USER_NAME
     */
    readonly author: string;
    /**
     * Email or URL of the library author.
     * @default $GIT_USER_EMAIL
     */
    readonly authorAddress: string;
    /**
     * Publish to maven
     * @default - no publishing
     */
    readonly publishToMaven?: JsiiJavaTarget;
    /**
     * Publish to pypi
     * @default - no publishing
     */
    readonly publishToPypi?: JsiiPythonTarget;
    /**
     * Publish Go bindings to a git repository.
     * @default - no publishing
     */
    readonly publishToGo?: JsiiGoTarget;
    /**
     * @deprecated use `publishToPyPi`
     */
    readonly python?: JsiiPythonTarget;
    /**
     * Publish to NuGet
     * @default - no publishing
     */
    readonly publishToNuget?: JsiiDotNetTarget;
    /**
     * @deprecated use `publishToNuget`
     */
    readonly dotnet?: JsiiDotNetTarget;
    /**
     * Automatically run API compatibility test against the latest version published to npm after compilation.
     *
     * - You can manually run compatibility tests using `yarn compat` if this feature is disabled.
     * - You can ignore compatibility failures by adding lines to a ".compatignore" file.
     *
     * @default false
     */
    readonly compat?: boolean;
    /**
     * Name of the ignore file for API compatibility tests.
     *
     * @default ".compatignore"
     */
    readonly compatIgnore?: string;
    /**
     * Accepts a list of glob patterns. Files matching any of those patterns will be excluded from the TypeScript compiler input.
     *
     * By default, jsii will include all *.ts files (except .d.ts files) in the TypeScript compiler input.
     * This can be problematic for example when the package's build or test procedure generates .ts files
     * that cannot be compiled with jsii's compiler settings.
     */
    readonly excludeTypescript?: string[];
    /**
     * File path for generated docs.
     * @default "API.md"
     */
    readonly docgenFilePath?: string;
    /**
     * Emit a compressed version of the assembly
     * @default false
     */
    readonly compressAssembly?: boolean;
    /**
     * Version of the jsii compiler to use.
     *
     * Set to "*" if you want to manually manage the version of jsii in your
     * project by managing updates to `package.json` on your own.
     *
     * NOTE: The jsii compiler releases since 5.0.0 are not semantically versioned
     * and should remain on the same minor, so we recommend using a `~` dependency
     * (e.g. `~5.0.0`).
     *
     * @default "~5.8.0"
     * @pjnew "~5.9.0"
     */
    readonly jsiiVersion?: string;
}
export declare enum Stability {
    EXPERIMENTAL = "experimental",
    STABLE = "stable",
    DEPRECATED = "deprecated"
}
export interface JsiiJavaTarget extends MavenPublishOptions {
    readonly javaPackage: string;
    readonly mavenGroupId: string;
    readonly mavenArtifactId: string;
}
export interface JsiiPythonTarget extends PyPiPublishOptions {
    readonly distName: string;
    readonly module: string;
}
export interface JsiiDotNetTarget extends NugetPublishOptions {
    readonly dotNetNamespace: string;
    readonly packageId: string;
    readonly iconUrl?: string;
}
/**
 * Go target configuration
 */
export interface JsiiGoTarget extends GoPublishOptions {
    /**
     * The name of the target repository in which this module will be published (e.g. github.com/owner/repo).
     *
     * The module itself will always be published under a subdirectory named according
     * to the `packageName` of the module (e.g. github.com/foo/bar/pkg).
     *
     * @example github.com/owner/repo
     */
    readonly moduleName: string;
    /**
     * The name of the Go package name.
     *
     * If not specified, package name will be derived from the JavaScript module name
     * by removing non-alphanumeric characters (e.g. @projen/foo-bar will be projenfoobar).
     *
     * @default - derived from the JavaScript module name
     */
    readonly packageName?: string;
    /**
     * A suffix appended at the end of the module version (e.g `"-devprefix"`).
     *
     * @default - none
     */
    readonly versionSuffix?: string;
}
/**
 * Multi-language jsii library project
 *
 * @pjid jsii
 */
export declare class JsiiProject extends TypeScriptProject {
    private readonly packageAllTask;
    private readonly packageJsTask;
    constructor(options: JsiiProjectOptions);
    /**
     * Adds a target language to the release workflow.
     * @param language
     * @returns
     */
    private addTargetToRelease;
    /**
     * Adds a target language to the build workflow
     * @param language
     * @returns
     */
    private addTargetToBuild;
    private addPackagingTask;
    private pacmakForLanguage;
    /**
     * Generates the runs-on config for Jobs.
     * Throws error if 'runsOn' and 'runsOnGroup' are both set.
     *
     * @param options - 'runsOn' or 'runsOnGroup'.
     */
    private getJobRunsOnConfig;
}
