"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Component = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const constructs_2 = require("./util/constructs");
const autoIds = new WeakMap();
const componentId = (scope) => {
    const nextId = (autoIds.get(scope) ?? 0) + 1;
    autoIds.set(scope, nextId);
    return `AutoId${nextId}`;
};
/**
 * Represents a project component.
 * @param project
 * @param id Unique id of the component. If not provided, an unstable AutoId is generated.
 */
class Component extends constructs_1.Construct {
    /**
     * Test whether the given construct is a component.
     */
    static isComponent(x) {
        return (0, constructs_2.isComponent)(x);
    }
    constructor(scope, id) {
        super(scope, id || `${new.target.name}#${componentId(scope)}`);
        (0, constructs_2.tagAsComponent)(this);
        this.node.addMetadata("type", "component");
        this.node.addMetadata("construct", new.target.name);
        this.project = (0, constructs_2.findClosestProject)(scope, new.target.name);
    }
    /**
     * Called before synthesis.
     */
    preSynthesize() { }
    /**
     * Synthesizes files to the project output directory.
     */
    synthesize() { }
    /**
     * Called after synthesis. Order is *not* guaranteed.
     */
    postSynthesize() { }
}
exports.Component = Component;
_a = JSII_RTTI_SYMBOL_1;
Component[_a] = { fqn: "projen.Component", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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