"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubActionsProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Manage the versions used for GitHub Actions used in steps
 */
class GitHubActionsProvider {
    constructor() {
        this.actions = new Map();
    }
    /**
     * Define an override for a given action.
     *
     * Specify the action name without a version to override all usages of the action.
     * You can also override a specific action version, by providing the version string.
     * Specific overrides take precedence over overrides without a version.
     *
     * If an override for the same action name is set multiple times, the last override is used.
     *
     * @example
     * // Force any use of `actions/checkout` to use a pin a specific commit
     * project.github.actions.set("actions/checkout", "actions/checkout@aaaaaa");
     *
     * // But pin usage of `v4` to a different commit
     * project.github.actions.set("actions/checkout@v4", "actions/checkout@ffffff");
     */
    set(action, override) {
        this.actions.set(action, override);
    }
    /**
     * Resolve an action name to the version that should be used,
     * taking into account any overrides.
     */
    get(action) {
        const parts = action.split("@", 1);
        return this.actions.get(action) ?? this.actions.get(parts[0]) ?? action;
    }
}
exports.GitHubActionsProvider = GitHubActionsProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubActionsProvider[_a] = { fqn: "projen.github.GitHubActionsProvider", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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