"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PERMISSION_BACKUP_FILE = exports.DEFAULT_GITHUB_ACTIONS_USER = exports.BUILD_ARTIFACT_NAME = void 0;
/**
 * Name of the artifact produced by the build job. Its contains the entire
 * working directory.
 */
exports.BUILD_ARTIFACT_NAME = "build-artifact";
/**
 * Represents the `github-actions[bot]` user.
 *
 * Use this when you need to perform a commit as part of your workflow.
 */
exports.DEFAULT_GITHUB_ACTIONS_USER = {
    // https://github.com/actions/checkout/blob/08c6903cd8c0fde910a37f88322edcfb5dd907a8/README.md#push-a-commit-using-the-built-in-token
    name: "github-actions[bot]",
    email: "41898282+github-actions[bot]@users.noreply.github.com",
};
/**
 * Name of the permission back up file to include in the build artifact
 * to work around a GitHub Action bug that does not preserve file mode
 * permissions across upload and download actions.
 *
 * See {@link https://github.com/actions/upload-artifact/issues/38}
 */
exports.PERMISSION_BACKUP_FILE = "permissions-backup.acl";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dpdGh1Yi9jb25zdGFudHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7OztHQUdHO0FBQ1UsUUFBQSxtQkFBbUIsR0FBRyxnQkFBZ0IsQ0FBQztBQUVwRDs7OztHQUlHO0FBQ1UsUUFBQSwyQkFBMkIsR0FBZ0I7SUFDdEQscUlBQXFJO0lBQ3JJLElBQUksRUFBRSxxQkFBcUI7SUFDM0IsS0FBSyxFQUFFLHVEQUF1RDtDQUMvRCxDQUFDO0FBRUY7Ozs7OztHQU1HO0FBQ1UsUUFBQSxzQkFBc0IsR0FBRyx3QkFBd0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdpdElkZW50aXR5IH0gZnJvbSBcIi5cIjtcblxuLyoqXG4gKiBOYW1lIG9mIHRoZSBhcnRpZmFjdCBwcm9kdWNlZCBieSB0aGUgYnVpbGQgam9iLiBJdHMgY29udGFpbnMgdGhlIGVudGlyZVxuICogd29ya2luZyBkaXJlY3RvcnkuXG4gKi9cbmV4cG9ydCBjb25zdCBCVUlMRF9BUlRJRkFDVF9OQU1FID0gXCJidWlsZC1hcnRpZmFjdFwiO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIGBnaXRodWItYWN0aW9uc1tib3RdYCB1c2VyLlxuICpcbiAqIFVzZSB0aGlzIHdoZW4geW91IG5lZWQgdG8gcGVyZm9ybSBhIGNvbW1pdCBhcyBwYXJ0IG9mIHlvdXIgd29ya2Zsb3cuXG4gKi9cbmV4cG9ydCBjb25zdCBERUZBVUxUX0dJVEhVQl9BQ1RJT05TX1VTRVI6IEdpdElkZW50aXR5ID0ge1xuICAvLyBodHRwczovL2dpdGh1Yi5jb20vYWN0aW9ucy9jaGVja291dC9ibG9iLzA4YzY5MDNjZDhjMGZkZTkxMGEzN2Y4ODMyMmVkY2ZiNWRkOTA3YTgvUkVBRE1FLm1kI3B1c2gtYS1jb21taXQtdXNpbmctdGhlLWJ1aWx0LWluLXRva2VuXG4gIG5hbWU6IFwiZ2l0aHViLWFjdGlvbnNbYm90XVwiLFxuICBlbWFpbDogXCI0MTg5ODI4MitnaXRodWItYWN0aW9uc1tib3RdQHVzZXJzLm5vcmVwbHkuZ2l0aHViLmNvbVwiLFxufTtcblxuLyoqXG4gKiBOYW1lIG9mIHRoZSBwZXJtaXNzaW9uIGJhY2sgdXAgZmlsZSB0byBpbmNsdWRlIGluIHRoZSBidWlsZCBhcnRpZmFjdFxuICogdG8gd29yayBhcm91bmQgYSBHaXRIdWIgQWN0aW9uIGJ1ZyB0aGF0IGRvZXMgbm90IHByZXNlcnZlIGZpbGUgbW9kZVxuICogcGVybWlzc2lvbnMgYWNyb3NzIHVwbG9hZCBhbmQgZG93bmxvYWQgYWN0aW9ucy5cbiAqXG4gKiBTZWUge0BsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hY3Rpb25zL3VwbG9hZC1hcnRpZmFjdC9pc3N1ZXMvMzh9XG4gKi9cbmV4cG9ydCBjb25zdCBQRVJNSVNTSU9OX0JBQ0tVUF9GSUxFID0gXCJwZXJtaXNzaW9ucy1iYWNrdXAuYWNsXCI7XG4iXX0=