import { IConstruct } from "constructs";
import { GitIdentity } from "./task-workflow";
import { CheckoutWith } from "./workflow-steps";
import { ContainerOptions, Job, JobDefaults, JobPermissions, JobStep, JobStepOutput, JobStrategy, Tools } from "./workflows-model";
import { Component } from "../component";
import { GroupRunnerOptions } from "../runner-options";
import { Task } from "../task";
/**
 * Options to create the Job associated with a TaskWorkflow.
 */
export interface TaskWorkflowJobOptions {
    /**
     * @default - default image
     */
    readonly container?: ContainerOptions;
    /**
     * Adds an 'if' condition to the workflow.
     */
    readonly condition?: string;
    /**
     * A directory name which contains artifacts to be uploaded (e.g. `dist`).
     * If this is set, the contents of this directory will be uploaded as an
     * artifact at the end of the workflow run, even if other steps fail.
     *
     * @default - not set
     */
    readonly artifactsDirectory?: string;
    /**
     * Initial steps to run before the source code checkout.
     *
     * @default - not set
     */
    readonly preCheckoutSteps?: JobStep[];
    /**
     * Override for the `with` property of the source code checkout step.
     *
     * @default - not set
     */
    readonly checkoutWith?: CheckoutWith;
    /**
     * Steps to run before the main build step.
     *
     * @default - not set
     */
    readonly preBuildSteps?: JobStep[];
    /**
     * Actions to run after the main build step.
     *
     * @default - not set
     */
    readonly postBuildSteps?: JobStep[];
    /**
     * Workflow environment variables.
     * @default {}
     */
    readonly env?: Record<string, string>;
    /**
     * Permissions for the build job.
     */
    readonly permissions: JobPermissions;
    /**
     * Mapping of job output names to values/expressions.
     *
     * @default {}
     */
    readonly outputs?: {
        [name: string]: JobStepOutput;
    };
    /**
     * The git identity to use in this workflow.
     * @default - default GitHub Actions user
     */
    readonly gitIdentity?: GitIdentity;
    /**
     * Github Runner selection labels
     * @default ["ubuntu-latest"]
     * @description Defines a target Runner by labels
     * @throws {Error} if both `runsOn` and `runsOnGroup` are specified
     */
    readonly runsOn?: string[];
    /**
     * Github Runner Group selection options
     * @description Defines a target Runner Group by name and/or labels
     * @throws {Error} if both `runsOn` and `runsOnGroup` are specified
     */
    readonly runsOnGroup?: GroupRunnerOptions;
    /**
     * Whether to download files from Git LFS for this workflow
     *
     * @default - Use the setting on the corresponding GitHub project
     */
    readonly downloadLfs?: boolean;
    /**
     * Default settings for all steps in the TaskWorkflow Job.
     */
    readonly jobDefaults?: JobDefaults;
    /**
     * The GitHub Actions environment used for the job.
     *
     * @default - no environment used
     */
    readonly environment?: string;
}
/**
 * The primary or initial job of a TaskWorkflow.
 *
 * @implements {Job}
 */
export declare class TaskWorkflowJob extends Component {
    readonly runsOn?: string[] | undefined;
    readonly runsOnGroup?: GroupRunnerOptions | undefined;
    readonly steps: JobStep[];
    readonly environment?: string;
    readonly outputs?: Record<string, JobStepOutput> | undefined;
    readonly env?: Record<string, string> | undefined;
    readonly defaults?: JobDefaults | undefined;
    readonly timeoutMinutes?: number | undefined;
    readonly continueOnError?: boolean | undefined;
    readonly container?: ContainerOptions | undefined;
    readonly services?: Record<string, ContainerOptions> | undefined;
    readonly tools?: Tools | undefined;
    readonly name?: string | undefined;
    readonly needs?: string[] | undefined;
    readonly permissions: JobPermissions;
    readonly concurrency?: unknown;
    readonly if?: string | undefined;
    readonly strategy?: JobStrategy | undefined;
    /**
     * @param scope should be part of the project the Task belongs to.
     * @param task the main task that is run as part of this job.
     * @param options options to configure the TaskWorkflowJob.
     */
    constructor(scope: IConstruct, task: Task, options: TaskWorkflowJobOptions);
    /**
     * @jsii ignore
     * @internal
     */
    toJSON(): Job;
}
