"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrailingCommas2 = exports.TrailingCommas = exports.Semicolons = exports.QuoteProperties = exports.OperatorLinebreak = exports.ArrowParentheses = exports.WhitespaceSensitivity = exports.SelfCloseVoidElements = exports.QuoteStyle = exports.VcsClientKind = exports.RuleDomainValue = exports.JsxRuntime = exports.LineEnding = exports.IndentStyle = exports.Expand = exports.AttributePosition = void 0;
exports.toJson_BiomeConfiguration = toJson_BiomeConfiguration;
exports.toJson_AssistConfiguration = toJson_AssistConfiguration;
exports.toJson_CssConfiguration = toJson_CssConfiguration;
exports.toJson_FilesConfiguration = toJson_FilesConfiguration;
exports.toJson_FormatterConfiguration = toJson_FormatterConfiguration;
exports.toJson_GraphqlConfiguration = toJson_GraphqlConfiguration;
exports.toJson_GritConfiguration = toJson_GritConfiguration;
exports.toJson_HtmlConfiguration = toJson_HtmlConfiguration;
exports.toJson_JsConfiguration = toJson_JsConfiguration;
exports.toJson_JsonConfiguration = toJson_JsonConfiguration;
exports.toJson_LinterConfiguration = toJson_LinterConfiguration;
exports.toJson_OverridePattern = toJson_OverridePattern;
exports.toJson_VcsConfiguration = toJson_VcsConfiguration;
exports.toJson_Actions = toJson_Actions;
exports.toJson_CssAssistConfiguration = toJson_CssAssistConfiguration;
exports.toJson_CssFormatterConfiguration = toJson_CssFormatterConfiguration;
exports.toJson_CssLinterConfiguration = toJson_CssLinterConfiguration;
exports.toJson_CssParserConfiguration = toJson_CssParserConfiguration;
exports.toJson_GraphqlAssistConfiguration = toJson_GraphqlAssistConfiguration;
exports.toJson_GraphqlFormatterConfiguration = toJson_GraphqlFormatterConfiguration;
exports.toJson_GraphqlLinterConfiguration = toJson_GraphqlLinterConfiguration;
exports.toJson_GritAssistConfiguration = toJson_GritAssistConfiguration;
exports.toJson_GritFormatterConfiguration = toJson_GritFormatterConfiguration;
exports.toJson_GritLinterConfiguration = toJson_GritLinterConfiguration;
exports.toJson_HtmlAssistConfiguration = toJson_HtmlAssistConfiguration;
exports.toJson_HtmlFormatterConfiguration = toJson_HtmlFormatterConfiguration;
exports.toJson_HtmlLinterConfiguration = toJson_HtmlLinterConfiguration;
exports.toJson_HtmlParserConfiguration = toJson_HtmlParserConfiguration;
exports.toJson_JsAssistConfiguration = toJson_JsAssistConfiguration;
exports.toJson_JsFormatterConfiguration = toJson_JsFormatterConfiguration;
exports.toJson_JsLinterConfiguration = toJson_JsLinterConfiguration;
exports.toJson_JsParserConfiguration = toJson_JsParserConfiguration;
exports.toJson_JsonAssistConfiguration = toJson_JsonAssistConfiguration;
exports.toJson_JsonFormatterConfiguration = toJson_JsonFormatterConfiguration;
exports.toJson_JsonLinterConfiguration = toJson_JsonLinterConfiguration;
exports.toJson_JsonParserConfiguration = toJson_JsonParserConfiguration;
exports.toJson_Rules = toJson_Rules;
exports.toJson_OverrideAssistConfiguration = toJson_OverrideAssistConfiguration;
exports.toJson_OverrideFilesConfiguration = toJson_OverrideFilesConfiguration;
exports.toJson_OverrideFormatterConfiguration = toJson_OverrideFormatterConfiguration;
exports.toJson_OverrideLinterConfiguration = toJson_OverrideLinterConfiguration;
exports.toJson_Source = toJson_Source;
/**
 * Converts an object of type 'BiomeConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_BiomeConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        '$schema': obj.schema,
        'assist': toJson_AssistConfiguration(obj.assist),
        'css': toJson_CssConfiguration(obj.css),
        'extends': obj.extends?.map(y => y),
        'files': toJson_FilesConfiguration(obj.files),
        'formatter': toJson_FormatterConfiguration(obj.formatter),
        'graphql': toJson_GraphqlConfiguration(obj.graphql),
        'grit': toJson_GritConfiguration(obj.grit),
        'html': toJson_HtmlConfiguration(obj.html),
        'javascript': toJson_JsConfiguration(obj.javascript),
        'json': toJson_JsonConfiguration(obj.json),
        'linter': toJson_LinterConfiguration(obj.linter),
        'overrides': obj.overrides?.map(y => toJson_OverridePattern(y)),
        'plugins': obj.plugins?.map(y => y),
        'root': obj.root,
        'vcs': toJson_VcsConfiguration(obj.vcs),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'AssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_AssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'actions': toJson_Actions(obj.actions),
        'enabled': obj.enabled,
        'includes': obj.includes?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_CssAssistConfiguration(obj.assist),
        'formatter': toJson_CssFormatterConfiguration(obj.formatter),
        'globals': obj.globals?.map(y => y),
        'linter': toJson_CssLinterConfiguration(obj.linter),
        'parser': toJson_CssParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'FilesConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_FilesConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'experimentalScannerIgnores': obj.experimentalScannerIgnores?.map(y => y),
        'ignoreUnknown': obj.ignoreUnknown,
        'includes': obj.includes?.map(y => y),
        'maxSize': obj.maxSize,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'FormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_FormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'formatWithErrors': obj.formatWithErrors,
        'includes': obj.includes?.map(y => y),
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'useEditorconfig': obj.useEditorconfig,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GraphqlConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_GraphqlAssistConfiguration(obj.assist),
        'formatter': toJson_GraphqlFormatterConfiguration(obj.formatter),
        'linter': toJson_GraphqlLinterConfiguration(obj.linter),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_GritAssistConfiguration(obj.assist),
        'formatter': toJson_GritFormatterConfiguration(obj.formatter),
        'linter': toJson_GritLinterConfiguration(obj.linter),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_HtmlAssistConfiguration(obj.assist),
        'experimentalFullSupportEnabled': obj.experimentalFullSupportEnabled,
        'formatter': toJson_HtmlFormatterConfiguration(obj.formatter),
        'linter': toJson_HtmlLinterConfiguration(obj.linter),
        'parser': toJson_HtmlParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_JsAssistConfiguration(obj.assist),
        'formatter': toJson_JsFormatterConfiguration(obj.formatter),
        'globals': obj.globals?.map(y => y),
        'jsxRuntime': obj.jsxRuntime,
        'linter': toJson_JsLinterConfiguration(obj.linter),
        'parser': toJson_JsParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_JsonAssistConfiguration(obj.assist),
        'formatter': toJson_JsonFormatterConfiguration(obj.formatter),
        'linter': toJson_JsonLinterConfiguration(obj.linter),
        'parser': toJson_JsonParserConfiguration(obj.parser),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'LinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_LinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'domains': ((obj.domains) === undefined) ? undefined : (Object.entries(obj.domains).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {})),
        'enabled': obj.enabled,
        'includes': obj.includes?.map(y => y),
        'rules': toJson_Rules(obj.rules),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverridePattern' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverridePattern(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'assist': toJson_OverrideAssistConfiguration(obj.assist),
        'css': toJson_CssConfiguration(obj.css),
        'files': toJson_OverrideFilesConfiguration(obj.files),
        'formatter': toJson_OverrideFormatterConfiguration(obj.formatter),
        'graphql': toJson_GraphqlConfiguration(obj.graphql),
        'grit': toJson_GritConfiguration(obj.grit),
        'html': toJson_HtmlConfiguration(obj.html),
        'includes': obj.includes?.map(y => y),
        'javascript': toJson_JsConfiguration(obj.javascript),
        'json': toJson_JsonConfiguration(obj.json),
        'linter': toJson_OverrideLinterConfiguration(obj.linter),
        'plugins': obj.plugins?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'VcsConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_VcsConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'clientKind': obj.clientKind,
        'defaultBranch': obj.defaultBranch,
        'enabled': obj.enabled,
        'root': obj.root,
        'useIgnoreFile': obj.useIgnoreFile,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'Actions' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Actions(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'recommended': obj.recommended,
        'source': toJson_Source(obj.source),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'quoteStyle': obj.quoteStyle,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'CssParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_CssParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'allowWrongLineComments': obj.allowWrongLineComments,
        'cssModules': obj.cssModules,
        'tailwindDirectives': obj.tailwindDirectives,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * @schema AttributePosition
 */
var AttributePosition;
(function (AttributePosition) {
    /** auto */
    AttributePosition["AUTO"] = "auto";
    /** multiline */
    AttributePosition["MULTILINE"] = "multiline";
})(AttributePosition || (exports.AttributePosition = AttributePosition = {}));
/**
 * @schema Expand
 */
var Expand;
(function (Expand) {
    /** auto */
    Expand["AUTO"] = "auto";
    /** always */
    Expand["ALWAYS"] = "always";
    /** never */
    Expand["NEVER"] = "never";
})(Expand || (exports.Expand = Expand = {}));
/**
 * @schema IndentStyle
 */
var IndentStyle;
(function (IndentStyle) {
    /** tab */
    IndentStyle["TAB"] = "tab";
    /** space */
    IndentStyle["SPACE"] = "space";
})(IndentStyle || (exports.IndentStyle = IndentStyle = {}));
/**
 * @schema LineEnding
 */
var LineEnding;
(function (LineEnding) {
    /** lf */
    LineEnding["LF"] = "lf";
    /** crlf */
    LineEnding["CRLF"] = "crlf";
    /** cr */
    LineEnding["CR"] = "cr";
    /** auto */
    LineEnding["AUTO"] = "auto";
})(LineEnding || (exports.LineEnding = LineEnding = {}));
/**
 * Converts an object of type 'GraphqlAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GraphqlFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'quoteStyle': obj.quoteStyle,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GraphqlLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GraphqlLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'GritLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_GritLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'enabled': obj.enabled,
        'indentScriptAndStyle': obj.indentScriptAndStyle,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'selfCloseVoidElements': obj.selfCloseVoidElements,
        'whitespaceSensitivity': obj.whitespaceSensitivity,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'HtmlParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_HtmlParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'interpolation': obj.interpolation,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'arrowParentheses': obj.arrowParentheses,
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'jsxQuoteStyle': obj.jsxQuoteStyle,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'operatorLinebreak': obj.operatorLinebreak,
        'quoteProperties': obj.quoteProperties,
        'quoteStyle': obj.quoteStyle,
        'semicolons': obj.semicolons,
        'trailingCommas': obj.trailingCommas,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * Indicates the type of runtime or transformation used for interpreting JSX.
 *
 * @schema JsxRuntime
 */
var JsxRuntime;
(function (JsxRuntime) {
    /** transparent */
    JsxRuntime["TRANSPARENT"] = "transparent";
    /** reactClassic */
    JsxRuntime["REACT_CLASSIC"] = "reactClassic";
})(JsxRuntime || (exports.JsxRuntime = JsxRuntime = {}));
/**
 * Converts an object of type 'JsLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'gritMetavariables': obj.gritMetavariables,
        'jsxEverywhere': obj.jsxEverywhere,
        'unsafeParameterDecoratorsEnabled': obj.unsafeParameterDecoratorsEnabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
        'trailingCommas': obj.trailingCommas,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'JsonParserConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_JsonParserConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'allowComments': obj.allowComments,
        'allowTrailingCommas': obj.allowTrailingCommas,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * @schema RuleDomainValue
 */
var RuleDomainValue;
(function (RuleDomainValue) {
    /** all */
    RuleDomainValue["ALL"] = "all";
    /** none */
    RuleDomainValue["NONE"] = "none";
    /** recommended */
    RuleDomainValue["RECOMMENDED"] = "recommended";
})(RuleDomainValue || (exports.RuleDomainValue = RuleDomainValue = {}));
/**
 * Converts an object of type 'Rules' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Rules(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'a11y': obj.a11Y,
        'complexity': obj.complexity,
        'correctness': obj.correctness,
        'nursery': obj.nursery,
        'performance': obj.performance,
        'recommended': obj.recommended,
        'security': obj.security,
        'style': obj.style,
        'suspicious': obj.suspicious,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideAssistConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideAssistConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'actions': toJson_Actions(obj.actions),
        'enabled': obj.enabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideFilesConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideFilesConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'maxSize': obj.maxSize,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideFormatterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideFormatterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'attributePosition': obj.attributePosition,
        'bracketSameLine': obj.bracketSameLine,
        'bracketSpacing': obj.bracketSpacing,
        'enabled': obj.enabled,
        'expand': obj.expand,
        'formatWithErrors': obj.formatWithErrors,
        'indentSize': obj.indentSize,
        'indentStyle': obj.indentStyle,
        'indentWidth': obj.indentWidth,
        'lineEnding': obj.lineEnding,
        'lineWidth': obj.lineWidth,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/**
 * Converts an object of type 'OverrideLinterConfiguration' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_OverrideLinterConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'domains': ((obj.domains) === undefined) ? undefined : (Object.entries(obj.domains).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {})),
        'enabled': obj.enabled,
        'rules': toJson_Rules(obj.rules),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * Integration with the git client as VCS
 *
 * @schema VcsClientKind
 */
var VcsClientKind;
(function (VcsClientKind) {
    /** git */
    VcsClientKind["GIT"] = "git";
})(VcsClientKind || (exports.VcsClientKind = VcsClientKind = {}));
/**
 * Converts an object of type 'Source' to JSON representation.
 * @internal
 */
/* eslint-disable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
function toJson_Source(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'organizeImports': obj.organizeImports,
        'recommended': obj.recommended,
        'useSortedAttributes': obj.useSortedAttributes,
        'useSortedKeys': obj.useSortedKeys,
        'useSortedProperties': obj.useSortedProperties,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
/* eslint-enable max-len, @stylistic/max-len, quote-props, @stylistic/quote-props */
/**
 * @schema QuoteStyle
 */
var QuoteStyle;
(function (QuoteStyle) {
    /** double */
    QuoteStyle["DOUBLE"] = "double";
    /** single */
    QuoteStyle["SINGLE"] = "single";
})(QuoteStyle || (exports.QuoteStyle = QuoteStyle = {}));
/**
 * Controls whether void-elements should be self closed
 *
 * @schema SelfCloseVoidElements
 */
var SelfCloseVoidElements;
(function (SelfCloseVoidElements) {
    /** never */
    SelfCloseVoidElements["NEVER"] = "never";
    /** always */
    SelfCloseVoidElements["ALWAYS"] = "always";
})(SelfCloseVoidElements || (exports.SelfCloseVoidElements = SelfCloseVoidElements = {}));
/**
 * Whitespace sensitivity for HTML formatting.
 *
 * The following two cases won't produce the same output:
 *
 * |                |      html      |    output    | | -------------- | :------------: | :----------: | | with spaces    | `1<b> 2 </b>3` | 1<b> 2 </b>3 | | without spaces |  `1<b>2</b>3`  |  1<b>2</b>3  |
 *
 * This happens because whitespace is significant in inline elements.
 *
 * As a consequence of this, the formatter must format blocks that look like this (assume a small line width, <20): ```html <span>really long content</span> ``` as this, where the content hugs the tags: ```html <span >really long content</span > ```
 *
 * Note that this is only necessary for inline elements. Block elements do not have this restriction.
 *
 * @schema WhitespaceSensitivity
 */
var WhitespaceSensitivity;
(function (WhitespaceSensitivity) {
    /** css */
    WhitespaceSensitivity["CSS"] = "css";
    /** strict */
    WhitespaceSensitivity["STRICT"] = "strict";
    /** ignore */
    WhitespaceSensitivity["IGNORE"] = "ignore";
})(WhitespaceSensitivity || (exports.WhitespaceSensitivity = WhitespaceSensitivity = {}));
/**
 * @schema ArrowParentheses
 */
var ArrowParentheses;
(function (ArrowParentheses) {
    /** always */
    ArrowParentheses["ALWAYS"] = "always";
    /** asNeeded */
    ArrowParentheses["AS_NEEDED"] = "asNeeded";
})(ArrowParentheses || (exports.ArrowParentheses = ArrowParentheses = {}));
/**
 * @schema OperatorLinebreak
 */
var OperatorLinebreak;
(function (OperatorLinebreak) {
    /** after */
    OperatorLinebreak["AFTER"] = "after";
    /** before */
    OperatorLinebreak["BEFORE"] = "before";
})(OperatorLinebreak || (exports.OperatorLinebreak = OperatorLinebreak = {}));
/**
 * @schema QuoteProperties
 */
var QuoteProperties;
(function (QuoteProperties) {
    /** asNeeded */
    QuoteProperties["AS_NEEDED"] = "asNeeded";
    /** preserve */
    QuoteProperties["PRESERVE"] = "preserve";
})(QuoteProperties || (exports.QuoteProperties = QuoteProperties = {}));
/**
 * @schema Semicolons
 */
var Semicolons;
(function (Semicolons) {
    /** always */
    Semicolons["ALWAYS"] = "always";
    /** asNeeded */
    Semicolons["AS_NEEDED"] = "asNeeded";
})(Semicolons || (exports.Semicolons = Semicolons = {}));
/**
 * Print trailing commas wherever possible in multi-line comma-separated syntactic structures.
 *
 * @schema TrailingCommas
 */
var TrailingCommas;
(function (TrailingCommas) {
    /** all */
    TrailingCommas["ALL"] = "all";
    /** es5 */
    TrailingCommas["ES5"] = "es5";
    /** none */
    TrailingCommas["NONE"] = "none";
})(TrailingCommas || (exports.TrailingCommas = TrailingCommas = {}));
/**
 * @schema TrailingCommas2
 */
var TrailingCommas2;
(function (TrailingCommas2) {
    /** none */
    TrailingCommas2["NONE"] = "none";
    /** all */
    TrailingCommas2["ALL"] = "all";
})(TrailingCommas2 || (exports.TrailingCommas2 = TrailingCommas2 = {}));
//# sourceMappingURL=data:application/json;base64,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