"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ini_1 = require("../ini");
/**
 * File representing the local NPM config in .npmrc
 */
class NpmConfig extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        /**
         * The config object. This object can be mutated until the project is
         * synthesized.
         */
        this.config = {};
        new ini_1.IniFile(project, ".npmrc", {
            obj: this.config,
            omitEmpty: options.omitEmpty,
        });
        if (options.registry) {
            this.addRegistry(options.registry);
        }
    }
    /**
     * configure a scoped registry
     *
     * @param url the URL of the registry to use
     * @param scope the scope the registry is used for; leave empty for the default registry
     */
    addRegistry(url, scope) {
        this.addConfig(scope ? `${scope}:registry` : "registry", url);
    }
    /**
     * configure a generic property
     *
     * @param name the name of the property
     * @param value the value of the property
     */
    addConfig(name, value) {
        this.config[name] = value;
    }
}
exports.NpmConfig = NpmConfig;
_a = JSII_RTTI_SYMBOL_1;
NpmConfig[_a] = { fqn: "projen.javascript.NpmConfig", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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