"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Makefile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * Minimal Makefile.
 */
class Makefile extends file_1.FileBase {
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
        const all = options.all ? options.all : [];
        const rules = options.rules ? options.rules : [];
        rules.forEach((e) => this.validateRule(e));
        this.all = {
            targets: ["all"],
            prerequisites: all,
            phony: true,
        };
        this.rules = [this.all, ...rules];
    }
    /**
     * Add a target to all
     */
    addAll(target) {
        this.all.prerequisites.push(target);
        return this;
    }
    /**
     * Add multiple targets to all
     */
    addAlls(...targets) {
        targets.forEach((e) => this.addAll(e));
        return this;
    }
    /**
     * Add a rule to the Makefile.
     */
    addRule(rule) {
        this.validateRule(rule);
        this.rules.push(rule);
        return this;
    }
    /**
     * Add multiple rules to the Makefile.
     */
    addRules(...rules) {
        rules.forEach((e) => this.addRule(e));
        return this;
    }
    validateRule(rule) {
        if (!rule.targets || !rule.targets.length) {
            throw new Error('"targets" cannot be undefined or empty for items in "rules"');
        }
    }
    synthesizeContent(resolver) {
        const rules = resolver.resolve(this.rules);
        const lines = [
            ...rules.map((rule) => {
                const targets = rule.targets.join(" ");
                const prerequisites = (rule.prerequisites ? rule.prerequisites : []).join(" ");
                const recipe = rule.recipe ? rule.recipe : [];
                const phony = rule.phony ? [`.PHONY: ${targets}`] : [];
                return [
                    ...phony,
                    `${targets}: ${prerequisites}`.trim(),
                    ...recipe.map((step) => `\t${step}`),
                ].join("\n");
            }),
        ];
        return `${lines.join("\n\n")}\n`;
    }
}
exports.Makefile = Makefile;
_a = JSII_RTTI_SYMBOL_1;
Makefile[_a] = { fqn: "projen.Makefile", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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