"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PytestSample = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
/**
 * Python test code sample.
 */
class PytestSample extends __1.Component {
    constructor(project, options) {
        super(project);
        new __1.SampleDir(project, options.testdir, {
            files: {
                "__init__.py": "",
                "test_example.py": [
                    "import pytest",
                    "",
                    `from ${options.moduleName}.example import hello`,
                    "",
                    "@pytest.mark.parametrize(",
                    '    ("name", "expected"),',
                    "    [",
                    '        ("A. Musing", "Hello A. Musing!"),',
                    '        ("traveler", "Hello traveler!"),',
                    '        ("projen developer", "Hello projen developer!"),',
                    "    ],",
                    ")",
                    "def test_hello(name, expected):",
                    '    """Example test with parametrization."""',
                    "    assert hello(name) == expected",
                    "",
                ].join("\n"),
            },
        });
    }
}
exports.PytestSample = PytestSample;
_a = JSII_RTTI_SYMBOL_1;
PytestSample[_a] = { fqn: "projen.python.PytestSample", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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