"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Venv = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const component_1 = require("../component");
const util_1 = require("../util");
/**
 * Manages a virtual environment through the Python venv module.
 */
class Venv extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.envdir = options.envdir ?? ".env";
        this.pythonExec = options.pythonExec ?? "python";
        this.project.addGitIgnore(`/${this.envdir}`);
        // VIRTUAL_ENV is set to the path of the virtual environment, which is what venv does when a virtual environment is activated.
        this.project.tasks.addEnvironment("VIRTUAL_ENV", `$(python -c "import os; print('{0}/${this.envdir}'.format(os.getcwd()))")`);
        // The python executable needs to be first in the PATH environment variable to make calls to the local scoped python instead of the system python.
        this.project.tasks.addEnvironment("PATH", `$(python -c "import os, sys; python_dir = 'Scripts' if sys.platform == 'win32' else 'bin'; print('{0}/${this.envdir}/{1}{2}{3}'.format(os.getcwd(), python_dir, os.pathsep, os.environ['PATH']))")`);
    }
    /**
     * Initializes the virtual environment if it doesn't exist (called during post-synthesis).
     */
    setupEnvironment() {
        const absoluteEnvdir = path.join(this.project.outdir, this.envdir);
        if (!fs.existsSync(absoluteEnvdir)) {
            this.project.logger.info("Setting up a virtual environment...");
            (0, util_1.exec)(`${this.pythonExec} -m venv ${this.envdir}`, {
                cwd: this.project.outdir,
            });
            this.project.logger.info(`Environment successfully created (located in ./${this.envdir}).`);
        }
    }
}
exports.Venv = Venv;
_a = JSII_RTTI_SYMBOL_1;
Venv[_a] = { fqn: "projen.python.Venv", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,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