import { Config } from "conventional-changelog-config-spec";
export interface CommitAndTagOptions {
    readonly tagPrefix?: string;
    readonly versionFile: string;
    readonly changelogFile?: string;
    readonly prerelease?: string;
    readonly configOptions?: Config;
}
export interface InvokeOptions {
    readonly releaseAs?: string;
    readonly dryRun?: boolean;
    /** Avoid updating the version files */
    readonly skipBump?: boolean;
    readonly skipChangelog?: boolean;
    readonly capture?: boolean;
}
export declare class CommitAndTagVersion {
    private readonly cwd;
    private readonly options;
    private readonly cmd;
    constructor(packageSpec: string | undefined, cwd: string, options: CommitAndTagOptions);
    /**
     * Invoke the `commit-and-tag` package
     */
    invoke<A extends InvokeOptions>(options: A): Promise<A extends {
        capture: true;
    } ? string : void>;
    /**
     * Regenerate the most recent change log
     *
     * Do this by deleting the most recent tag, running CATV, then
     * restoring the tag.
     *
     * We do this combined with skipping the bump to make CATV regenerate the
     * changelog of the most recent release (if we left the tag, the changelog
     * would be empty).
     */
    regeneratePreviousChangeLog(version: string, latestTag: string): Promise<void>;
    /**
     * Invoke CATV and return the version it would have bumped to
     *
     * CATV will always at least perform a patch bump, even if there aren't any
     * commits to look at.
     *
     * We have to do this by parsing the output string, which is pretty bad
     * but I don't see that we have another way.
     */
    dryRun(): Promise<string>;
}
