"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Prepends the release changelog entry onto the provided project-level changelog
 *
 * Currently assumes a headerless changelog formatted according to
 * [conventional-changelog](https://github.com/conventional-changelog/conventional-changelog)
 * rules.
 *
 * Environment variables:
 *
 * - VERSION_FILE: Current semantic version file
 * - CHANGELOG_FILE: Release changelog
 * - PROJECT_CHANGELOG_FILE: Project-level changelog
 *
 */
const update_changelog_1 = require("./update-changelog");
const inputChangelog = process.env.CHANGELOG;
const outputChangelog = process.env.PROJECT_CHANGELOG_FILE;
const versionFile = process.env.VERSION_FILE;
if (!versionFile) {
    throw new Error("VERSION_FILE is required");
}
if (!inputChangelog) {
    throw new Error("CHANGELOG is required");
}
if (!outputChangelog) {
    throw new Error("PROJECT_CHANGELOG_FILE is required");
}
const opts = {
    inputChangelog,
    outputChangelog,
    versionFile: versionFile,
};
(0, update_changelog_1.updateChangelog)(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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