import { Eslint, EslintOptions, NodeProject, NodeProjectOptions, TypeScriptCompilerOptions, TypescriptConfig, TypescriptConfigOptions } from "../javascript";
import { Task } from "../task";
import { ProjenrcOptions as ProjenrcTsOptions } from "../typescript";
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/babelConfig/
 */
export declare class TsJestBabelConfig {
    private readonly config;
    /**
     * Disables the use of Babel
     */
    static disabled(): TsJestBabelConfig;
    /**
     * Enables Babel processing
     *
     * `ts-jest` will try to find an existing Babel configuration and pass it to the `babel-jest` processor.
     */
    static autoDetectConfig(): TsJestBabelConfig;
    /**
     * Path to a babelrc file
     *
     * The path should be relative to the current working directory where you start Jest from. You can also use `<rootDir>` in the path.
     */
    static fromFile(filePath: string): TsJestBabelConfig;
    /**
     * Inline compiler options
     * @see https://babeljs.io/docs/options
     */
    static custom(config: Record<string, any>): TsJestBabelConfig;
    private constructor();
    /**
     * @jsii ignore
     * @internal
     */
    toJSON(): boolean | string | Record<string, any>;
}
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/diagnostics/
 */
export declare class TsJestDiagnostics {
    private readonly config;
    /**
     * Enable all diagnostics.
     */
    static all(): TsJestDiagnostics;
    /**
     * Disable all diagnostics.
     */
    static none(): TsJestDiagnostics;
    /**
     * Provide a custom diagnostics configuration.
     *
     * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/diagnostics/
     */
    static custom(config: Record<string, any>): TsJestDiagnostics;
    private constructor();
    /**
     * @jsii ignore
     * @internal
     */
    toJSON(): boolean | Record<string, any>;
}
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/tsconfig/
 */
export declare class TsJestTsconfig {
    private readonly config;
    /**
     * Uses `tsconfig.json` if found, or the built-in default TypeScript compiler options.
     */
    static auto(): TsJestTsconfig;
    /**
     * Force` ts-jest` to use its built-in defaults even if there is a `tsconfig.json` in your project.
     */
    static builtInDefaults(): TsJestTsconfig;
    /**
     * Path to a `tsconfig` file
     *
     * The path should be relative to the current working directory where you start Jest from. You can also use `<rootDir>` in the path to start from the project root dir.
     */
    static fromFile(filePath: string): TsJestTsconfig;
    /**
     * Inline compiler options
     *
     * @see TypeScriptCompilerOptions
     */
    static custom(config: TypeScriptCompilerOptions): TsJestTsconfig;
    private constructor();
    /**
     * @jsii ignore
     * @internal
     */
    toJSON(): boolean | string | TypeScriptCompilerOptions;
}
/**
 * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options
 */
export interface TsJestTransformOptions {
    /**
     * Custom TypeScript AST transformers
     *
     * @default auto
     */
    readonly astTransformers?: Record<string, any>;
    /**
     * Babel(Jest) related configuration.
     *
     * @default TsJestBabelConfig.disabled()
     */
    readonly babelConfig?: TsJestBabelConfig;
    /**
     * TypeScript module to use as compiler.
     *
     * @default "typescript"
     */
    readonly compiler?: string;
    /**
     * Diagnostics related configuration.
     *
     * @default TsJestDiagnostics.all()
     */
    readonly diagnostics?: TsJestDiagnostics;
    /**
     * Run ts-jest tests with this TSConfig isolatedModules setting.
     *
     * You'll lose type-checking ability and some features such as const enum, but in the case you plan on using Jest with the cache disabled (jest --no-cache), your tests will then run much faster.
     * @see https://kulshekhar.github.io/ts-jest/docs/getting-started/options/isolatedModules
     *
     * @default false
     */
    readonly isolatedModules?: boolean;
    /**
     * Files which will become modules returning self content.
     *
     * @default disabled
     */
    readonly stringifyContentPathRegex?: string;
    /**
     * TypeScript compiler related configuration.
     *
     * @default - Your project's `tsconfigDev` file.
     */
    readonly tsconfig?: TsJestTsconfig;
    /**
     * Enable ESM support
     *
     * @default auto
     */
    readonly useESM?: boolean;
}
export interface TsJestOptions {
    /**
     * Which files should ts-jest act upon.
     *
     * @see https://jestjs.io/docs/configuration#transform-objectstring-pathtotransformer--pathtotransformer-object
     *
     * @default "^.+\\.[t]sx?$"
     */
    readonly transformPattern?: string;
    /**
     * Override the default ts-jest transformer configuration.
     */
    readonly transformOptions?: TsJestTransformOptions;
}
export interface TypeScriptProjectOptions extends NodeProjectOptions {
    /**
     * Typescript  artifacts output directory
     *
     * @default "lib"
     */
    readonly libdir?: string;
    /**
     * Typescript sources directory.
     *
     * @default "src"
     */
    readonly srcdir?: string;
    /**
     * Jest tests directory. Tests files should be named `xxx.test.ts`.
     *
     * If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
     * then tests are going to be compiled into `lib/` and executed as javascript.
     * If the test directory is outside of `src`, then we configure jest to
     * compile the code in-memory.
     *
     * @default "test"
     */
    readonly testdir?: string;
    /**
     * Setup eslint.
     *
     * @default - true, unless biome is enabled
     */
    readonly eslint?: boolean;
    /**
     * Eslint options
     * @default - opinionated default options
     */
    readonly eslintOptions?: EslintOptions;
    /**
     * TypeScript version to use.
     *
     * NOTE: Typescript is not semantically versioned and should remain on the
     * same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).
     *
     * @default "latest"
     */
    readonly typescriptVersion?: string;
    /**
     * Docgen by Typedoc
     *
     * @default false
     */
    readonly docgen?: boolean;
    /**
     * Docs directory
     *
     * @default "docs"
     */
    readonly docsDirectory?: string;
    /**
     * Custom TSConfig
     * @default - default options
     */
    readonly tsconfig?: TypescriptConfigOptions;
    /**
     * Custom tsconfig options for the development tsconfig.json file (used for testing).
     * @default - use the production tsconfig options
     */
    readonly tsconfigDev?: TypescriptConfigOptions;
    /**
     * The name of the development tsconfig.json file.
     *
     * @default "tsconfig.dev.json"
     */
    readonly tsconfigDevFile?: string;
    /**
     * Do not generate a `tsconfig.json` file (used by jsii projects since
     * tsconfig.json is generated by the jsii compiler).
     *
     * @default false
     */
    readonly disableTsconfig?: boolean;
    /**
     * Do not generate a `tsconfig.dev.json` file.
     *
     * @default false
     */
    readonly disableTsconfigDev?: boolean;
    /**
     * Generate one-time sample in `src/` and `test/` if there are no files there.
     * @default true
     */
    readonly sampleCode?: boolean;
    /**
     * The .d.ts file that includes the type declarations for this module.
     * @default - .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)
     */
    readonly entrypointTypes?: string;
    /**
     * Use TypeScript for your projenrc file (`.projenrc.ts`).
     *
     * @default false
     * @pjnew true
     */
    readonly projenrcTs?: boolean;
    /**
     * Options for .projenrc.ts
     */
    readonly projenrcTsOptions?: ProjenrcTsOptions;
    /**
     * Options for ts-jest
     */
    readonly tsJestOptions?: TsJestOptions;
}
/**
 * TypeScript project
 * @pjid typescript
 */
export declare class TypeScriptProject extends NodeProject {
    static readonly DEFAULT_TS_JEST_TRANFORM_PATTERN = "^.+\\.[t]sx?$";
    readonly docgen?: boolean;
    readonly docsDirectory: string;
    readonly eslint?: Eslint;
    readonly tsconfigEslint?: TypescriptConfig;
    readonly tsconfig?: TypescriptConfig;
    /**
     * A typescript configuration file which covers all files (sources, tests, projen).
     */
    readonly tsconfigDev: TypescriptConfig;
    /**
     * The directory in which the .ts sources reside.
     */
    readonly srcdir: string;
    /**
     * The directory in which compiled .js files reside.
     */
    readonly libdir: string;
    /**
     * The directory in which tests reside.
     */
    readonly testdir: string;
    /**
     * The "watch" task.
     */
    readonly watchTask: Task;
    constructor(options: TypeScriptProjectOptions);
    /**
     * Projen default Typescript compiler options.
     */
    protected defaultTypeScriptCompilerOptions(): TypeScriptCompilerOptions;
    /**
     * Add `@types/node` to this project.
     *
     * If the user has already added this dependency, do nothing.
     * Otherwise use the major version of `minNodeVersion`.
     * If that's not available, match the version to the used typescript version.
     * And if that is also not available, we use latest and let the user manage the version.
     */
    private addNodeTypesVersion;
    /**
     * Tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them
     * for us. just run them directly from javascript.
     */
    private addJestCompiled;
    private addJestNoCompile;
    private addJestNoCompileModern;
    private addJestNoCompileLegacy;
}
/**
 * TypeScript app.
 *
 * @pjid typescript-app
 */
export declare class TypeScriptAppProject extends TypeScriptProject {
    constructor(options: TypeScriptProjectOptions);
}
/**
 * @deprecated use `TypeScriptProject`
 */
export declare class TypeScriptLibraryProject extends TypeScriptProject {
}
/**
 * @deprecated use TypeScriptProjectOptions
 */
export interface TypeScriptLibraryProjectOptions extends TypeScriptProjectOptions {
}
/**
 * @internal
 */
export declare function mergeTsconfigOptions(...options: (TypescriptConfigOptions | undefined)[]): TypescriptConfigOptions;
