import type { IConstruct } from "constructs";
import type { Component } from "../component";
import type { Project } from "../project";
export declare const PROJECT_SYMBOL: unique symbol;
export declare const COMPONENT_SYMBOL: unique symbol;
/**
 * Create a function to find the closest construct matching a predicate
 * @param predicate
 * @returns A function to find the closest construct matching the predicate
 */
export declare function tryFindClosest<T extends IConstruct>(predicate: (x: any) => x is T): (construct?: IConstruct) => T | undefined;
/**
 * Find the closest project, searching upwards from a construct.
 *
 * @param construct the construct to start searching from
 * @param constructInCreation the name of the construct being created
 * @returns the closest project, if any
 */
export declare function findClosestProject(construct: IConstruct, constructInCreation: string): Project;
/**
 * Find the closest project of a given type, searching upwards from a construct.
 *
 * This function should be used within a class constructor.
 * If not, you must provide a name as second argument or the call will fail.
 *
 * @param construct the construct to start searching from
 * @param constructInCreation the name of the construct being created
 * @returns the closest project of the expected type, if any
 */
export declare function closestProjectMustBe<T>(construct: IConstruct, projectType: new (...args: any[]) => T, constructInCreation: string): T;
export declare function isProject(x: unknown): x is Project;
export declare function isComponent(x: unknown): x is Component;
export declare function tagAsProject(scope: IConstruct): void;
export declare function tagAsComponent(scope: IConstruct): void;
