"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * VS Code Workspace settings
 * Source: https://code.visualstudio.com/docs/getstarted/settings#_workspace-settings
 */
class VsCodeSettings extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        this.content = {};
        this.file = new json_1.JsonFile(vscode.project, ".vscode/settings.json", {
            omitEmpty: false,
            obj: this.content,
        });
    }
    /**
     * Adds a workspace setting
     *
     * @param setting The setting ID
     * @param value The value of the setting
     * @param language Scope the setting to a specific language
     */
    addSetting(setting, value, language) {
        if (language) {
            this.content[`[${language}]`] = this.content[`[${language}]`] ?? {};
            this.content[`[${language}]`][setting] = value;
        }
        else {
            this.content[setting] = value;
        }
    }
    /**
     * Adds a workspace setting
     *
     * @param settings Array structure: [setting: string, value: any, languages?: string[]]
     */
    addSettings(settings, languages) {
        if (Array.isArray(languages)) {
            languages.forEach((language) => {
                Object.entries(settings).forEach(([setting, value]) => this.addSetting(setting, value, language));
            });
        }
        else {
            Object.entries(settings).forEach(([setting, value]) => this.addSetting(setting, value, languages));
        }
    }
}
exports.VsCodeSettings = VsCodeSettings;
_a = JSII_RTTI_SYMBOL_1;
VsCodeSettings[_a] = { fqn: "projen.vscode.VsCodeSettings", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0dGluZ3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdnNjb2RlL3NldHRpbmdzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EsNENBQXlDO0FBQ3pDLGtDQUFtQztBQUVuQzs7O0dBR0c7QUFDSCxNQUFhLGNBQWUsU0FBUSxxQkFBUztJQUkzQyxZQUFZLE1BQWM7UUFDeEIsS0FBSyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUV0QixJQUFJLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQztRQUVsQixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksZUFBUSxDQUFDLE1BQU0sQ0FBQyxPQUFPLEVBQUUsdUJBQXVCLEVBQUU7WUFDaEUsU0FBUyxFQUFFLEtBQUs7WUFDaEIsR0FBRyxFQUFFLElBQUksQ0FBQyxPQUFPO1NBQ2xCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxVQUFVLENBQUMsT0FBZSxFQUFFLEtBQWMsRUFBRSxRQUFpQjtRQUNsRSxJQUFJLFFBQVEsRUFBRSxDQUFDO1lBQ2IsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLFFBQVEsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLFFBQVEsR0FBRyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ3BFLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxRQUFRLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEtBQUssQ0FBQztRQUNqRCxDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsS0FBSyxDQUFDO1FBQ2hDLENBQUM7SUFDSCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLFdBQVcsQ0FDaEIsUUFBaUMsRUFDakMsU0FBNkI7UUFFN0IsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUM7WUFDN0IsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFO2dCQUM3QixNQUFNLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsQ0FDcEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUMxQyxDQUFDO1lBQ0osQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDO2FBQU0sQ0FBQztZQUNOLE1BQU0sQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLEVBQUUsRUFBRSxDQUNwRCxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxLQUFLLEVBQUUsU0FBUyxDQUFDLENBQzNDLENBQUM7UUFDSixDQUFDO0lBQ0gsQ0FBQzs7QUFuREgsd0NBb0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVnNDb2RlIH0gZnJvbSBcIi4vdnNjb2RlXCI7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBKc29uRmlsZSB9IGZyb20gXCIuLi9qc29uXCI7XG5cbi8qKlxuICogVlMgQ29kZSBXb3Jrc3BhY2Ugc2V0dGluZ3NcbiAqIFNvdXJjZTogaHR0cHM6Ly9jb2RlLnZpc3VhbHN0dWRpby5jb20vZG9jcy9nZXRzdGFydGVkL3NldHRpbmdzI193b3Jrc3BhY2Utc2V0dGluZ3NcbiAqL1xuZXhwb3J0IGNsYXNzIFZzQ29kZVNldHRpbmdzIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHJpdmF0ZSByZWFkb25seSBjb250ZW50OiBhbnk7XG4gIHB1YmxpYyByZWFkb25seSBmaWxlOiBKc29uRmlsZTtcblxuICBjb25zdHJ1Y3Rvcih2c2NvZGU6IFZzQ29kZSkge1xuICAgIHN1cGVyKHZzY29kZS5wcm9qZWN0KTtcblxuICAgIHRoaXMuY29udGVudCA9IHt9O1xuXG4gICAgdGhpcy5maWxlID0gbmV3IEpzb25GaWxlKHZzY29kZS5wcm9qZWN0LCBcIi52c2NvZGUvc2V0dGluZ3MuanNvblwiLCB7XG4gICAgICBvbWl0RW1wdHk6IGZhbHNlLFxuICAgICAgb2JqOiB0aGlzLmNvbnRlbnQsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHdvcmtzcGFjZSBzZXR0aW5nXG4gICAqXG4gICAqIEBwYXJhbSBzZXR0aW5nIFRoZSBzZXR0aW5nIElEXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUgb2YgdGhlIHNldHRpbmdcbiAgICogQHBhcmFtIGxhbmd1YWdlIFNjb3BlIHRoZSBzZXR0aW5nIHRvIGEgc3BlY2lmaWMgbGFuZ3VhZ2VcbiAgICovXG4gIHB1YmxpYyBhZGRTZXR0aW5nKHNldHRpbmc6IHN0cmluZywgdmFsdWU6IHVua25vd24sIGxhbmd1YWdlPzogc3RyaW5nKSB7XG4gICAgaWYgKGxhbmd1YWdlKSB7XG4gICAgICB0aGlzLmNvbnRlbnRbYFske2xhbmd1YWdlfV1gXSA9IHRoaXMuY29udGVudFtgWyR7bGFuZ3VhZ2V9XWBdID8/IHt9O1xuICAgICAgdGhpcy5jb250ZW50W2BbJHtsYW5ndWFnZX1dYF1bc2V0dGluZ10gPSB2YWx1ZTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5jb250ZW50W3NldHRpbmddID0gdmFsdWU7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSB3b3Jrc3BhY2Ugc2V0dGluZ1xuICAgKlxuICAgKiBAcGFyYW0gc2V0dGluZ3MgQXJyYXkgc3RydWN0dXJlOiBbc2V0dGluZzogc3RyaW5nLCB2YWx1ZTogYW55LCBsYW5ndWFnZXM/OiBzdHJpbmdbXV1cbiAgICovXG4gIHB1YmxpYyBhZGRTZXR0aW5ncyhcbiAgICBzZXR0aW5nczogUmVjb3JkPHN0cmluZywgdW5rbm93bj4sXG4gICAgbGFuZ3VhZ2VzPzogc3RyaW5nIHwgc3RyaW5nW11cbiAgKSB7XG4gICAgaWYgKEFycmF5LmlzQXJyYXkobGFuZ3VhZ2VzKSkge1xuICAgICAgbGFuZ3VhZ2VzLmZvckVhY2goKGxhbmd1YWdlKSA9PiB7XG4gICAgICAgIE9iamVjdC5lbnRyaWVzKHNldHRpbmdzKS5mb3JFYWNoKChbc2V0dGluZywgdmFsdWVdKSA9PlxuICAgICAgICAgIHRoaXMuYWRkU2V0dGluZyhzZXR0aW5nLCB2YWx1ZSwgbGFuZ3VhZ2UpXG4gICAgICAgICk7XG4gICAgICB9KTtcbiAgICB9IGVsc2Uge1xuICAgICAgT2JqZWN0LmVudHJpZXMoc2V0dGluZ3MpLmZvckVhY2goKFtzZXR0aW5nLCB2YWx1ZV0pID0+XG4gICAgICAgIHRoaXMuYWRkU2V0dGluZyhzZXR0aW5nLCB2YWx1ZSwgbGFuZ3VhZ2VzKVxuICAgICAgKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==