"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostCss = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tailwind_1 = require("./tailwind");
const json_1 = require("../json");
/**
 * Declares a PostCSS dependency with a default config file.
 */
class PostCss {
    constructor(project, options) {
        this.fileName = options?.fileName ?? "postcss.config.json";
        project.addDeps("postcss");
        const config = { plugins: {} };
        if (options?.tailwind ?? true) {
            config.plugins.tailwindcss = {};
            config.plugins.autoprefixer = {};
            this.tailwind = new tailwind_1.TailwindConfig(project, options?.tailwindOptions);
            config.plugins.tailwindcss.config = this.tailwind.fileName;
            project.addDeps("tailwindcss", "autoprefixer");
        }
        this.file = new json_1.JsonFile(project, this.fileName, {
            obj: config,
            marker: false,
        });
        project.npmignore?.exclude(`/${this.fileName}`);
    }
}
exports.PostCss = PostCss;
_a = JSII_RTTI_SYMBOL_1;
PostCss[_a] = { fqn: "projen.web.PostCss", version: "0.98.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9zdGNzcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy93ZWIvcG9zdGNzcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHlDQUFtRTtBQUVuRSxrQ0FBbUM7QUFxQm5DOztHQUVHO0FBQ0gsTUFBYSxPQUFPO0lBS2xCLFlBQVksT0FBb0IsRUFBRSxPQUF3QjtRQUN4RCxJQUFJLENBQUMsUUFBUSxHQUFHLE9BQU8sRUFBRSxRQUFRLElBQUkscUJBQXFCLENBQUM7UUFFM0QsT0FBTyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUUzQixNQUFNLE1BQU0sR0FBMkIsRUFBRSxPQUFPLEVBQUUsRUFBRSxFQUFFLENBQUM7UUFFdkQsSUFBSSxPQUFPLEVBQUUsUUFBUSxJQUFJLElBQUksRUFBRSxDQUFDO1lBQzlCLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxHQUFHLEVBQUUsQ0FBQztZQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUM7WUFDakMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLHlCQUFjLENBQUMsT0FBTyxFQUFFLE9BQU8sRUFBRSxlQUFlLENBQUMsQ0FBQztZQUN0RSxNQUFNLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUM7WUFDM0QsT0FBTyxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDakQsQ0FBQztRQUVELElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxlQUFRLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDL0MsR0FBRyxFQUFFLE1BQU07WUFDWCxNQUFNLEVBQUUsS0FBSztTQUNkLENBQUMsQ0FBQztRQUVILE9BQU8sQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7SUFDbEQsQ0FBQzs7QUExQkgsMEJBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGFpbHdpbmRDb25maWcsIFRhaWx3aW5kQ29uZmlnT3B0aW9ucyB9IGZyb20gXCIuL3RhaWx3aW5kXCI7XG5pbXBvcnQgeyBOb2RlUHJvamVjdCB9IGZyb20gXCIuLi9qYXZhc2NyaXB0XCI7XG5pbXBvcnQgeyBKc29uRmlsZSB9IGZyb20gXCIuLi9qc29uXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUG9zdENzc09wdGlvbnMge1xuICAvKipcbiAgICogQGRlZmF1bHQgXCJwb3N0Y3NzLmNvbmZpZy5qc29uXCJcbiAgICovXG4gIHJlYWRvbmx5IGZpbGVOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBJbnN0YWxsIFRhaWx3aW5kIENTUyBhcyBhIFBvc3RDU1MgcGx1Z2luLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSB0YWlsd2luZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRhaWx3aW5kIENTUyBvcHRpb25zLlxuICAgKi9cbiAgcmVhZG9ubHkgdGFpbHdpbmRPcHRpb25zPzogVGFpbHdpbmRDb25maWdPcHRpb25zO1xufVxuXG4vKipcbiAqIERlY2xhcmVzIGEgUG9zdENTUyBkZXBlbmRlbmN5IHdpdGggYSBkZWZhdWx0IGNvbmZpZyBmaWxlLlxuICovXG5leHBvcnQgY2xhc3MgUG9zdENzcyB7XG4gIHB1YmxpYyByZWFkb25seSBmaWxlTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZmlsZTogSnNvbkZpbGU7XG4gIHB1YmxpYyByZWFkb25seSB0YWlsd2luZD86IFRhaWx3aW5kQ29uZmlnO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0LCBvcHRpb25zPzogUG9zdENzc09wdGlvbnMpIHtcbiAgICB0aGlzLmZpbGVOYW1lID0gb3B0aW9ucz8uZmlsZU5hbWUgPz8gXCJwb3N0Y3NzLmNvbmZpZy5qc29uXCI7XG5cbiAgICBwcm9qZWN0LmFkZERlcHMoXCJwb3N0Y3NzXCIpO1xuXG4gICAgY29uc3QgY29uZmlnOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ID0geyBwbHVnaW5zOiB7fSB9O1xuXG4gICAgaWYgKG9wdGlvbnM/LnRhaWx3aW5kID8/IHRydWUpIHtcbiAgICAgIGNvbmZpZy5wbHVnaW5zLnRhaWx3aW5kY3NzID0ge307XG4gICAgICBjb25maWcucGx1Z2lucy5hdXRvcHJlZml4ZXIgPSB7fTtcbiAgICAgIHRoaXMudGFpbHdpbmQgPSBuZXcgVGFpbHdpbmRDb25maWcocHJvamVjdCwgb3B0aW9ucz8udGFpbHdpbmRPcHRpb25zKTtcbiAgICAgIGNvbmZpZy5wbHVnaW5zLnRhaWx3aW5kY3NzLmNvbmZpZyA9IHRoaXMudGFpbHdpbmQuZmlsZU5hbWU7XG4gICAgICBwcm9qZWN0LmFkZERlcHMoXCJ0YWlsd2luZGNzc1wiLCBcImF1dG9wcmVmaXhlclwiKTtcbiAgICB9XG5cbiAgICB0aGlzLmZpbGUgPSBuZXcgSnNvbkZpbGUocHJvamVjdCwgdGhpcy5maWxlTmFtZSwge1xuICAgICAgb2JqOiBjb25maWcsXG4gICAgICBtYXJrZXI6IGZhbHNlLFxuICAgIH0pO1xuXG4gICAgcHJvamVjdC5ucG1pZ25vcmU/LmV4Y2x1ZGUoYC8ke3RoaXMuZmlsZU5hbWV9YCk7XG4gIH1cbn1cbiJdfQ==