# Generated by Django 4.2.11 on 2024-06-28 07:27

# Django
import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        ("eveuniverse", "0010_alter_eveindustryactivityduration_eve_type_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app, Killstats."),
                    ("admin_access", "Has access to all killboards."),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="EveEntity",
            fields=[
                (
                    "eve_id",
                    models.IntegerField(
                        primary_key=True,
                        serialize=False,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="id",
                    ),
                ),
                (
                    "category",
                    models.CharField(
                        choices=[
                            ("alliance", "Alliance"),
                            ("corporation", "Corporation"),
                            ("character", "Character"),
                        ],
                        max_length=32,
                        verbose_name="category",
                    ),
                ),
                ("name", models.CharField(max_length=254, verbose_name="name")),
                ("last_update", models.DateTimeField(auto_now=True)),
                (
                    "alliance",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="alli",
                        to="killstats.eveentity",
                    ),
                ),
                (
                    "corporation",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="corp",
                        to="killstats.eveentity",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="KillstatsAudit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("last_update", models.DateTimeField(auto_now=True)),
                (
                    "corporation",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveonline.evecorporationinfo",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveonline.evecharacter",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Killmail",
            fields=[
                (
                    "killmail_id",
                    models.PositiveBigIntegerField(primary_key=True, serialize=False),
                ),
                ("killmail_date", models.DateTimeField(blank=True, null=True)),
                ("victim_corporation_id", models.PositiveBigIntegerField()),
                (
                    "victim_alliance_id",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                ("hash", models.CharField(max_length=255, unique=True)),
                (
                    "victim_total_value",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    "victim_fitted_value",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    "victim_destroyed_value",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    "victim_dropped_value",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    "victim_region_id",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    "victim_solar_system_id",
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                ("victim_position_x", models.FloatField(blank=True, null=True)),
                ("victim_position_y", models.FloatField(blank=True, null=True)),
                ("victim_position_z", models.FloatField(blank=True, null=True)),
                ("attackers", models.JSONField(blank=True, null=True)),
                (
                    "victim",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="killstats.eveentity",
                    ),
                ),
                (
                    "victim_ship",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
    ]
