# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthBackendConfigArgs', 'AuthBackendConfig']

@pulumi.input_type
class AuthBackendConfigArgs:
    def __init__(__self__, *,
                 resource: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AuthBackendConfig resource.
        :param pulumi.Input[_builtins.str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        :param pulumi.Input[_builtins.str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[_builtins.str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[_builtins.str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity tokens. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Input[_builtins.str]:
        """
        The configured URL for the application registered in
        Azure Active Directory.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenant id for the Azure Active Directory
        organization.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the Azure auth backend being configured was
        mounted at.  Defaults to `azure`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client id for credentials to query the Azure APIs.
        Currently read permissions to query compute resources are required.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret for credentials to query the
        Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure cloud environment. Valid values:
        AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
        AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value for plugin identity tokens. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated identity tokens in seconds.
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)


@pulumi.input_type
class _AuthBackendConfigState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendConfig resources.
        :param pulumi.Input[_builtins.str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[_builtins.str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[_builtins.str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity tokens. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if disable_automated_rotation is not None:
            pulumi.set(__self__, "disable_automated_rotation", disable_automated_rotation)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if identity_token_audience is not None:
            pulumi.set(__self__, "identity_token_audience", identity_token_audience)
        if identity_token_ttl is not None:
            pulumi.set(__self__, "identity_token_ttl", identity_token_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if rotation_period is not None:
            pulumi.set(__self__, "rotation_period", rotation_period)
        if rotation_schedule is not None:
            pulumi.set(__self__, "rotation_schedule", rotation_schedule)
        if rotation_window is not None:
            pulumi.set(__self__, "rotation_window", rotation_window)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the Azure auth backend being configured was
        mounted at.  Defaults to `azure`.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client id for credentials to query the Azure APIs.
        Currently read permissions to query compute resources are required.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret for credentials to query the
        Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "disable_automated_rotation")

    @disable_automated_rotation.setter
    def disable_automated_rotation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_automated_rotation", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure cloud environment. Valid values:
        AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
        AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audience claim value for plugin identity tokens. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_audience")

    @identity_token_audience.setter
    def identity_token_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token_audience", value)

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The TTL of generated identity tokens in seconds.
        """
        return pulumi.get(self, "identity_token_ttl")

    @identity_token_ttl.setter
    def identity_token_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "identity_token_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured URL for the application registered in
        Azure Active Directory.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_period")

    @rotation_period.setter
    def rotation_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_period", value)

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_schedule")

    @rotation_schedule.setter
    def rotation_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotation_schedule", value)

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_window")

    @rotation_window.setter
    def rotation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_window", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant id for the Azure Active Directory
        organization.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("vault:azure/authBackendConfig:AuthBackendConfig")
class AuthBackendConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        You can setup the Azure auth engine with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example",
            type="azure",
            identity_token_key="example-key")
        example_auth_backend_config = vault.azure.AuthBackendConfig("example",
            backend=example.path,
            tenant_id="11111111-2222-3333-4444-555555555555",
            client_id="11111111-2222-3333-4444-555555555555",
            identity_token_audience="<TOKEN_AUDIENCE>",
            identity_token_ttl="<TOKEN_TTL>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="azure")
        example_auth_backend_config = vault.azure.AuthBackendConfig("example",
            backend=example.path,
            tenant_id="11111111-2222-3333-4444-555555555555",
            client_id="11111111-2222-3333-4444-555555555555",
            client_secret="01234567890123456789",
            resource="https://vault.hashicorp.com",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Import

        Azure auth backends can be imported using `auth/`, the `backend` path, and `/config` e.g.

        ```sh
        $ pulumi import vault:azure/authBackendConfig:AuthBackendConfig example auth/azure/config
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[_builtins.str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[_builtins.str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity tokens. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        You can setup the Azure auth engine with Workload Identity Federation (WIF) for a secret-less configuration:
        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example",
            type="azure",
            identity_token_key="example-key")
        example_auth_backend_config = vault.azure.AuthBackendConfig("example",
            backend=example.path,
            tenant_id="11111111-2222-3333-4444-555555555555",
            client_id="11111111-2222-3333-4444-555555555555",
            identity_token_audience="<TOKEN_AUDIENCE>",
            identity_token_ttl="<TOKEN_TTL>",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.AuthBackend("example", type="azure")
        example_auth_backend_config = vault.azure.AuthBackendConfig("example",
            backend=example.path,
            tenant_id="11111111-2222-3333-4444-555555555555",
            client_id="11111111-2222-3333-4444-555555555555",
            client_secret="01234567890123456789",
            resource="https://vault.hashicorp.com",
            rotation_schedule="0 * * * SAT",
            rotation_window=3600)
        ```

        ## Import

        Azure auth backends can be imported using `auth/`, the `backend` path, and `/config` e.g.

        ```sh
        $ pulumi import vault:azure/authBackendConfig:AuthBackendConfig example auth/azure/config
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 resource: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendConfigArgs.__new__(AuthBackendConfigArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["client_id"] = None if client_id is None else pulumi.Output.secret(client_id)
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
            __props__.__dict__["environment"] = environment
            __props__.__dict__["identity_token_audience"] = identity_token_audience
            __props__.__dict__["identity_token_ttl"] = identity_token_ttl
            __props__.__dict__["namespace"] = namespace
            if resource is None and not opts.urn:
                raise TypeError("Missing required property 'resource'")
            __props__.__dict__["resource"] = resource
            __props__.__dict__["rotation_period"] = rotation_period
            __props__.__dict__["rotation_schedule"] = rotation_schedule
            __props__.__dict__["rotation_window"] = rotation_window
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = None if tenant_id is None else pulumi.Output.secret(tenant_id)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientId", "clientSecret", "tenantId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackendConfig, __self__).__init__(
            'vault:azure/authBackendConfig:AuthBackendConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            disable_automated_rotation: Optional[pulumi.Input[_builtins.bool]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_audience: Optional[pulumi.Input[_builtins.str]] = None,
            identity_token_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            resource: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_period: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_window: Optional[pulumi.Input[_builtins.int]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthBackendConfig':
        """
        Get an existing AuthBackendConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path the Azure auth backend being configured was
               mounted at.  Defaults to `azure`.
        :param pulumi.Input[_builtins.str] client_id: The client id for credentials to query the Azure APIs.
               Currently read permissions to query compute resources are required.
        :param pulumi.Input[_builtins.str] client_secret: The client secret for credentials to query the
               Azure APIs.
        :param pulumi.Input[_builtins.bool] disable_automated_rotation: Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] environment: The Azure cloud environment. Valid values:
               AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
               AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        :param pulumi.Input[_builtins.str] identity_token_audience: The audience claim value for plugin identity tokens. Requires Vault 1.17+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] identity_token_ttl: The TTL of generated identity tokens in seconds.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] resource: The configured URL for the application registered in
               Azure Active Directory.
        :param pulumi.Input[_builtins.int] rotation_period: The amount of time in seconds Vault should wait before rotating the root credential.
               A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] rotation_schedule: The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
               defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.int] rotation_window: The maximum amount of time in seconds allowed to complete
               a rotation when a scheduled token rotation occurs. The default rotation window is
               unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
               *Available only for Vault Enterprise*
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id for the Azure Active Directory
               organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendConfigState.__new__(_AuthBackendConfigState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["disable_automated_rotation"] = disable_automated_rotation
        __props__.__dict__["environment"] = environment
        __props__.__dict__["identity_token_audience"] = identity_token_audience
        __props__.__dict__["identity_token_ttl"] = identity_token_ttl
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["resource"] = resource
        __props__.__dict__["rotation_period"] = rotation_period
        __props__.__dict__["rotation_schedule"] = rotation_schedule
        __props__.__dict__["rotation_window"] = rotation_window
        __props__.__dict__["tenant_id"] = tenant_id
        return AuthBackendConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path the Azure auth backend being configured was
        mounted at.  Defaults to `azure`.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The client id for credentials to query the Azure APIs.
        Currently read permissions to query compute resources are required.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The client secret for credentials to query the
        Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="disableAutomatedRotation")
    def disable_automated_rotation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Cancels all upcoming rotations of the root credential until unset. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "disable_automated_rotation")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure cloud environment. Valid values:
        AzurePublicCloud, AzureUSGovernmentCloud, AzureChinaCloud,
        AzureGermanCloud.  Defaults to `AzurePublicCloud`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="identityTokenAudience")
    def identity_token_audience(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audience claim value for plugin identity tokens. Requires Vault 1.17+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "identity_token_audience")

    @_builtins.property
    @pulumi.getter(name="identityTokenTtl")
    def identity_token_ttl(self) -> pulumi.Output[_builtins.int]:
        """
        The TTL of generated identity tokens in seconds.
        """
        return pulumi.get(self, "identity_token_ttl")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Output[_builtins.str]:
        """
        The configured URL for the application registered in
        Azure Active Directory.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time in seconds Vault should wait before rotating the root credential.
        A zero value tells Vault not to rotate the root credential. The minimum rotation period is 10 seconds. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_period")

    @_builtins.property
    @pulumi.getter(name="rotationSchedule")
    def rotation_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule, in [cron-style time format](https://en.wikipedia.org/wiki/Cron),
        defining the schedule on which Vault should rotate the root token. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_schedule")

    @_builtins.property
    @pulumi.getter(name="rotationWindow")
    def rotation_window(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum amount of time in seconds allowed to complete
        a rotation when a scheduled token rotation occurs. The default rotation window is
        unbound and the minimum allowable window is `3600`. Requires Vault Enterprise 1.19+.
        *Available only for Vault Enterprise*
        """
        return pulumi.get(self, "rotation_window")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant id for the Azure Active Directory
        organization.
        """
        return pulumi.get(self, "tenant_id")

