# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 creation_statements: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 db_name: pulumi.Input[_builtins.str],
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] credential_config: Specifies the configuration
               for the given `credential_type`.
               
               The following options are available for each `credential_type` value:
        :param pulumi.Input[_builtins.str] credential_type: Specifies the type of credential that
               will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
               See the plugin's API page for credential types supported by individual databases.
        :param pulumi.Input[_builtins.int] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "creation_statements", creation_statements)
        pulumi.set(__self__, "db_name", db_name)
        if credential_config is not None:
            pulumi.set(__self__, "credential_config", credential_config)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if renew_statements is not None:
            pulumi.set(__self__, "renew_statements", renew_statements)
        if revocation_statements is not None:
            pulumi.set(__self__, "revocation_statements", revocation_statements)
        if rollback_statements is not None:
            pulumi.set(__self__, "rollback_statements", rollback_statements)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="creationStatements")
    def creation_statements(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The database statements to execute when
        creating a user.
        """
        return pulumi.get(self, "creation_statements")

    @creation_statements.setter
    def creation_statements(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "creation_statements", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the database connection to use for
        the role.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="credentialConfig")
    def credential_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the configuration
        for the given `credential_type`.

        The following options are available for each `credential_type` value:
        """
        return pulumi.get(self, "credential_config")

    @credential_config.setter
    def credential_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "credential_config", value)

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of credential that
        will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
        See the plugin's API page for credential types supported by individual databases.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to give the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="renewStatements")
    def renew_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        renewing a user.
        """
        return pulumi.get(self, "renew_statements")

    @renew_statements.setter
    def renew_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "renew_statements", value)

    @_builtins.property
    @pulumi.getter(name="revocationStatements")
    def revocation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        revoking a user.
        """
        return pulumi.get(self, "revocation_statements")

    @revocation_statements.setter
    def revocation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "revocation_statements", value)

    @_builtins.property
    @pulumi.getter(name="rollbackStatements")
    def rollback_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        rolling back creation due to an error.
        """
        return pulumi.get(self, "rollback_statements")

    @rollback_statements.setter
    def rollback_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rollback_statements", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] credential_config: Specifies the configuration
               for the given `credential_type`.
               
               The following options are available for each `credential_type` value:
        :param pulumi.Input[_builtins.str] credential_type: Specifies the type of credential that
               will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
               See the plugin's API page for credential types supported by individual databases.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[_builtins.int] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if creation_statements is not None:
            pulumi.set(__self__, "creation_statements", creation_statements)
        if credential_config is not None:
            pulumi.set(__self__, "credential_config", credential_config)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if renew_statements is not None:
            pulumi.set(__self__, "renew_statements", renew_statements)
        if revocation_statements is not None:
            pulumi.set(__self__, "revocation_statements", revocation_statements)
        if rollback_statements is not None:
            pulumi.set(__self__, "rollback_statements", rollback_statements)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="creationStatements")
    def creation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        creating a user.
        """
        return pulumi.get(self, "creation_statements")

    @creation_statements.setter
    def creation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "creation_statements", value)

    @_builtins.property
    @pulumi.getter(name="credentialConfig")
    def credential_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the configuration
        for the given `credential_type`.

        The following options are available for each `credential_type` value:
        """
        return pulumi.get(self, "credential_config")

    @credential_config.setter
    def credential_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "credential_config", value)

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of credential that
        will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
        See the plugin's API page for credential types supported by individual databases.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the database connection to use for
        the role.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to give the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="renewStatements")
    def renew_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        renewing a user.
        """
        return pulumi.get(self, "renew_statements")

    @renew_statements.setter
    def renew_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "renew_statements", value)

    @_builtins.property
    @pulumi.getter(name="revocationStatements")
    def revocation_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        revoking a user.
        """
        return pulumi.get(self, "revocation_statements")

    @revocation_statements.setter
    def revocation_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "revocation_statements", value)

    @_builtins.property
    @pulumi.getter(name="rollbackStatements")
    def rollback_statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The database statements to execute when
        rolling back creation due to an error.
        """
        return pulumi.get(self, "rollback_statements")

    @rollback_statements.setter
    def rollback_statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rollback_statements", value)


@pulumi.type_token("vault:database/secretBackendRole:SecretBackendRole")
class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            backend=db.path,
            name="postgres",
            allowed_roles=[
                "dev",
                "prod",
            ],
            postgresql={
                "connection_url": "postgres://username:password@host:port/database",
            })
        role = vault.database.SecretBackendRole("role",
            backend=db.path,
            name="dev",
            db_name=postgres.name,
            creation_statements=["CREATE ROLE \\"{{name}}\\" WITH LOGIN PASSWORD '{{password}}' VALID UNTIL '{{expiration}}';"])
        ```

        ## Import

        Database secret backend roles can be imported using the `backend`, `/roles/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:database/secretBackendRole:SecretBackendRole example postgres/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] credential_config: Specifies the configuration
               for the given `credential_type`.
               
               The following options are available for each `credential_type` value:
        :param pulumi.Input[_builtins.str] credential_type: Specifies the type of credential that
               will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
               See the plugin's API page for credential types supported by individual databases.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[_builtins.int] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            backend=db.path,
            name="postgres",
            allowed_roles=[
                "dev",
                "prod",
            ],
            postgresql={
                "connection_url": "postgres://username:password@host:port/database",
            })
        role = vault.database.SecretBackendRole("role",
            backend=db.path,
            name="dev",
            db_name=postgres.name,
            creation_statements=["CREATE ROLE \\"{{name}}\\" WITH LOGIN PASSWORD '{{password}}' VALID UNTIL '{{expiration}}';"])
        ```

        ## Import

        Database secret backend roles can be imported using the `backend`, `/roles/`, and the `name` e.g.

        ```sh
        $ pulumi import vault:database/secretBackendRole:SecretBackendRole example postgres/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if creation_statements is None and not opts.urn:
                raise TypeError("Missing required property 'creation_statements'")
            __props__.__dict__["creation_statements"] = creation_statements
            __props__.__dict__["credential_config"] = credential_config
            __props__.__dict__["credential_type"] = credential_type
            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["default_ttl"] = default_ttl
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["renew_statements"] = renew_statements
            __props__.__dict__["revocation_statements"] = revocation_statements
            __props__.__dict__["rollback_statements"] = rollback_statements
        super(SecretBackendRole, __self__).__init__(
            'vault:database/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            creation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            credential_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            credential_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] credential_config: Specifies the configuration
               for the given `credential_type`.
               
               The following options are available for each `credential_type` value:
        :param pulumi.Input[_builtins.str] credential_type: Specifies the type of credential that
               will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
               See the plugin's API page for credential types supported by individual databases.
        :param pulumi.Input[_builtins.str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[_builtins.int] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[_builtins.str] name: A unique name to give the role.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["creation_statements"] = creation_statements
        __props__.__dict__["credential_config"] = credential_config
        __props__.__dict__["credential_type"] = credential_type
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["default_ttl"] = default_ttl
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["renew_statements"] = renew_statements
        __props__.__dict__["revocation_statements"] = revocation_statements
        __props__.__dict__["rollback_statements"] = rollback_statements
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="creationStatements")
    def creation_statements(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The database statements to execute when
        creating a user.
        """
        return pulumi.get(self, "creation_statements")

    @_builtins.property
    @pulumi.getter(name="credentialConfig")
    def credential_config(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the configuration
        for the given `credential_type`.

        The following options are available for each `credential_type` value:
        """
        return pulumi.get(self, "credential_config")

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of credential that
        will be generated for the role. Options include: `password`, `rsa_private_key`, `client_certificate`.
        See the plugin's API page for credential types supported by individual databases.
        """
        return pulumi.get(self, "credential_type")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the database connection to use for
        the role.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The default number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "default_ttl")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name to give the role.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="renewStatements")
    def renew_statements(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The database statements to execute when
        renewing a user.
        """
        return pulumi.get(self, "renew_statements")

    @_builtins.property
    @pulumi.getter(name="revocationStatements")
    def revocation_statements(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The database statements to execute when
        revoking a user.
        """
        return pulumi.get(self, "revocation_statements")

    @_builtins.property
    @pulumi.getter(name="rollbackStatements")
    def rollback_statements(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The database statements to execute when
        rolling back creation due to an error.
        """
        return pulumi.get(self, "rollback_statements")

