# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNamespacesResult',
    'AwaitableGetNamespacesResult',
    'get_namespaces',
    'get_namespaces_output',
]

@pulumi.output_type
class GetNamespacesResult:
    """
    A collection of values returned by getNamespaces.
    """
    def __init__(__self__, id=None, namespace=None, paths=None, paths_fqs=None, recursive=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if paths and not isinstance(paths, list):
            raise TypeError("Expected argument 'paths' to be a list")
        pulumi.set(__self__, "paths", paths)
        if paths_fqs and not isinstance(paths_fqs, list):
            raise TypeError("Expected argument 'paths_fqs' to be a list")
        pulumi.set(__self__, "paths_fqs", paths_fqs)
        if recursive and not isinstance(recursive, bool):
            raise TypeError("Expected argument 'recursive' to be a bool")
        pulumi.set(__self__, "recursive", recursive)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        Set of the paths of child namespaces.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter(name="pathsFqs")
    def paths_fqs(self) -> Sequence[_builtins.str]:
        """
        Set of the fully qualified paths of child namespaces.
        """
        return pulumi.get(self, "paths_fqs")

    @_builtins.property
    @pulumi.getter
    def recursive(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "recursive")


class AwaitableGetNamespacesResult(GetNamespacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespacesResult(
            id=self.id,
            namespace=self.namespace,
            paths=self.paths,
            paths_fqs=self.paths_fqs,
            recursive=self.recursive)


def get_namespaces(namespace: Optional[_builtins.str] = None,
                   recursive: Optional[_builtins.bool] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespacesResult:
    """
    ## Example Usage

    ### Direct child namespaces

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces()
    ```

    ### All child namespaces

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces(recursive=True)
    ```

    ### Child namespace details

    To fetch the details of child namespaces:

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces(namespace="parent")
    child = {__key: vault.get_namespace(namespace=children.namespace,
        path=__key) for __key, __value in children.paths}
    ```


    :param _builtins.str namespace: The namespace to provision the resource in.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
    :param _builtins.bool recursive: If `true`, it will returns all child namespaces of the given namespace. Defaults to `false`, which returns only direct child namespaces.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['recursive'] = recursive
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:index/getNamespaces:getNamespaces', __args__, opts=opts, typ=GetNamespacesResult).value

    return AwaitableGetNamespacesResult(
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        paths=pulumi.get(__ret__, 'paths'),
        paths_fqs=pulumi.get(__ret__, 'paths_fqs'),
        recursive=pulumi.get(__ret__, 'recursive'))
def get_namespaces_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          recursive: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamespacesResult]:
    """
    ## Example Usage

    ### Direct child namespaces

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces()
    ```

    ### All child namespaces

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces(recursive=True)
    ```

    ### Child namespace details

    To fetch the details of child namespaces:

    ```python
    import pulumi
    import pulumi_vault as vault

    children = vault.get_namespaces(namespace="parent")
    child = {__key: vault.get_namespace(namespace=children.namespace,
        path=__key) for __key, __value in children.paths}
    ```


    :param _builtins.str namespace: The namespace to provision the resource in.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
    :param _builtins.bool recursive: If `true`, it will returns all child namespaces of the given namespace. Defaults to `false`, which returns only direct child namespaces.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['recursive'] = recursive
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:index/getNamespaces:getNamespaces', __args__, opts=opts, typ=GetNamespacesResult)
    return __ret__.apply(lambda __response__: GetNamespacesResult(
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        paths=pulumi.get(__response__, 'paths'),
        paths_fqs=pulumi.get(__response__, 'paths_fqs'),
        recursive=pulumi.get(__response__, 'recursive')))
