# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretV2Result',
    'AwaitableGetSecretV2Result',
    'get_secret_v2',
    'get_secret_v2_output',
]

@pulumi.output_type
class GetSecretV2Result:
    """
    A collection of values returned by getSecretV2.
    """
    def __init__(__self__, created_time=None, custom_metadata=None, data=None, data_json=None, deletion_time=None, destroyed=None, id=None, mount=None, name=None, namespace=None, path=None, version=None):
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if custom_metadata and not isinstance(custom_metadata, dict):
            raise TypeError("Expected argument 'custom_metadata' to be a dict")
        pulumi.set(__self__, "custom_metadata", custom_metadata)
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if data_json and not isinstance(data_json, str):
            raise TypeError("Expected argument 'data_json' to be a str")
        pulumi.set(__self__, "data_json", data_json)
        if deletion_time and not isinstance(deletion_time, str):
            raise TypeError("Expected argument 'deletion_time' to be a str")
        pulumi.set(__self__, "deletion_time", deletion_time)
        if destroyed and not isinstance(destroyed, bool):
            raise TypeError("Expected argument 'destroyed' to be a bool")
        pulumi.set(__self__, "destroyed", destroyed)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mount and not isinstance(mount, str):
            raise TypeError("Expected argument 'mount' to be a str")
        pulumi.set(__self__, "mount", mount)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Time at which secret was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> Mapping[str, _builtins.str]:
        """
        Custom metadata for the secret.
        """
        return pulumi.get(self, "custom_metadata")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Mapping[str, _builtins.str]:
        """
        A mapping whose keys are the top-level data keys returned from
        Vault and whose values are the corresponding values. This map can only
        represent string data, so any non-string values returned from Vault are
        serialized as JSON.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> _builtins.str:
        """
        JSON-encoded string that that is
        read as the secret data at the given path.
        """
        return pulumi.get(self, "data_json")

    @_builtins.property
    @pulumi.getter(name="deletionTime")
    def deletion_time(self) -> _builtins.str:
        """
        Deletion time for the secret.
        """
        return pulumi.get(self, "deletion_time")

    @_builtins.property
    @pulumi.getter
    def destroyed(self) -> _builtins.bool:
        """
        Indicates whether the secret has been destroyed.
        """
        return pulumi.get(self, "destroyed")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def mount(self) -> _builtins.str:
        return pulumi.get(self, "mount")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Full path where the KVV2 secret is written.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.int]:
        """
        Version of the secret.
        """
        return pulumi.get(self, "version")


class AwaitableGetSecretV2Result(GetSecretV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretV2Result(
            created_time=self.created_time,
            custom_metadata=self.custom_metadata,
            data=self.data,
            data_json=self.data_json,
            deletion_time=self.deletion_time,
            destroyed=self.destroyed,
            id=self.id,
            mount=self.mount,
            name=self.name,
            namespace=self.namespace,
            path=self.path,
            version=self.version)


def get_secret_v2(mount: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  namespace: Optional[_builtins.str] = None,
                  version: Optional[_builtins.int] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretV2Result:
    """
    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_vault as vault

    kvv2 = vault.Mount("kvv2",
        path="kvv2",
        type="kv",
        options={
            "version": "2",
        },
        description="KV Version 2 secret engine mount")
    example_secret_v2 = vault.kv.SecretV2("example",
        mount=kvv2.path,
        name="secret",
        delete_all_versions=True,
        data_json=json.dumps({
            "zip": "zap",
            "foo": "bar",
        }))
    example = vault.kv.get_secret_v2_output(mount=kvv2.path,
        name=example_secret_v2.name)
    ```

    ## Required Vault Capabilities

    Use of this resource requires the `read` capability on the given path.


    :param _builtins.str mount: Path where KV-V2 engine is mounted.
    :param _builtins.str name: Full name of the secret. For a nested secret
           the name is the nested path excluding the mount and data
           prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
           the name is `foo/bar/baz`.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.int version: Version of the secret to retrieve.
    """
    __args__ = dict()
    __args__['mount'] = mount
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:kv/getSecretV2:getSecretV2', __args__, opts=opts, typ=GetSecretV2Result).value

    return AwaitableGetSecretV2Result(
        created_time=pulumi.get(__ret__, 'created_time'),
        custom_metadata=pulumi.get(__ret__, 'custom_metadata'),
        data=pulumi.get(__ret__, 'data'),
        data_json=pulumi.get(__ret__, 'data_json'),
        deletion_time=pulumi.get(__ret__, 'deletion_time'),
        destroyed=pulumi.get(__ret__, 'destroyed'),
        id=pulumi.get(__ret__, 'id'),
        mount=pulumi.get(__ret__, 'mount'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        path=pulumi.get(__ret__, 'path'),
        version=pulumi.get(__ret__, 'version'))
def get_secret_v2_output(mount: Optional[pulumi.Input[_builtins.str]] = None,
                         name: Optional[pulumi.Input[_builtins.str]] = None,
                         namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretV2Result]:
    """
    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_vault as vault

    kvv2 = vault.Mount("kvv2",
        path="kvv2",
        type="kv",
        options={
            "version": "2",
        },
        description="KV Version 2 secret engine mount")
    example_secret_v2 = vault.kv.SecretV2("example",
        mount=kvv2.path,
        name="secret",
        delete_all_versions=True,
        data_json=json.dumps({
            "zip": "zap",
            "foo": "bar",
        }))
    example = vault.kv.get_secret_v2_output(mount=kvv2.path,
        name=example_secret_v2.name)
    ```

    ## Required Vault Capabilities

    Use of this resource requires the `read` capability on the given path.


    :param _builtins.str mount: Path where KV-V2 engine is mounted.
    :param _builtins.str name: Full name of the secret. For a nested secret
           the name is the nested path excluding the mount and data
           prefix. For example, for a secret at `kvv2/data/foo/bar/baz`
           the name is `foo/bar/baz`.
    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.int version: Version of the secret to retrieve.
    """
    __args__ = dict()
    __args__['mount'] = mount
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:kv/getSecretV2:getSecretV2', __args__, opts=opts, typ=GetSecretV2Result)
    return __ret__.apply(lambda __response__: GetSecretV2Result(
        created_time=pulumi.get(__response__, 'created_time'),
        custom_metadata=pulumi.get(__response__, 'custom_metadata'),
        data=pulumi.get(__response__, 'data'),
        data_json=pulumi.get(__response__, 'data_json'),
        deletion_time=pulumi.get(__response__, 'deletion_time'),
        destroyed=pulumi.get(__response__, 'destroyed'),
        id=pulumi.get(__response__, 'id'),
        mount=pulumi.get(__response__, 'mount'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        path=pulumi.get(__response__, 'path'),
        version=pulumi.get(__response__, 'version')))
