# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackendConfigAcmeArgs', 'BackendConfigAcme']

@pulumi.input_type
class BackendConfigAcmeArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 allow_role_ext_key_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_issuers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_directory_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_resolver: Optional[pulumi.Input[_builtins.str]] = None,
                 eab_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackendConfigAcme resource.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether ACME is enabled.
        :param pulumi.Input[_builtins.bool] allow_role_ext_key_usage: Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_issuers: Specifies which issuers are allowed for use with ACME.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_roles: Specifies which roles are allowed for use with ACME.
        :param pulumi.Input[_builtins.str] default_directory_policy: Specifies the policy to be used for non-role-qualified ACME requests.
               Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        :param pulumi.Input[_builtins.str] dns_resolver: DNS resolver to use for domain resolution on this mount.
               Must be in the format `<host>:<port>`, with both parts mandatory.
        :param pulumi.Input[_builtins.str] eab_policy: Specifies the policy to use for external account binding behaviour.
               Allowed values are `not-required`, `new-account-required` or `always-required`.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "enabled", enabled)
        if allow_role_ext_key_usage is not None:
            pulumi.set(__self__, "allow_role_ext_key_usage", allow_role_ext_key_usage)
        if allowed_issuers is not None:
            pulumi.set(__self__, "allowed_issuers", allowed_issuers)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if default_directory_policy is not None:
            pulumi.set(__self__, "default_directory_policy", default_directory_policy)
        if dns_resolver is not None:
            pulumi.set(__self__, "dns_resolver", dns_resolver)
        if eab_policy is not None:
            pulumi.set(__self__, "eab_policy", eab_policy)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether ACME is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="allowRoleExtKeyUsage")
    def allow_role_ext_key_usage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        """
        return pulumi.get(self, "allow_role_ext_key_usage")

    @allow_role_ext_key_usage.setter
    def allow_role_ext_key_usage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_role_ext_key_usage", value)

    @_builtins.property
    @pulumi.getter(name="allowedIssuers")
    def allowed_issuers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which issuers are allowed for use with ACME.
        """
        return pulumi.get(self, "allowed_issuers")

    @allowed_issuers.setter
    def allowed_issuers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_issuers", value)

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which roles are allowed for use with ACME.
        """
        return pulumi.get(self, "allowed_roles")

    @allowed_roles.setter
    def allowed_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_roles", value)

    @_builtins.property
    @pulumi.getter(name="defaultDirectoryPolicy")
    def default_directory_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy to be used for non-role-qualified ACME requests.
        Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        """
        return pulumi.get(self, "default_directory_policy")

    @default_directory_policy.setter
    def default_directory_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_directory_policy", value)

    @_builtins.property
    @pulumi.getter(name="dnsResolver")
    def dns_resolver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS resolver to use for domain resolution on this mount.
        Must be in the format `<host>:<port>`, with both parts mandatory.
        """
        return pulumi.get(self, "dns_resolver")

    @dns_resolver.setter
    def dns_resolver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_resolver", value)

    @_builtins.property
    @pulumi.getter(name="eabPolicy")
    def eab_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy to use for external account binding behaviour.
        Allowed values are `not-required`, `new-account-required` or `always-required`.
        """
        return pulumi.get(self, "eab_policy")

    @eab_policy.setter
    def eab_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eab_policy", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _BackendConfigAcmeState:
    def __init__(__self__, *,
                 allow_role_ext_key_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_issuers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_resolver: Optional[pulumi.Input[_builtins.str]] = None,
                 eab_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackendConfigAcme resources.
        :param pulumi.Input[_builtins.bool] allow_role_ext_key_usage: Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_issuers: Specifies which issuers are allowed for use with ACME.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_roles: Specifies which roles are allowed for use with ACME.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] default_directory_policy: Specifies the policy to be used for non-role-qualified ACME requests.
               Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        :param pulumi.Input[_builtins.str] dns_resolver: DNS resolver to use for domain resolution on this mount.
               Must be in the format `<host>:<port>`, with both parts mandatory.
        :param pulumi.Input[_builtins.str] eab_policy: Specifies the policy to use for external account binding behaviour.
               Allowed values are `not-required`, `new-account-required` or `always-required`.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether ACME is enabled.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        """
        if allow_role_ext_key_usage is not None:
            pulumi.set(__self__, "allow_role_ext_key_usage", allow_role_ext_key_usage)
        if allowed_issuers is not None:
            pulumi.set(__self__, "allowed_issuers", allowed_issuers)
        if allowed_roles is not None:
            pulumi.set(__self__, "allowed_roles", allowed_roles)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if default_directory_policy is not None:
            pulumi.set(__self__, "default_directory_policy", default_directory_policy)
        if dns_resolver is not None:
            pulumi.set(__self__, "dns_resolver", dns_resolver)
        if eab_policy is not None:
            pulumi.set(__self__, "eab_policy", eab_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="allowRoleExtKeyUsage")
    def allow_role_ext_key_usage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        """
        return pulumi.get(self, "allow_role_ext_key_usage")

    @allow_role_ext_key_usage.setter
    def allow_role_ext_key_usage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_role_ext_key_usage", value)

    @_builtins.property
    @pulumi.getter(name="allowedIssuers")
    def allowed_issuers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which issuers are allowed for use with ACME.
        """
        return pulumi.get(self, "allowed_issuers")

    @allowed_issuers.setter
    def allowed_issuers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_issuers", value)

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which roles are allowed for use with ACME.
        """
        return pulumi.get(self, "allowed_roles")

    @allowed_roles.setter
    def allowed_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_roles", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="defaultDirectoryPolicy")
    def default_directory_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy to be used for non-role-qualified ACME requests.
        Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        """
        return pulumi.get(self, "default_directory_policy")

    @default_directory_policy.setter
    def default_directory_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_directory_policy", value)

    @_builtins.property
    @pulumi.getter(name="dnsResolver")
    def dns_resolver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS resolver to use for domain resolution on this mount.
        Must be in the format `<host>:<port>`, with both parts mandatory.
        """
        return pulumi.get(self, "dns_resolver")

    @dns_resolver.setter
    def dns_resolver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_resolver", value)

    @_builtins.property
    @pulumi.getter(name="eabPolicy")
    def eab_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the policy to use for external account binding behaviour.
        Allowed values are `not-required`, `new-account-required` or `always-required`.
        """
        return pulumi.get(self, "eab_policy")

    @eab_policy.setter
    def eab_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eab_policy", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether ACME is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ttl", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)


@pulumi.type_token("vault:pkiSecret/backendConfigAcme:BackendConfigAcme")
class BackendConfigAcme(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_role_ext_key_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_issuers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_resolver: Optional[pulumi.Input[_builtins.str]] = None,
                 eab_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows setting the ACME server configuration used by specified mount.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        pki_config_cluster = vault.pkisecret.BackendConfigCluster("pki_config_cluster",
            backend=pki.path,
            path="http://127.0.0.1:8200/v1/pki",
            aia_path="http://127.0.0.1:8200/v1/pki")
        example = vault.pkisecret.BackendConfigAcme("example",
            backend=pki.path,
            enabled=True,
            allowed_issuers=["*"],
            allowed_roles=["*"],
            allow_role_ext_key_usage=False,
            default_directory_policy="sign-verbatim",
            dns_resolver="",
            eab_policy="not-required")
        ```

        ## Import

        The ACME configuration can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki/config/acme`,
        where the `pki` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigAcme:BackendConfigAcme example pki/config/acme
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_role_ext_key_usage: Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_issuers: Specifies which issuers are allowed for use with ACME.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_roles: Specifies which roles are allowed for use with ACME.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] default_directory_policy: Specifies the policy to be used for non-role-qualified ACME requests.
               Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        :param pulumi.Input[_builtins.str] dns_resolver: DNS resolver to use for domain resolution on this mount.
               Must be in the format `<host>:<port>`, with both parts mandatory.
        :param pulumi.Input[_builtins.str] eab_policy: Specifies the policy to use for external account binding behaviour.
               Allowed values are `not-required`, `new-account-required` or `always-required`.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether ACME is enabled.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendConfigAcmeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the ACME server configuration used by specified mount.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        pki_config_cluster = vault.pkisecret.BackendConfigCluster("pki_config_cluster",
            backend=pki.path,
            path="http://127.0.0.1:8200/v1/pki",
            aia_path="http://127.0.0.1:8200/v1/pki")
        example = vault.pkisecret.BackendConfigAcme("example",
            backend=pki.path,
            enabled=True,
            allowed_issuers=["*"],
            allowed_roles=["*"],
            allow_role_ext_key_usage=False,
            default_directory_policy="sign-verbatim",
            dns_resolver="",
            eab_policy="not-required")
        ```

        ## Import

        The ACME configuration can be imported using the resource's `id`.
        In the case of the example above the `id` would be `pki/config/acme`,
        where the `pki` component is the resource's `backend`, e.g.

        ```sh
        $ pulumi import vault:pkiSecret/backendConfigAcme:BackendConfigAcme example pki/config/acme
        ```

        :param str resource_name: The name of the resource.
        :param BackendConfigAcmeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendConfigAcmeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_role_ext_key_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_issuers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 default_directory_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_resolver: Optional[pulumi.Input[_builtins.str]] = None,
                 eab_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendConfigAcmeArgs.__new__(BackendConfigAcmeArgs)

            __props__.__dict__["allow_role_ext_key_usage"] = allow_role_ext_key_usage
            __props__.__dict__["allowed_issuers"] = allowed_issuers
            __props__.__dict__["allowed_roles"] = allowed_roles
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["default_directory_policy"] = default_directory_policy
            __props__.__dict__["dns_resolver"] = dns_resolver
            __props__.__dict__["eab_policy"] = eab_policy
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["namespace"] = namespace
        super(BackendConfigAcme, __self__).__init__(
            'vault:pkiSecret/backendConfigAcme:BackendConfigAcme',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_role_ext_key_usage: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_issuers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            default_directory_policy: Optional[pulumi.Input[_builtins.str]] = None,
            dns_resolver: Optional[pulumi.Input[_builtins.str]] = None,
            eab_policy: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            max_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackendConfigAcme':
        """
        Get an existing BackendConfigAcme resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_role_ext_key_usage: Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_issuers: Specifies which issuers are allowed for use with ACME.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_roles: Specifies which roles are allowed for use with ACME.
        :param pulumi.Input[_builtins.str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.str] default_directory_policy: Specifies the policy to be used for non-role-qualified ACME requests.
               Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        :param pulumi.Input[_builtins.str] dns_resolver: DNS resolver to use for domain resolution on this mount.
               Must be in the format `<host>:<port>`, with both parts mandatory.
        :param pulumi.Input[_builtins.str] eab_policy: Specifies the policy to use for external account binding behaviour.
               Allowed values are `not-required`, `new-account-required` or `always-required`.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether ACME is enabled.
        :param pulumi.Input[_builtins.int] max_ttl: The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendConfigAcmeState.__new__(_BackendConfigAcmeState)

        __props__.__dict__["allow_role_ext_key_usage"] = allow_role_ext_key_usage
        __props__.__dict__["allowed_issuers"] = allowed_issuers
        __props__.__dict__["allowed_roles"] = allowed_roles
        __props__.__dict__["backend"] = backend
        __props__.__dict__["default_directory_policy"] = default_directory_policy
        __props__.__dict__["dns_resolver"] = dns_resolver
        __props__.__dict__["eab_policy"] = eab_policy
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["namespace"] = namespace
        return BackendConfigAcme(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowRoleExtKeyUsage")
    def allow_role_ext_key_usage(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the ExtKeyUsage field from a role is used. **Vault 1.14.1+**
        """
        return pulumi.get(self, "allow_role_ext_key_usage")

    @_builtins.property
    @pulumi.getter(name="allowedIssuers")
    def allowed_issuers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies which issuers are allowed for use with ACME.
        """
        return pulumi.get(self, "allowed_issuers")

    @_builtins.property
    @pulumi.getter(name="allowedRoles")
    def allowed_roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies which roles are allowed for use with ACME.
        """
        return pulumi.get(self, "allowed_roles")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="defaultDirectoryPolicy")
    def default_directory_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the policy to be used for non-role-qualified ACME requests.
        Allowed values are `forbid`, `sign-verbatim`, `role:<role_name>`, `external-policy` or `external-policy:<policy>`.
        """
        return pulumi.get(self, "default_directory_policy")

    @_builtins.property
    @pulumi.getter(name="dnsResolver")
    def dns_resolver(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        DNS resolver to use for domain resolution on this mount.
        Must be in the format `<host>:<port>`, with both parts mandatory.
        """
        return pulumi.get(self, "dns_resolver")

    @_builtins.property
    @pulumi.getter(name="eabPolicy")
    def eab_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the policy to use for external account binding behaviour.
        Allowed values are `not-required`, `new-account-required` or `always-required`.
        """
        return pulumi.get(self, "eab_policy")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether ACME is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum TTL in seconds for certificates issued by ACME. **Vault 1.17.0+**
        """
        return pulumi.get(self, "max_ttl")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

