# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackendConfigAutoTidyArgs', 'BackendConfigAutoTidy']

@pulumi.input_type
class BackendConfigAutoTidyArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 acme_account_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 interval_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_stored_certificate_counts: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_stored_certificate_count_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 revocation_queue_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 tidy_acme: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cmpv2_nonce_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cross_cluster_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_expired_issuers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_move_legacy_ca_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revocation_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_cert_issuer_associations: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a BackendConfigAutoTidy resource.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether automatic tidy is enabled or not.
        :param pulumi.Input[_builtins.str] acme_account_safety_buffer: The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        :param pulumi.Input[_builtins.str] interval_duration: Interval at which to run an auto-tidy operation. This is the time
               between tidy invocations (after one finishes to the start of the next).
        :param pulumi.Input[_builtins.str] issuer_safety_buffer: The amount of extra time that must have passed beyond issuer's
               expiration before it is removed from the backend storage.
        :param pulumi.Input[_builtins.bool] maintain_stored_certificate_counts: This configures whether stored certificate are
               counted upon initialization of the backend, and whether during normal operation, a running count
               of certificates stored is maintained.
        :param pulumi.Input[_builtins.str] max_startup_backoff_duration: The maximum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] min_startup_backoff_duration: The minimum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] pause_duration: The amount of time to wait between processing certificates.
        :param pulumi.Input[_builtins.bool] publish_stored_certificate_count_metrics: This configures whether the stored
               certificate count is published to the metrics consumer.
        :param pulumi.Input[_builtins.str] revocation_queue_safety_buffer: The amount of time that must pass from the
               cross-cluster revocation request being initiated to when it will be slated for removal.
        :param pulumi.Input[_builtins.str] safety_buffer: The amount of extra time that must have passed beyond certificate
               expiration before it is removed from the backend storage and/or revocation list.
        :param pulumi.Input[_builtins.bool] tidy_acme: Set to true to enable tidying ACME accounts, orders and authorizations.
        :param pulumi.Input[_builtins.bool] tidy_cert_metadata: Set to true to enable tidying up certificate metadata.
        :param pulumi.Input[_builtins.bool] tidy_cert_store: Set to true to enable tidying up the certificate store
        :param pulumi.Input[_builtins.bool] tidy_cmpv2_nonce_store: Set to true to enable tidying up the CMPv2 nonce store.
        :param pulumi.Input[_builtins.bool] tidy_cross_cluster_revoked_certs: Set to true to enable tidying up the cross-cluster
               revoked certificate store.
        :param pulumi.Input[_builtins.bool] tidy_expired_issuers: Set to true to automatically remove expired issuers past the
               `issuer_safety_buffer`. No keys will be removed as part of this operation.
        :param pulumi.Input[_builtins.bool] tidy_move_legacy_ca_bundle: Set to true to move the legacy `ca_bundle` from
               `/config/ca_bundle` to `/config/ca_bundle.bak`.
        :param pulumi.Input[_builtins.bool] tidy_revocation_queue: Set to true to remove stale revocation queue entries that
               haven't been confirmed by any active cluster.
        :param pulumi.Input[_builtins.bool] tidy_revoked_cert_issuer_associations: Set to true to validate issuer associations
               on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        :param pulumi.Input[_builtins.bool] tidy_revoked_certs: Set to true to remove all invalid and expired certificates from
               storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
               the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
               the CRL, and the CRL will be rotated.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "enabled", enabled)
        if acme_account_safety_buffer is not None:
            pulumi.set(__self__, "acme_account_safety_buffer", acme_account_safety_buffer)
        if interval_duration is not None:
            pulumi.set(__self__, "interval_duration", interval_duration)
        if issuer_safety_buffer is not None:
            pulumi.set(__self__, "issuer_safety_buffer", issuer_safety_buffer)
        if maintain_stored_certificate_counts is not None:
            pulumi.set(__self__, "maintain_stored_certificate_counts", maintain_stored_certificate_counts)
        if max_startup_backoff_duration is not None:
            pulumi.set(__self__, "max_startup_backoff_duration", max_startup_backoff_duration)
        if min_startup_backoff_duration is not None:
            pulumi.set(__self__, "min_startup_backoff_duration", min_startup_backoff_duration)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if pause_duration is not None:
            pulumi.set(__self__, "pause_duration", pause_duration)
        if publish_stored_certificate_count_metrics is not None:
            pulumi.set(__self__, "publish_stored_certificate_count_metrics", publish_stored_certificate_count_metrics)
        if revocation_queue_safety_buffer is not None:
            pulumi.set(__self__, "revocation_queue_safety_buffer", revocation_queue_safety_buffer)
        if safety_buffer is not None:
            pulumi.set(__self__, "safety_buffer", safety_buffer)
        if tidy_acme is not None:
            pulumi.set(__self__, "tidy_acme", tidy_acme)
        if tidy_cert_metadata is not None:
            pulumi.set(__self__, "tidy_cert_metadata", tidy_cert_metadata)
        if tidy_cert_store is not None:
            pulumi.set(__self__, "tidy_cert_store", tidy_cert_store)
        if tidy_cmpv2_nonce_store is not None:
            pulumi.set(__self__, "tidy_cmpv2_nonce_store", tidy_cmpv2_nonce_store)
        if tidy_cross_cluster_revoked_certs is not None:
            pulumi.set(__self__, "tidy_cross_cluster_revoked_certs", tidy_cross_cluster_revoked_certs)
        if tidy_expired_issuers is not None:
            pulumi.set(__self__, "tidy_expired_issuers", tidy_expired_issuers)
        if tidy_move_legacy_ca_bundle is not None:
            pulumi.set(__self__, "tidy_move_legacy_ca_bundle", tidy_move_legacy_ca_bundle)
        if tidy_revocation_queue is not None:
            pulumi.set(__self__, "tidy_revocation_queue", tidy_revocation_queue)
        if tidy_revoked_cert_issuer_associations is not None:
            pulumi.set(__self__, "tidy_revoked_cert_issuer_associations", tidy_revoked_cert_issuer_associations)
        if tidy_revoked_certs is not None:
            pulumi.set(__self__, "tidy_revoked_certs", tidy_revoked_certs)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The path to the PKI secret backend to
        read the configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether automatic tidy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="acmeAccountSafetyBuffer")
    def acme_account_safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        """
        return pulumi.get(self, "acme_account_safety_buffer")

    @acme_account_safety_buffer.setter
    def acme_account_safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acme_account_safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="intervalDuration")
    def interval_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interval at which to run an auto-tidy operation. This is the time
        between tidy invocations (after one finishes to the start of the next).
        """
        return pulumi.get(self, "interval_duration")

    @interval_duration.setter
    def interval_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval_duration", value)

    @_builtins.property
    @pulumi.getter(name="issuerSafetyBuffer")
    def issuer_safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of extra time that must have passed beyond issuer's
        expiration before it is removed from the backend storage.
        """
        return pulumi.get(self, "issuer_safety_buffer")

    @issuer_safety_buffer.setter
    def issuer_safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="maintainStoredCertificateCounts")
    def maintain_stored_certificate_counts(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This configures whether stored certificate are
        counted upon initialization of the backend, and whether during normal operation, a running count
        of certificates stored is maintained.
        """
        return pulumi.get(self, "maintain_stored_certificate_counts")

    @maintain_stored_certificate_counts.setter
    def maintain_stored_certificate_counts(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "maintain_stored_certificate_counts", value)

    @_builtins.property
    @pulumi.getter(name="maxStartupBackoffDuration")
    def max_startup_backoff_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum amount of time auto-tidy will be delayed
        after startup.
        """
        return pulumi.get(self, "max_startup_backoff_duration")

    @max_startup_backoff_duration.setter
    def max_startup_backoff_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_startup_backoff_duration", value)

    @_builtins.property
    @pulumi.getter(name="minStartupBackoffDuration")
    def min_startup_backoff_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum amount of time auto-tidy will be delayed
        after startup.
        """
        return pulumi.get(self, "min_startup_backoff_duration")

    @min_startup_backoff_duration.setter
    def min_startup_backoff_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_startup_backoff_duration", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="pauseDuration")
    def pause_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time to wait between processing certificates.
        """
        return pulumi.get(self, "pause_duration")

    @pause_duration.setter
    def pause_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pause_duration", value)

    @_builtins.property
    @pulumi.getter(name="publishStoredCertificateCountMetrics")
    def publish_stored_certificate_count_metrics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This configures whether the stored
        certificate count is published to the metrics consumer.
        """
        return pulumi.get(self, "publish_stored_certificate_count_metrics")

    @publish_stored_certificate_count_metrics.setter
    def publish_stored_certificate_count_metrics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "publish_stored_certificate_count_metrics", value)

    @_builtins.property
    @pulumi.getter(name="revocationQueueSafetyBuffer")
    def revocation_queue_safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that must pass from the
        cross-cluster revocation request being initiated to when it will be slated for removal.
        """
        return pulumi.get(self, "revocation_queue_safety_buffer")

    @revocation_queue_safety_buffer.setter
    def revocation_queue_safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revocation_queue_safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="safetyBuffer")
    def safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of extra time that must have passed beyond certificate
        expiration before it is removed from the backend storage and/or revocation list.
        """
        return pulumi.get(self, "safety_buffer")

    @safety_buffer.setter
    def safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="tidyAcme")
    def tidy_acme(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying ACME accounts, orders and authorizations.
        """
        return pulumi.get(self, "tidy_acme")

    @tidy_acme.setter
    def tidy_acme(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_acme", value)

    @_builtins.property
    @pulumi.getter(name="tidyCertMetadata")
    def tidy_cert_metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up certificate metadata.
        """
        return pulumi.get(self, "tidy_cert_metadata")

    @tidy_cert_metadata.setter
    def tidy_cert_metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cert_metadata", value)

    @_builtins.property
    @pulumi.getter(name="tidyCertStore")
    def tidy_cert_store(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up the certificate store
        """
        return pulumi.get(self, "tidy_cert_store")

    @tidy_cert_store.setter
    def tidy_cert_store(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cert_store", value)

    @_builtins.property
    @pulumi.getter(name="tidyCmpv2NonceStore")
    def tidy_cmpv2_nonce_store(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up the CMPv2 nonce store.
        """
        return pulumi.get(self, "tidy_cmpv2_nonce_store")

    @tidy_cmpv2_nonce_store.setter
    def tidy_cmpv2_nonce_store(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cmpv2_nonce_store", value)

    @_builtins.property
    @pulumi.getter(name="tidyCrossClusterRevokedCerts")
    def tidy_cross_cluster_revoked_certs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up the cross-cluster
        revoked certificate store.
        """
        return pulumi.get(self, "tidy_cross_cluster_revoked_certs")

    @tidy_cross_cluster_revoked_certs.setter
    def tidy_cross_cluster_revoked_certs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cross_cluster_revoked_certs", value)

    @_builtins.property
    @pulumi.getter(name="tidyExpiredIssuers")
    def tidy_expired_issuers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to automatically remove expired issuers past the
        `issuer_safety_buffer`. No keys will be removed as part of this operation.
        """
        return pulumi.get(self, "tidy_expired_issuers")

    @tidy_expired_issuers.setter
    def tidy_expired_issuers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_expired_issuers", value)

    @_builtins.property
    @pulumi.getter(name="tidyMoveLegacyCaBundle")
    def tidy_move_legacy_ca_bundle(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to move the legacy `ca_bundle` from
        `/config/ca_bundle` to `/config/ca_bundle.bak`.
        """
        return pulumi.get(self, "tidy_move_legacy_ca_bundle")

    @tidy_move_legacy_ca_bundle.setter
    def tidy_move_legacy_ca_bundle(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_move_legacy_ca_bundle", value)

    @_builtins.property
    @pulumi.getter(name="tidyRevocationQueue")
    def tidy_revocation_queue(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to remove stale revocation queue entries that
        haven't been confirmed by any active cluster.
        """
        return pulumi.get(self, "tidy_revocation_queue")

    @tidy_revocation_queue.setter
    def tidy_revocation_queue(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_revocation_queue", value)

    @_builtins.property
    @pulumi.getter(name="tidyRevokedCertIssuerAssociations")
    def tidy_revoked_cert_issuer_associations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to validate issuer associations
        on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        """
        return pulumi.get(self, "tidy_revoked_cert_issuer_associations")

    @tidy_revoked_cert_issuer_associations.setter
    def tidy_revoked_cert_issuer_associations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_revoked_cert_issuer_associations", value)

    @_builtins.property
    @pulumi.getter(name="tidyRevokedCerts")
    def tidy_revoked_certs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to remove all invalid and expired certificates from
        storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
        the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
        the CRL, and the CRL will be rotated.
        """
        return pulumi.get(self, "tidy_revoked_certs")

    @tidy_revoked_certs.setter
    def tidy_revoked_certs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_revoked_certs", value)


@pulumi.input_type
class _BackendConfigAutoTidyState:
    def __init__(__self__, *,
                 acme_account_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_stored_certificate_counts: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_stored_certificate_count_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 revocation_queue_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 tidy_acme: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cmpv2_nonce_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cross_cluster_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_expired_issuers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_move_legacy_ca_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revocation_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_cert_issuer_associations: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering BackendConfigAutoTidy resources.
        :param pulumi.Input[_builtins.str] acme_account_safety_buffer: The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether automatic tidy is enabled or not.
        :param pulumi.Input[_builtins.str] interval_duration: Interval at which to run an auto-tidy operation. This is the time
               between tidy invocations (after one finishes to the start of the next).
        :param pulumi.Input[_builtins.str] issuer_safety_buffer: The amount of extra time that must have passed beyond issuer's
               expiration before it is removed from the backend storage.
        :param pulumi.Input[_builtins.bool] maintain_stored_certificate_counts: This configures whether stored certificate are
               counted upon initialization of the backend, and whether during normal operation, a running count
               of certificates stored is maintained.
        :param pulumi.Input[_builtins.str] max_startup_backoff_duration: The maximum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] min_startup_backoff_duration: The minimum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] pause_duration: The amount of time to wait between processing certificates.
        :param pulumi.Input[_builtins.bool] publish_stored_certificate_count_metrics: This configures whether the stored
               certificate count is published to the metrics consumer.
        :param pulumi.Input[_builtins.str] revocation_queue_safety_buffer: The amount of time that must pass from the
               cross-cluster revocation request being initiated to when it will be slated for removal.
        :param pulumi.Input[_builtins.str] safety_buffer: The amount of extra time that must have passed beyond certificate
               expiration before it is removed from the backend storage and/or revocation list.
        :param pulumi.Input[_builtins.bool] tidy_acme: Set to true to enable tidying ACME accounts, orders and authorizations.
        :param pulumi.Input[_builtins.bool] tidy_cert_metadata: Set to true to enable tidying up certificate metadata.
        :param pulumi.Input[_builtins.bool] tidy_cert_store: Set to true to enable tidying up the certificate store
        :param pulumi.Input[_builtins.bool] tidy_cmpv2_nonce_store: Set to true to enable tidying up the CMPv2 nonce store.
        :param pulumi.Input[_builtins.bool] tidy_cross_cluster_revoked_certs: Set to true to enable tidying up the cross-cluster
               revoked certificate store.
        :param pulumi.Input[_builtins.bool] tidy_expired_issuers: Set to true to automatically remove expired issuers past the
               `issuer_safety_buffer`. No keys will be removed as part of this operation.
        :param pulumi.Input[_builtins.bool] tidy_move_legacy_ca_bundle: Set to true to move the legacy `ca_bundle` from
               `/config/ca_bundle` to `/config/ca_bundle.bak`.
        :param pulumi.Input[_builtins.bool] tidy_revocation_queue: Set to true to remove stale revocation queue entries that
               haven't been confirmed by any active cluster.
        :param pulumi.Input[_builtins.bool] tidy_revoked_cert_issuer_associations: Set to true to validate issuer associations
               on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        :param pulumi.Input[_builtins.bool] tidy_revoked_certs: Set to true to remove all invalid and expired certificates from
               storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
               the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
               the CRL, and the CRL will be rotated.
        """
        if acme_account_safety_buffer is not None:
            pulumi.set(__self__, "acme_account_safety_buffer", acme_account_safety_buffer)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interval_duration is not None:
            pulumi.set(__self__, "interval_duration", interval_duration)
        if issuer_safety_buffer is not None:
            pulumi.set(__self__, "issuer_safety_buffer", issuer_safety_buffer)
        if maintain_stored_certificate_counts is not None:
            pulumi.set(__self__, "maintain_stored_certificate_counts", maintain_stored_certificate_counts)
        if max_startup_backoff_duration is not None:
            pulumi.set(__self__, "max_startup_backoff_duration", max_startup_backoff_duration)
        if min_startup_backoff_duration is not None:
            pulumi.set(__self__, "min_startup_backoff_duration", min_startup_backoff_duration)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if pause_duration is not None:
            pulumi.set(__self__, "pause_duration", pause_duration)
        if publish_stored_certificate_count_metrics is not None:
            pulumi.set(__self__, "publish_stored_certificate_count_metrics", publish_stored_certificate_count_metrics)
        if revocation_queue_safety_buffer is not None:
            pulumi.set(__self__, "revocation_queue_safety_buffer", revocation_queue_safety_buffer)
        if safety_buffer is not None:
            pulumi.set(__self__, "safety_buffer", safety_buffer)
        if tidy_acme is not None:
            pulumi.set(__self__, "tidy_acme", tidy_acme)
        if tidy_cert_metadata is not None:
            pulumi.set(__self__, "tidy_cert_metadata", tidy_cert_metadata)
        if tidy_cert_store is not None:
            pulumi.set(__self__, "tidy_cert_store", tidy_cert_store)
        if tidy_cmpv2_nonce_store is not None:
            pulumi.set(__self__, "tidy_cmpv2_nonce_store", tidy_cmpv2_nonce_store)
        if tidy_cross_cluster_revoked_certs is not None:
            pulumi.set(__self__, "tidy_cross_cluster_revoked_certs", tidy_cross_cluster_revoked_certs)
        if tidy_expired_issuers is not None:
            pulumi.set(__self__, "tidy_expired_issuers", tidy_expired_issuers)
        if tidy_move_legacy_ca_bundle is not None:
            pulumi.set(__self__, "tidy_move_legacy_ca_bundle", tidy_move_legacy_ca_bundle)
        if tidy_revocation_queue is not None:
            pulumi.set(__self__, "tidy_revocation_queue", tidy_revocation_queue)
        if tidy_revoked_cert_issuer_associations is not None:
            pulumi.set(__self__, "tidy_revoked_cert_issuer_associations", tidy_revoked_cert_issuer_associations)
        if tidy_revoked_certs is not None:
            pulumi.set(__self__, "tidy_revoked_certs", tidy_revoked_certs)

    @_builtins.property
    @pulumi.getter(name="acmeAccountSafetyBuffer")
    def acme_account_safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        """
        return pulumi.get(self, "acme_account_safety_buffer")

    @acme_account_safety_buffer.setter
    def acme_account_safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acme_account_safety_buffer", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the PKI secret backend to
        read the configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether automatic tidy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="intervalDuration")
    def interval_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interval at which to run an auto-tidy operation. This is the time
        between tidy invocations (after one finishes to the start of the next).
        """
        return pulumi.get(self, "interval_duration")

    @interval_duration.setter
    def interval_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval_duration", value)

    @_builtins.property
    @pulumi.getter(name="issuerSafetyBuffer")
    def issuer_safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of extra time that must have passed beyond issuer's
        expiration before it is removed from the backend storage.
        """
        return pulumi.get(self, "issuer_safety_buffer")

    @issuer_safety_buffer.setter
    def issuer_safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="maintainStoredCertificateCounts")
    def maintain_stored_certificate_counts(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This configures whether stored certificate are
        counted upon initialization of the backend, and whether during normal operation, a running count
        of certificates stored is maintained.
        """
        return pulumi.get(self, "maintain_stored_certificate_counts")

    @maintain_stored_certificate_counts.setter
    def maintain_stored_certificate_counts(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "maintain_stored_certificate_counts", value)

    @_builtins.property
    @pulumi.getter(name="maxStartupBackoffDuration")
    def max_startup_backoff_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum amount of time auto-tidy will be delayed
        after startup.
        """
        return pulumi.get(self, "max_startup_backoff_duration")

    @max_startup_backoff_duration.setter
    def max_startup_backoff_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_startup_backoff_duration", value)

    @_builtins.property
    @pulumi.getter(name="minStartupBackoffDuration")
    def min_startup_backoff_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum amount of time auto-tidy will be delayed
        after startup.
        """
        return pulumi.get(self, "min_startup_backoff_duration")

    @min_startup_backoff_duration.setter
    def min_startup_backoff_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_startup_backoff_duration", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="pauseDuration")
    def pause_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time to wait between processing certificates.
        """
        return pulumi.get(self, "pause_duration")

    @pause_duration.setter
    def pause_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pause_duration", value)

    @_builtins.property
    @pulumi.getter(name="publishStoredCertificateCountMetrics")
    def publish_stored_certificate_count_metrics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This configures whether the stored
        certificate count is published to the metrics consumer.
        """
        return pulumi.get(self, "publish_stored_certificate_count_metrics")

    @publish_stored_certificate_count_metrics.setter
    def publish_stored_certificate_count_metrics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "publish_stored_certificate_count_metrics", value)

    @_builtins.property
    @pulumi.getter(name="revocationQueueSafetyBuffer")
    def revocation_queue_safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of time that must pass from the
        cross-cluster revocation request being initiated to when it will be slated for removal.
        """
        return pulumi.get(self, "revocation_queue_safety_buffer")

    @revocation_queue_safety_buffer.setter
    def revocation_queue_safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revocation_queue_safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="safetyBuffer")
    def safety_buffer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The amount of extra time that must have passed beyond certificate
        expiration before it is removed from the backend storage and/or revocation list.
        """
        return pulumi.get(self, "safety_buffer")

    @safety_buffer.setter
    def safety_buffer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "safety_buffer", value)

    @_builtins.property
    @pulumi.getter(name="tidyAcme")
    def tidy_acme(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying ACME accounts, orders and authorizations.
        """
        return pulumi.get(self, "tidy_acme")

    @tidy_acme.setter
    def tidy_acme(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_acme", value)

    @_builtins.property
    @pulumi.getter(name="tidyCertMetadata")
    def tidy_cert_metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up certificate metadata.
        """
        return pulumi.get(self, "tidy_cert_metadata")

    @tidy_cert_metadata.setter
    def tidy_cert_metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cert_metadata", value)

    @_builtins.property
    @pulumi.getter(name="tidyCertStore")
    def tidy_cert_store(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up the certificate store
        """
        return pulumi.get(self, "tidy_cert_store")

    @tidy_cert_store.setter
    def tidy_cert_store(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cert_store", value)

    @_builtins.property
    @pulumi.getter(name="tidyCmpv2NonceStore")
    def tidy_cmpv2_nonce_store(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up the CMPv2 nonce store.
        """
        return pulumi.get(self, "tidy_cmpv2_nonce_store")

    @tidy_cmpv2_nonce_store.setter
    def tidy_cmpv2_nonce_store(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cmpv2_nonce_store", value)

    @_builtins.property
    @pulumi.getter(name="tidyCrossClusterRevokedCerts")
    def tidy_cross_cluster_revoked_certs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to enable tidying up the cross-cluster
        revoked certificate store.
        """
        return pulumi.get(self, "tidy_cross_cluster_revoked_certs")

    @tidy_cross_cluster_revoked_certs.setter
    def tidy_cross_cluster_revoked_certs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_cross_cluster_revoked_certs", value)

    @_builtins.property
    @pulumi.getter(name="tidyExpiredIssuers")
    def tidy_expired_issuers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to automatically remove expired issuers past the
        `issuer_safety_buffer`. No keys will be removed as part of this operation.
        """
        return pulumi.get(self, "tidy_expired_issuers")

    @tidy_expired_issuers.setter
    def tidy_expired_issuers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_expired_issuers", value)

    @_builtins.property
    @pulumi.getter(name="tidyMoveLegacyCaBundle")
    def tidy_move_legacy_ca_bundle(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to move the legacy `ca_bundle` from
        `/config/ca_bundle` to `/config/ca_bundle.bak`.
        """
        return pulumi.get(self, "tidy_move_legacy_ca_bundle")

    @tidy_move_legacy_ca_bundle.setter
    def tidy_move_legacy_ca_bundle(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_move_legacy_ca_bundle", value)

    @_builtins.property
    @pulumi.getter(name="tidyRevocationQueue")
    def tidy_revocation_queue(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to remove stale revocation queue entries that
        haven't been confirmed by any active cluster.
        """
        return pulumi.get(self, "tidy_revocation_queue")

    @tidy_revocation_queue.setter
    def tidy_revocation_queue(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_revocation_queue", value)

    @_builtins.property
    @pulumi.getter(name="tidyRevokedCertIssuerAssociations")
    def tidy_revoked_cert_issuer_associations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to validate issuer associations
        on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        """
        return pulumi.get(self, "tidy_revoked_cert_issuer_associations")

    @tidy_revoked_cert_issuer_associations.setter
    def tidy_revoked_cert_issuer_associations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_revoked_cert_issuer_associations", value)

    @_builtins.property
    @pulumi.getter(name="tidyRevokedCerts")
    def tidy_revoked_certs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to remove all invalid and expired certificates from
        storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
        the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
        the CRL, and the CRL will be rotated.
        """
        return pulumi.get(self, "tidy_revoked_certs")

    @tidy_revoked_certs.setter
    def tidy_revoked_certs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tidy_revoked_certs", value)


@pulumi.type_token("vault:pkiSecret/backendConfigAutoTidy:BackendConfigAutoTidy")
class BackendConfigAutoTidy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acme_account_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_stored_certificate_counts: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_stored_certificate_count_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 revocation_queue_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 tidy_acme: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cmpv2_nonce_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cross_cluster_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_expired_issuers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_move_legacy_ca_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revocation_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_cert_issuer_associations: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Allows setting the Auto Tidy configuration on a PKI Secret Backend

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        test = vault.pkisecret.BackendConfigAutoTidy("test",
            backend=pki.path,
            enabled=True,
            tidy_cert_store=True,
            interval_duration="1h")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acme_account_safety_buffer: The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether automatic tidy is enabled or not.
        :param pulumi.Input[_builtins.str] interval_duration: Interval at which to run an auto-tidy operation. This is the time
               between tidy invocations (after one finishes to the start of the next).
        :param pulumi.Input[_builtins.str] issuer_safety_buffer: The amount of extra time that must have passed beyond issuer's
               expiration before it is removed from the backend storage.
        :param pulumi.Input[_builtins.bool] maintain_stored_certificate_counts: This configures whether stored certificate are
               counted upon initialization of the backend, and whether during normal operation, a running count
               of certificates stored is maintained.
        :param pulumi.Input[_builtins.str] max_startup_backoff_duration: The maximum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] min_startup_backoff_duration: The minimum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] pause_duration: The amount of time to wait between processing certificates.
        :param pulumi.Input[_builtins.bool] publish_stored_certificate_count_metrics: This configures whether the stored
               certificate count is published to the metrics consumer.
        :param pulumi.Input[_builtins.str] revocation_queue_safety_buffer: The amount of time that must pass from the
               cross-cluster revocation request being initiated to when it will be slated for removal.
        :param pulumi.Input[_builtins.str] safety_buffer: The amount of extra time that must have passed beyond certificate
               expiration before it is removed from the backend storage and/or revocation list.
        :param pulumi.Input[_builtins.bool] tidy_acme: Set to true to enable tidying ACME accounts, orders and authorizations.
        :param pulumi.Input[_builtins.bool] tidy_cert_metadata: Set to true to enable tidying up certificate metadata.
        :param pulumi.Input[_builtins.bool] tidy_cert_store: Set to true to enable tidying up the certificate store
        :param pulumi.Input[_builtins.bool] tidy_cmpv2_nonce_store: Set to true to enable tidying up the CMPv2 nonce store.
        :param pulumi.Input[_builtins.bool] tidy_cross_cluster_revoked_certs: Set to true to enable tidying up the cross-cluster
               revoked certificate store.
        :param pulumi.Input[_builtins.bool] tidy_expired_issuers: Set to true to automatically remove expired issuers past the
               `issuer_safety_buffer`. No keys will be removed as part of this operation.
        :param pulumi.Input[_builtins.bool] tidy_move_legacy_ca_bundle: Set to true to move the legacy `ca_bundle` from
               `/config/ca_bundle` to `/config/ca_bundle.bak`.
        :param pulumi.Input[_builtins.bool] tidy_revocation_queue: Set to true to remove stale revocation queue entries that
               haven't been confirmed by any active cluster.
        :param pulumi.Input[_builtins.bool] tidy_revoked_cert_issuer_associations: Set to true to validate issuer associations
               on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        :param pulumi.Input[_builtins.bool] tidy_revoked_certs: Set to true to remove all invalid and expired certificates from
               storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
               the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
               the CRL, and the CRL will be rotated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendConfigAutoTidyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the Auto Tidy configuration on a PKI Secret Backend

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            path="pki",
            type="pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400)
        test = vault.pkisecret.BackendConfigAutoTidy("test",
            backend=pki.path,
            enabled=True,
            tidy_cert_store=True,
            interval_duration="1h")
        ```

        :param str resource_name: The name of the resource.
        :param BackendConfigAutoTidyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendConfigAutoTidyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acme_account_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 interval_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_stored_certificate_counts: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 pause_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_stored_certificate_count_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 revocation_queue_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
                 tidy_acme: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cert_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cmpv2_nonce_store: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_cross_cluster_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_expired_issuers: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_move_legacy_ca_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revocation_queue: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_cert_issuer_associations: Optional[pulumi.Input[_builtins.bool]] = None,
                 tidy_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendConfigAutoTidyArgs.__new__(BackendConfigAutoTidyArgs)

            __props__.__dict__["acme_account_safety_buffer"] = acme_account_safety_buffer
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["interval_duration"] = interval_duration
            __props__.__dict__["issuer_safety_buffer"] = issuer_safety_buffer
            __props__.__dict__["maintain_stored_certificate_counts"] = maintain_stored_certificate_counts
            __props__.__dict__["max_startup_backoff_duration"] = max_startup_backoff_duration
            __props__.__dict__["min_startup_backoff_duration"] = min_startup_backoff_duration
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["pause_duration"] = pause_duration
            __props__.__dict__["publish_stored_certificate_count_metrics"] = publish_stored_certificate_count_metrics
            __props__.__dict__["revocation_queue_safety_buffer"] = revocation_queue_safety_buffer
            __props__.__dict__["safety_buffer"] = safety_buffer
            __props__.__dict__["tidy_acme"] = tidy_acme
            __props__.__dict__["tidy_cert_metadata"] = tidy_cert_metadata
            __props__.__dict__["tidy_cert_store"] = tidy_cert_store
            __props__.__dict__["tidy_cmpv2_nonce_store"] = tidy_cmpv2_nonce_store
            __props__.__dict__["tidy_cross_cluster_revoked_certs"] = tidy_cross_cluster_revoked_certs
            __props__.__dict__["tidy_expired_issuers"] = tidy_expired_issuers
            __props__.__dict__["tidy_move_legacy_ca_bundle"] = tidy_move_legacy_ca_bundle
            __props__.__dict__["tidy_revocation_queue"] = tidy_revocation_queue
            __props__.__dict__["tidy_revoked_cert_issuer_associations"] = tidy_revoked_cert_issuer_associations
            __props__.__dict__["tidy_revoked_certs"] = tidy_revoked_certs
        super(BackendConfigAutoTidy, __self__).__init__(
            'vault:pkiSecret/backendConfigAutoTidy:BackendConfigAutoTidy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acme_account_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            interval_duration: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_stored_certificate_counts: Optional[pulumi.Input[_builtins.bool]] = None,
            max_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
            min_startup_backoff_duration: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            pause_duration: Optional[pulumi.Input[_builtins.str]] = None,
            publish_stored_certificate_count_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
            revocation_queue_safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
            safety_buffer: Optional[pulumi.Input[_builtins.str]] = None,
            tidy_acme: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_cert_metadata: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_cert_store: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_cmpv2_nonce_store: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_cross_cluster_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_expired_issuers: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_move_legacy_ca_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_revocation_queue: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_revoked_cert_issuer_associations: Optional[pulumi.Input[_builtins.bool]] = None,
            tidy_revoked_certs: Optional[pulumi.Input[_builtins.bool]] = None) -> 'BackendConfigAutoTidy':
        """
        Get an existing BackendConfigAutoTidy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acme_account_safety_buffer: The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        :param pulumi.Input[_builtins.str] backend: The path to the PKI secret backend to
               read the configuration from, with no leading or trailing `/`s.
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether automatic tidy is enabled or not.
        :param pulumi.Input[_builtins.str] interval_duration: Interval at which to run an auto-tidy operation. This is the time
               between tidy invocations (after one finishes to the start of the next).
        :param pulumi.Input[_builtins.str] issuer_safety_buffer: The amount of extra time that must have passed beyond issuer's
               expiration before it is removed from the backend storage.
        :param pulumi.Input[_builtins.bool] maintain_stored_certificate_counts: This configures whether stored certificate are
               counted upon initialization of the backend, and whether during normal operation, a running count
               of certificates stored is maintained.
        :param pulumi.Input[_builtins.str] max_startup_backoff_duration: The maximum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] min_startup_backoff_duration: The minimum amount of time auto-tidy will be delayed
               after startup.
        :param pulumi.Input[_builtins.str] namespace: The namespace of the target resource.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] pause_duration: The amount of time to wait between processing certificates.
        :param pulumi.Input[_builtins.bool] publish_stored_certificate_count_metrics: This configures whether the stored
               certificate count is published to the metrics consumer.
        :param pulumi.Input[_builtins.str] revocation_queue_safety_buffer: The amount of time that must pass from the
               cross-cluster revocation request being initiated to when it will be slated for removal.
        :param pulumi.Input[_builtins.str] safety_buffer: The amount of extra time that must have passed beyond certificate
               expiration before it is removed from the backend storage and/or revocation list.
        :param pulumi.Input[_builtins.bool] tidy_acme: Set to true to enable tidying ACME accounts, orders and authorizations.
        :param pulumi.Input[_builtins.bool] tidy_cert_metadata: Set to true to enable tidying up certificate metadata.
        :param pulumi.Input[_builtins.bool] tidy_cert_store: Set to true to enable tidying up the certificate store
        :param pulumi.Input[_builtins.bool] tidy_cmpv2_nonce_store: Set to true to enable tidying up the CMPv2 nonce store.
        :param pulumi.Input[_builtins.bool] tidy_cross_cluster_revoked_certs: Set to true to enable tidying up the cross-cluster
               revoked certificate store.
        :param pulumi.Input[_builtins.bool] tidy_expired_issuers: Set to true to automatically remove expired issuers past the
               `issuer_safety_buffer`. No keys will be removed as part of this operation.
        :param pulumi.Input[_builtins.bool] tidy_move_legacy_ca_bundle: Set to true to move the legacy `ca_bundle` from
               `/config/ca_bundle` to `/config/ca_bundle.bak`.
        :param pulumi.Input[_builtins.bool] tidy_revocation_queue: Set to true to remove stale revocation queue entries that
               haven't been confirmed by any active cluster.
        :param pulumi.Input[_builtins.bool] tidy_revoked_cert_issuer_associations: Set to true to validate issuer associations
               on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        :param pulumi.Input[_builtins.bool] tidy_revoked_certs: Set to true to remove all invalid and expired certificates from
               storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
               the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
               the CRL, and the CRL will be rotated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendConfigAutoTidyState.__new__(_BackendConfigAutoTidyState)

        __props__.__dict__["acme_account_safety_buffer"] = acme_account_safety_buffer
        __props__.__dict__["backend"] = backend
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["interval_duration"] = interval_duration
        __props__.__dict__["issuer_safety_buffer"] = issuer_safety_buffer
        __props__.__dict__["maintain_stored_certificate_counts"] = maintain_stored_certificate_counts
        __props__.__dict__["max_startup_backoff_duration"] = max_startup_backoff_duration
        __props__.__dict__["min_startup_backoff_duration"] = min_startup_backoff_duration
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["pause_duration"] = pause_duration
        __props__.__dict__["publish_stored_certificate_count_metrics"] = publish_stored_certificate_count_metrics
        __props__.__dict__["revocation_queue_safety_buffer"] = revocation_queue_safety_buffer
        __props__.__dict__["safety_buffer"] = safety_buffer
        __props__.__dict__["tidy_acme"] = tidy_acme
        __props__.__dict__["tidy_cert_metadata"] = tidy_cert_metadata
        __props__.__dict__["tidy_cert_store"] = tidy_cert_store
        __props__.__dict__["tidy_cmpv2_nonce_store"] = tidy_cmpv2_nonce_store
        __props__.__dict__["tidy_cross_cluster_revoked_certs"] = tidy_cross_cluster_revoked_certs
        __props__.__dict__["tidy_expired_issuers"] = tidy_expired_issuers
        __props__.__dict__["tidy_move_legacy_ca_bundle"] = tidy_move_legacy_ca_bundle
        __props__.__dict__["tidy_revocation_queue"] = tidy_revocation_queue
        __props__.__dict__["tidy_revoked_cert_issuer_associations"] = tidy_revoked_cert_issuer_associations
        __props__.__dict__["tidy_revoked_certs"] = tidy_revoked_certs
        return BackendConfigAutoTidy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acmeAccountSafetyBuffer")
    def acme_account_safety_buffer(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
        """
        return pulumi.get(self, "acme_account_safety_buffer")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the PKI secret backend to
        read the configuration from, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether automatic tidy is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="intervalDuration")
    def interval_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Interval at which to run an auto-tidy operation. This is the time
        between tidy invocations (after one finishes to the start of the next).
        """
        return pulumi.get(self, "interval_duration")

    @_builtins.property
    @pulumi.getter(name="issuerSafetyBuffer")
    def issuer_safety_buffer(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of extra time that must have passed beyond issuer's
        expiration before it is removed from the backend storage.
        """
        return pulumi.get(self, "issuer_safety_buffer")

    @_builtins.property
    @pulumi.getter(name="maintainStoredCertificateCounts")
    def maintain_stored_certificate_counts(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This configures whether stored certificate are
        counted upon initialization of the backend, and whether during normal operation, a running count
        of certificates stored is maintained.
        """
        return pulumi.get(self, "maintain_stored_certificate_counts")

    @_builtins.property
    @pulumi.getter(name="maxStartupBackoffDuration")
    def max_startup_backoff_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The maximum amount of time auto-tidy will be delayed
        after startup.
        """
        return pulumi.get(self, "max_startup_backoff_duration")

    @_builtins.property
    @pulumi.getter(name="minStartupBackoffDuration")
    def min_startup_backoff_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The minimum amount of time auto-tidy will be delayed
        after startup.
        """
        return pulumi.get(self, "min_startup_backoff_duration")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace of the target resource.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="pauseDuration")
    def pause_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time to wait between processing certificates.
        """
        return pulumi.get(self, "pause_duration")

    @_builtins.property
    @pulumi.getter(name="publishStoredCertificateCountMetrics")
    def publish_stored_certificate_count_metrics(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This configures whether the stored
        certificate count is published to the metrics consumer.
        """
        return pulumi.get(self, "publish_stored_certificate_count_metrics")

    @_builtins.property
    @pulumi.getter(name="revocationQueueSafetyBuffer")
    def revocation_queue_safety_buffer(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of time that must pass from the
        cross-cluster revocation request being initiated to when it will be slated for removal.
        """
        return pulumi.get(self, "revocation_queue_safety_buffer")

    @_builtins.property
    @pulumi.getter(name="safetyBuffer")
    def safety_buffer(self) -> pulumi.Output[_builtins.str]:
        """
        The amount of extra time that must have passed beyond certificate
        expiration before it is removed from the backend storage and/or revocation list.
        """
        return pulumi.get(self, "safety_buffer")

    @_builtins.property
    @pulumi.getter(name="tidyAcme")
    def tidy_acme(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to enable tidying ACME accounts, orders and authorizations.
        """
        return pulumi.get(self, "tidy_acme")

    @_builtins.property
    @pulumi.getter(name="tidyCertMetadata")
    def tidy_cert_metadata(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to enable tidying up certificate metadata.
        """
        return pulumi.get(self, "tidy_cert_metadata")

    @_builtins.property
    @pulumi.getter(name="tidyCertStore")
    def tidy_cert_store(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to enable tidying up the certificate store
        """
        return pulumi.get(self, "tidy_cert_store")

    @_builtins.property
    @pulumi.getter(name="tidyCmpv2NonceStore")
    def tidy_cmpv2_nonce_store(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to enable tidying up the CMPv2 nonce store.
        """
        return pulumi.get(self, "tidy_cmpv2_nonce_store")

    @_builtins.property
    @pulumi.getter(name="tidyCrossClusterRevokedCerts")
    def tidy_cross_cluster_revoked_certs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to enable tidying up the cross-cluster
        revoked certificate store.
        """
        return pulumi.get(self, "tidy_cross_cluster_revoked_certs")

    @_builtins.property
    @pulumi.getter(name="tidyExpiredIssuers")
    def tidy_expired_issuers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to automatically remove expired issuers past the
        `issuer_safety_buffer`. No keys will be removed as part of this operation.
        """
        return pulumi.get(self, "tidy_expired_issuers")

    @_builtins.property
    @pulumi.getter(name="tidyMoveLegacyCaBundle")
    def tidy_move_legacy_ca_bundle(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to move the legacy `ca_bundle` from
        `/config/ca_bundle` to `/config/ca_bundle.bak`.
        """
        return pulumi.get(self, "tidy_move_legacy_ca_bundle")

    @_builtins.property
    @pulumi.getter(name="tidyRevocationQueue")
    def tidy_revocation_queue(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to remove stale revocation queue entries that
        haven't been confirmed by any active cluster.
        """
        return pulumi.get(self, "tidy_revocation_queue")

    @_builtins.property
    @pulumi.getter(name="tidyRevokedCertIssuerAssociations")
    def tidy_revoked_cert_issuer_associations(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to validate issuer associations
        on revocation entries. This helps increase the performance of CRL building and OCSP responses.
        """
        return pulumi.get(self, "tidy_revoked_cert_issuer_associations")

    @_builtins.property
    @pulumi.getter(name="tidyRevokedCerts")
    def tidy_revoked_certs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to remove all invalid and expired certificates from
        storage. A revoked storage entry is considered invalid if the entry is empty, or the value within
        the entry is empty. If a certificate is removed due to expiry, the entry will also be removed from
        the CRL, and the CRL will be rotated.
        """
        return pulumi.get(self, "tidy_revoked_certs")

