# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBackendCertMetadataResult',
    'AwaitableGetBackendCertMetadataResult',
    'get_backend_cert_metadata',
    'get_backend_cert_metadata_output',
]

@pulumi.output_type
class GetBackendCertMetadataResult:
    """
    A collection of values returned by getBackendCertMetadata.
    """
    def __init__(__self__, cert_metadata=None, expiration=None, id=None, issuer_id=None, namespace=None, path=None, role=None, serial=None, serial_number=None):
        if cert_metadata and not isinstance(cert_metadata, str):
            raise TypeError("Expected argument 'cert_metadata' to be a str")
        pulumi.set(__self__, "cert_metadata", cert_metadata)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_id and not isinstance(issuer_id, str):
            raise TypeError("Expected argument 'issuer_id' to be a str")
        pulumi.set(__self__, "issuer_id", issuer_id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if serial and not isinstance(serial, str):
            raise TypeError("Expected argument 'serial' to be a str")
        pulumi.set(__self__, "serial", serial)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)

    @_builtins.property
    @pulumi.getter(name="certMetadata")
    def cert_metadata(self) -> _builtins.str:
        """
        The metadata associated with the certificate
        """
        return pulumi.get(self, "cert_metadata")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> _builtins.str:
        """
        ID of the issuer.
        """
        return pulumi.get(self, "issuer_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role used to create the certificate
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> _builtins.str:
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> _builtins.str:
        """
        The serial number
        """
        return pulumi.get(self, "serial_number")


class AwaitableGetBackendCertMetadataResult(GetBackendCertMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendCertMetadataResult(
            cert_metadata=self.cert_metadata,
            expiration=self.expiration,
            id=self.id,
            issuer_id=self.issuer_id,
            namespace=self.namespace,
            path=self.path,
            role=self.role,
            serial=self.serial,
            serial_number=self.serial_number)


def get_backend_cert_metadata(namespace: Optional[_builtins.str] = None,
                              path: Optional[_builtins.str] = None,
                              serial: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendCertMetadataResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    root = vault.pkisecret.SecretBackendRootCert("root",
        backend=pki.path,
        type="internal",
        common_name="example",
        ttl="86400",
        issuer_name="example")
    test_secret_backend_role = vault.pkisecret.SecretBackendRole("test",
        backend=test_vault_pki_secret_backend_root_cert["backend"],
        name="test",
        allowed_domains=["test.my.domain"],
        allow_subdomains=True,
        max_ttl="3600",
        key_usages=[
            "DigitalSignature",
            "KeyAgreement",
            "KeyEncipherment",
        ],
        no_store_metadata=False)
    test_secret_backend_cert = vault.pkisecret.SecretBackendCert("test",
        backend=test_secret_backend_role.backend,
        name=test_secret_backend_role.name,
        common_name="cert.test.my.domain",
        ttl="720h",
        min_seconds_remaining=60,
        cert_metadata="dGVzdCBtZXRhZGF0YQ==")
    test = test_secret_backend_cert.serial_number.apply(lambda serial_number: vault.pkiSecret.get_backend_cert_metadata_output(path=test_root["path"],
        serial=serial_number))
    ```


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str path: The path to the PKI secret backend to
           read the cert metadata from, with no leading or trailing `/`s.
    :param _builtins.str serial: Specifies the serial of the certificate whose metadata to read.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    __args__['serial'] = serial
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:pkiSecret/getBackendCertMetadata:getBackendCertMetadata', __args__, opts=opts, typ=GetBackendCertMetadataResult).value

    return AwaitableGetBackendCertMetadataResult(
        cert_metadata=pulumi.get(__ret__, 'cert_metadata'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        issuer_id=pulumi.get(__ret__, 'issuer_id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        path=pulumi.get(__ret__, 'path'),
        role=pulumi.get(__ret__, 'role'),
        serial=pulumi.get(__ret__, 'serial'),
        serial_number=pulumi.get(__ret__, 'serial_number'))
def get_backend_cert_metadata_output(namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     path: Optional[pulumi.Input[_builtins.str]] = None,
                                     serial: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackendCertMetadataResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    pki = vault.Mount("pki",
        path="pki",
        type="pki",
        description="PKI secret engine mount")
    root = vault.pkisecret.SecretBackendRootCert("root",
        backend=pki.path,
        type="internal",
        common_name="example",
        ttl="86400",
        issuer_name="example")
    test_secret_backend_role = vault.pkisecret.SecretBackendRole("test",
        backend=test_vault_pki_secret_backend_root_cert["backend"],
        name="test",
        allowed_domains=["test.my.domain"],
        allow_subdomains=True,
        max_ttl="3600",
        key_usages=[
            "DigitalSignature",
            "KeyAgreement",
            "KeyEncipherment",
        ],
        no_store_metadata=False)
    test_secret_backend_cert = vault.pkisecret.SecretBackendCert("test",
        backend=test_secret_backend_role.backend,
        name=test_secret_backend_role.name,
        common_name="cert.test.my.domain",
        ttl="720h",
        min_seconds_remaining=60,
        cert_metadata="dGVzdCBtZXRhZGF0YQ==")
    test = test_secret_backend_cert.serial_number.apply(lambda serial_number: vault.pkiSecret.get_backend_cert_metadata_output(path=test_root["path"],
        serial=serial_number))
    ```


    :param _builtins.str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
           *Available only for Vault Enterprise*.
    :param _builtins.str path: The path to the PKI secret backend to
           read the cert metadata from, with no leading or trailing `/`s.
    :param _builtins.str serial: Specifies the serial of the certificate whose metadata to read.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['path'] = path
    __args__['serial'] = serial
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:pkiSecret/getBackendCertMetadata:getBackendCertMetadata', __args__, opts=opts, typ=GetBackendCertMetadataResult)
    return __ret__.apply(lambda __response__: GetBackendCertMetadataResult(
        cert_metadata=pulumi.get(__response__, 'cert_metadata'),
        expiration=pulumi.get(__response__, 'expiration'),
        id=pulumi.get(__response__, 'id'),
        issuer_id=pulumi.get(__response__, 'issuer_id'),
        namespace=pulumi.get(__response__, 'namespace'),
        path=pulumi.get(__response__, 'path'),
        role=pulumi.get(__response__, 'role'),
        serial=pulumi.get(__response__, 'serial'),
        serial_number=pulumi.get(__response__, 'serial_number')))
