# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendRootCertArgs', 'SecretBackendRootCert']

@pulumi.input_type
class SecretBackendRootCertArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[_builtins.str],
                 common_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_path_length: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendRootCert resource.
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_dns_domains: List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_email_addresses: List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_ip_ranges: List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_uri_domains: List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_name: Provides a name to the specified issuer. The name must be unique
               across all issuers and not be the reserved value `default`
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_email_addresses: List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_ip_ranges: List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_uri_domains: List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "type", type)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if excluded_dns_domains is not None:
            pulumi.set(__self__, "excluded_dns_domains", excluded_dns_domains)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uri_domains is not None:
            pulumi.set(__self__, "excluded_uri_domains", excluded_uri_domains)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_ref is not None:
            pulumi.set(__self__, "key_ref", key_ref)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if managed_key_id is not None:
            pulumi.set(__self__, "managed_key_id", managed_key_id)
        if managed_key_name is not None:
            pulumi.set(__self__, "managed_key_name", managed_key_name)
        if max_path_length is not None:
            pulumi.set(__self__, "max_path_length", max_path_length)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if permitted_dns_domains is not None:
            pulumi.set(__self__, "permitted_dns_domains", permitted_dns_domains)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uri_domains is not None:
            pulumi.set(__self__, "permitted_uri_domains", permitted_uri_domains)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if signature_bits is not None:
            pulumi.set(__self__, "signature_bits", signature_bits)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Input[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[_builtins.str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
        or \\"kms\\"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter(name="excludedDnsDomains")
    def excluded_dns_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_dns_domains")

    @excluded_dns_domains.setter
    def excluded_dns_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_dns_domains", value)

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @excluded_email_addresses.setter
    def excluded_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @excluded_ip_ranges.setter
    def excluded_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="excludedUriDomains")
    def excluded_uri_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_uri_domains")

    @excluded_uri_domains.setter
    def excluded_uri_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_uri_domains", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provides a name to the specified issuer. The name must be unique
        across all issuers and not be the reserved value `default`
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_name", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When a new key is created with this request, optionally specifies
        the name for this. The global ref `default` may not be used as a name.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyRef")
    def key_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key (either default, by name, or by identifier) to use
        for generating this request. Only suitable for `type=existing` requests.
        """
        return pulumi.get(self, "key_ref")

    @key_ref.setter
    def key_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_ref", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the previously configured managed key. This field is
        required if `type` is `kms` and it conflicts with `managed_key_name`
        """
        return pulumi.get(self, "managed_key_id")

    @managed_key_id.setter
    def managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the previously configured managed key. This field is
        required if `type` is `kms`  and it conflicts with `managed_key_id`
        """
        return pulumi.get(self, "managed_key_name")

    @managed_key_name.setter
    def managed_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_name", value)

    @_builtins.property
    @pulumi.getter(name="maxPathLength")
    def max_path_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum path length to encode in the generated certificate
        """
        return pulumi.get(self, "max_path_length")

    @max_path_length.setter
    def max_path_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_path_length", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ou", value)

    @_builtins.property
    @pulumi.getter(name="permittedDnsDomains")
    def permitted_dns_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of domains for which certificates are allowed to be issued
        """
        return pulumi.get(self, "permitted_dns_domains")

    @permitted_dns_domains.setter
    def permitted_dns_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_dns_domains", value)

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @permitted_email_addresses.setter
    def permitted_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @permitted_ip_ranges.setter
    def permitted_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="permittedUriDomains")
    def permitted_uri_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_uri_domains")

    @permitted_uri_domains.setter
    def permitted_uri_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_uri_domains", value)

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postal_code", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_format", value)

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "province", value)

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @signature_bits.setter
    def signature_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "signature_bits", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.input_type
class _SecretBackendRootCertState:
    def __init__(__self__, *,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 issuing_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_path_length: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRootCert resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] certificate: The certificate.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_dns_domains: List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_email_addresses: List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_ip_ranges: List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_uri_domains: List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_id: The ID of the generated issuer.
        :param pulumi.Input[_builtins.str] issuer_name: Provides a name to the specified issuer. The name must be unique
               across all issuers and not be the reserved value `default`
        :param pulumi.Input[_builtins.str] issuing_ca: The issuing CA certificate.
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_id: The ID of the generated key.
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_email_addresses: List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_ip_ranges: List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_uri_domains: List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if excluded_dns_domains is not None:
            pulumi.set(__self__, "excluded_dns_domains", excluded_dns_domains)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uri_domains is not None:
            pulumi.set(__self__, "excluded_uri_domains", excluded_uri_domains)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuer_id is not None:
            pulumi.set(__self__, "issuer_id", issuer_id)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if issuing_ca is not None:
            pulumi.set(__self__, "issuing_ca", issuing_ca)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_ref is not None:
            pulumi.set(__self__, "key_ref", key_ref)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if managed_key_id is not None:
            pulumi.set(__self__, "managed_key_id", managed_key_id)
        if managed_key_name is not None:
            pulumi.set(__self__, "managed_key_name", managed_key_name)
        if max_path_length is not None:
            pulumi.set(__self__, "max_path_length", max_path_length)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ou is not None:
            pulumi.set(__self__, "ou", ou)
        if permitted_dns_domains is not None:
            pulumi.set(__self__, "permitted_dns_domains", permitted_dns_domains)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uri_domains is not None:
            pulumi.set(__self__, "permitted_uri_domains", permitted_uri_domains)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if private_key_format is not None:
            pulumi.set(__self__, "private_key_format", private_key_format)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature_bits is not None:
            pulumi.set(__self__, "signature_bits", signature_bits)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alt_names", value)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "common_name", value)

    @_builtins.property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country", value)

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @_builtins.property
    @pulumi.getter(name="excludedDnsDomains")
    def excluded_dns_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_dns_domains")

    @excluded_dns_domains.setter
    def excluded_dns_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_dns_domains", value)

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @excluded_email_addresses.setter
    def excluded_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @excluded_ip_ranges.setter
    def excluded_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="excludedUriDomains")
    def excluded_uri_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_uri_domains")

    @excluded_uri_domains.setter
    def excluded_uri_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_uri_domains", value)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_sans", value)

    @_builtins.property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the generated issuer.
        """
        return pulumi.get(self, "issuer_id")

    @issuer_id.setter
    def issuer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_id", value)

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provides a name to the specified issuer. The name must be unique
        across all issuers and not be the reserved value `default`
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_name", value)

    @_builtins.property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuing CA certificate.
        """
        return pulumi.get(self, "issuing_ca")

    @issuing_ca.setter
    def issuing_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuing_ca", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the generated key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When a new key is created with this request, optionally specifies
        the name for this. The global ref `default` may not be used as a name.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyRef")
    def key_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key (either default, by name, or by identifier) to use
        for generating this request. Only suitable for `type=existing` requests.
        """
        return pulumi.get(self, "key_ref")

    @key_ref.setter
    def key_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_ref", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @locality.setter
    def locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locality", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the previously configured managed key. This field is
        required if `type` is `kms` and it conflicts with `managed_key_name`
        """
        return pulumi.get(self, "managed_key_id")

    @managed_key_id.setter
    def managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the previously configured managed key. This field is
        required if `type` is `kms`  and it conflicts with `managed_key_id`
        """
        return pulumi.get(self, "managed_key_name")

    @managed_key_name.setter
    def managed_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_name", value)

    @_builtins.property
    @pulumi.getter(name="maxPathLength")
    def max_path_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum path length to encode in the generated certificate
        """
        return pulumi.get(self, "max_path_length")

    @max_path_length.setter
    def max_path_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_path_length", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "other_sans", value)

    @_builtins.property
    @pulumi.getter
    def ou(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @ou.setter
    def ou(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ou", value)

    @_builtins.property
    @pulumi.getter(name="permittedDnsDomains")
    def permitted_dns_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of domains for which certificates are allowed to be issued
        """
        return pulumi.get(self, "permitted_dns_domains")

    @permitted_dns_domains.setter
    def permitted_dns_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_dns_domains", value)

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @permitted_email_addresses.setter
    def permitted_email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @permitted_ip_ranges.setter
    def permitted_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="permittedUriDomains")
    def permitted_uri_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_uri_domains")

    @permitted_uri_domains.setter
    def permitted_uri_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permitted_uri_domains", value)

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postal_code", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @private_key_format.setter
    def private_key_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_format", value)

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "province", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @signature_bits.setter
    def signature_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "signature_bits", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
        or \\"kms\\"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.type_token("vault:pkiSecret/secretBackendRootCert:SecretBackendRootCert")
class SecretBackendRootCert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_path_length: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pkisecret.SecretBackendRootCert("test",
            backend=pki["path"],
            type="internal",
            common_name="Root CA",
            ttl="315360000",
            format="pem",
            private_key_format="der",
            key_type="rsa",
            key_bits=4096,
            exclude_cn_from_sans=True,
            ou="My OU",
            organization="My organization",
            opts = pulumi.ResourceOptions(depends_on=[pki]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_dns_domains: List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_email_addresses: List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_ip_ranges: List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_uri_domains: List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_name: Provides a name to the specified issuer. The name must be unique
               across all issuers and not be the reserved value `default`
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_email_addresses: List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_ip_ranges: List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_uri_domains: List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRootCertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pkisecret.SecretBackendRootCert("test",
            backend=pki["path"],
            type="internal",
            common_name="Root CA",
            ttl="315360000",
            format="pem",
            private_key_format="der",
            key_type="rsa",
            key_bits=4096,
            exclude_cn_from_sans=True,
            ou="My OU",
            organization="My organization",
            opts = pulumi.ResourceOptions(depends_on=[pki]))
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRootCertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRootCertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 common_name: Optional[pulumi.Input[_builtins.str]] = None,
                 country: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 excluded_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 format: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 locality: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_path_length: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ou: Optional[pulumi.Input[_builtins.str]] = None,
                 permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permitted_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 postal_code: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
                 province: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRootCertArgs.__new__(SecretBackendRootCertArgs)

            __props__.__dict__["alt_names"] = alt_names
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["country"] = country
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["excluded_dns_domains"] = excluded_dns_domains
            __props__.__dict__["excluded_email_addresses"] = excluded_email_addresses
            __props__.__dict__["excluded_ip_ranges"] = excluded_ip_ranges
            __props__.__dict__["excluded_uri_domains"] = excluded_uri_domains
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["issuer_name"] = issuer_name
            __props__.__dict__["key_bits"] = key_bits
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["key_ref"] = key_ref
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["locality"] = locality
            __props__.__dict__["managed_key_id"] = managed_key_id
            __props__.__dict__["managed_key_name"] = managed_key_name
            __props__.__dict__["max_path_length"] = max_path_length
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["not_after"] = not_after
            __props__.__dict__["organization"] = organization
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["ou"] = ou
            __props__.__dict__["permitted_dns_domains"] = permitted_dns_domains
            __props__.__dict__["permitted_email_addresses"] = permitted_email_addresses
            __props__.__dict__["permitted_ip_ranges"] = permitted_ip_ranges
            __props__.__dict__["permitted_uri_domains"] = permitted_uri_domains
            __props__.__dict__["postal_code"] = postal_code
            __props__.__dict__["private_key_format"] = private_key_format
            __props__.__dict__["province"] = province
            __props__.__dict__["signature_bits"] = signature_bits
            __props__.__dict__["street_address"] = street_address
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["certificate"] = None
            __props__.__dict__["issuer_id"] = None
            __props__.__dict__["issuing_ca"] = None
            __props__.__dict__["key_id"] = None
            __props__.__dict__["serial_number"] = None
        super(SecretBackendRootCert, __self__).__init__(
            'vault:pkiSecret/secretBackendRootCert:SecretBackendRootCert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            common_name: Optional[pulumi.Input[_builtins.str]] = None,
            country: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[_builtins.bool]] = None,
            excluded_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            excluded_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            excluded_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            excluded_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            format: Optional[pulumi.Input[_builtins.str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            issuer_id: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_name: Optional[pulumi.Input[_builtins.str]] = None,
            issuing_ca: Optional[pulumi.Input[_builtins.str]] = None,
            key_bits: Optional[pulumi.Input[_builtins.int]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_ref: Optional[pulumi.Input[_builtins.str]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            locality: Optional[pulumi.Input[_builtins.str]] = None,
            managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_path_length: Optional[pulumi.Input[_builtins.int]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            not_after: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ou: Optional[pulumi.Input[_builtins.str]] = None,
            permitted_dns_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            permitted_email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            permitted_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            permitted_uri_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            postal_code: Optional[pulumi.Input[_builtins.str]] = None,
            private_key_format: Optional[pulumi.Input[_builtins.str]] = None,
            province: Optional[pulumi.Input[_builtins.str]] = None,
            serial_number: Optional[pulumi.Input[_builtins.str]] = None,
            signature_bits: Optional[pulumi.Input[_builtins.int]] = None,
            street_address: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'SecretBackendRootCert':
        """
        Get an existing SecretBackendRootCert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alt_names: List of alternative names
        :param pulumi.Input[_builtins.str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[_builtins.str] certificate: The certificate.
        :param pulumi.Input[_builtins.str] common_name: CN of intermediate to create
        :param pulumi.Input[_builtins.str] country: The country
        :param pulumi.Input[_builtins.bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_dns_domains: List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_email_addresses: List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_ip_ranges: List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_uri_domains: List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[_builtins.str] issuer_id: The ID of the generated issuer.
        :param pulumi.Input[_builtins.str] issuer_name: Provides a name to the specified issuer. The name must be unique
               across all issuers and not be the reserved value `default`
        :param pulumi.Input[_builtins.str] issuing_ca: The issuing CA certificate.
        :param pulumi.Input[_builtins.int] key_bits: The number of bits to use
        :param pulumi.Input[_builtins.str] key_id: The ID of the generated key.
        :param pulumi.Input[_builtins.str] key_name: When a new key is created with this request, optionally specifies
               the name for this. The global ref `default` may not be used as a name.
        :param pulumi.Input[_builtins.str] key_ref: Specifies the key (either default, by name, or by identifier) to use
               for generating this request. Only suitable for `type=existing` requests.
        :param pulumi.Input[_builtins.str] key_type: The desired key type
        :param pulumi.Input[_builtins.str] locality: The locality
        :param pulumi.Input[_builtins.str] managed_key_id: The ID of the previously configured managed key. This field is
               required if `type` is `kms` and it conflicts with `managed_key_name`
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the previously configured managed key. This field is
               required if `type` is `kms`  and it conflicts with `managed_key_id`
        :param pulumi.Input[_builtins.int] max_path_length: The maximum path length to encode in the generated certificate
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] not_after: Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        :param pulumi.Input[_builtins.str] organization: The organization
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] other_sans: List of other SANs
        :param pulumi.Input[_builtins.str] ou: The organization unit
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_dns_domains: List of domains for which certificates are allowed to be issued
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_email_addresses: List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_ip_ranges: List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permitted_uri_domains: List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        :param pulumi.Input[_builtins.str] postal_code: The postal code
        :param pulumi.Input[_builtins.str] private_key_format: The private key format
        :param pulumi.Input[_builtins.str] province: The province
        :param pulumi.Input[_builtins.str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[_builtins.int] signature_bits: The number of bits to use in the signature algorithm
        :param pulumi.Input[_builtins.str] street_address: The street address
        :param pulumi.Input[_builtins.str] ttl: Time to live
        :param pulumi.Input[_builtins.str] type: Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
               or \\"kms\\"
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] uri_sans: List of alternative URIs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRootCertState.__new__(_SecretBackendRootCertState)

        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["backend"] = backend
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["country"] = country
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["excluded_dns_domains"] = excluded_dns_domains
        __props__.__dict__["excluded_email_addresses"] = excluded_email_addresses
        __props__.__dict__["excluded_ip_ranges"] = excluded_ip_ranges
        __props__.__dict__["excluded_uri_domains"] = excluded_uri_domains
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["issuer_id"] = issuer_id
        __props__.__dict__["issuer_name"] = issuer_name
        __props__.__dict__["issuing_ca"] = issuing_ca
        __props__.__dict__["key_bits"] = key_bits
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["key_ref"] = key_ref
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["locality"] = locality
        __props__.__dict__["managed_key_id"] = managed_key_id
        __props__.__dict__["managed_key_name"] = managed_key_name
        __props__.__dict__["max_path_length"] = max_path_length
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["organization"] = organization
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["ou"] = ou
        __props__.__dict__["permitted_dns_domains"] = permitted_dns_domains
        __props__.__dict__["permitted_email_addresses"] = permitted_email_addresses
        __props__.__dict__["permitted_ip_ranges"] = permitted_ip_ranges
        __props__.__dict__["permitted_uri_domains"] = permitted_uri_domains
        __props__.__dict__["postal_code"] = postal_code
        __props__.__dict__["private_key_format"] = private_key_format
        __props__.__dict__["province"] = province
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature_bits"] = signature_bits
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["uri_sans"] = uri_sans
        return SecretBackendRootCert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[_builtins.str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[_builtins.str]:
        """
        CN of intermediate to create
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The country
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @_builtins.property
    @pulumi.getter(name="excludedDnsDomains")
    def excluded_dns_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_dns_domains")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of email addresses for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of IP ranges for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUriDomains")
    def excluded_uri_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of URI domains for which certificates are not allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "excluded_uri_domains")

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @_builtins.property
    @pulumi.getter(name="issuerId")
    def issuer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the generated issuer.
        """
        return pulumi.get(self, "issuer_id")

    @_builtins.property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> pulumi.Output[_builtins.str]:
        """
        Provides a name to the specified issuer. The name must be unique
        across all issuers and not be the reserved value `default`
        """
        return pulumi.get(self, "issuer_name")

    @_builtins.property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> pulumi.Output[_builtins.str]:
        """
        The issuing CA certificate.
        """
        return pulumi.get(self, "issuing_ca")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of bits to use
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the generated key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[_builtins.str]:
        """
        When a new key is created with this request, optionally specifies
        the name for this. The global ref `default` may not be used as a name.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="keyRef")
    def key_ref(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the key (either default, by name, or by identifier) to use
        for generating this request. Only suitable for `type=existing` requests.
        """
        return pulumi.get(self, "key_ref")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired key type
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The locality
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the previously configured managed key. This field is
        required if `type` is `kms` and it conflicts with `managed_key_name`
        """
        return pulumi.get(self, "managed_key_id")

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the previously configured managed key. This field is
        required if `type` is `kms`  and it conflicts with `managed_key_id`
        """
        return pulumi.get(self, "managed_key_name")

    @_builtins.property
    @pulumi.getter(name="maxPathLength")
    def max_path_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum path length to encode in the generated certificate
        """
        return pulumi.get(self, "max_path_length")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the Not After field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ. Supports the Y10K end date for IEEE 802.1AR-2018 standard devices, 9999-12-31T23:59:59Z.
        """
        return pulumi.get(self, "not_after")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @_builtins.property
    @pulumi.getter
    def ou(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The organization unit
        """
        return pulumi.get(self, "ou")

    @_builtins.property
    @pulumi.getter(name="permittedDnsDomains")
    def permitted_dns_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of domains for which certificates are allowed to be issued
        """
        return pulumi.get(self, "permitted_dns_domains")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of email addresses for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of IP ranges for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUriDomains")
    def permitted_uri_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of URI domains for which certificates are allowed to be issued. Requires Vault version 1.19+.
        """
        return pulumi.get(self, "permitted_uri_domains")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The postal code
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter(name="privateKeyFormat")
    def private_key_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key format
        """
        return pulumi.get(self, "private_key_format")

    @_builtins.property
    @pulumi.getter
    def province(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The province
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="signatureBits")
    def signature_bits(self) -> pulumi.Output[_builtins.int]:
        """
        The number of bits to use in the signature algorithm
        """
        return pulumi.get(self, "signature_bits")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The street address
        """
        return pulumi.get(self, "street_address")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of intermediate to create. Must be either \\"exported\\", \\"internal\\"
        or \\"kms\\"
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

