# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretBackendSignResult',
    'AwaitableGetSecretBackendSignResult',
    'get_secret_backend_sign',
    'get_secret_backend_sign_output',
]

@pulumi.output_type
class GetSecretBackendSignResult:
    """
    A collection of values returned by getSecretBackendSign.
    """
    def __init__(__self__, cert_type=None, critical_options=None, extensions=None, id=None, key_id=None, name=None, namespace=None, path=None, public_key=None, serial_number=None, signed_key=None, ttl=None, valid_principals=None):
        if cert_type and not isinstance(cert_type, str):
            raise TypeError("Expected argument 'cert_type' to be a str")
        pulumi.set(__self__, "cert_type", cert_type)
        if critical_options and not isinstance(critical_options, dict):
            raise TypeError("Expected argument 'critical_options' to be a dict")
        pulumi.set(__self__, "critical_options", critical_options)
        if extensions and not isinstance(extensions, dict):
            raise TypeError("Expected argument 'extensions' to be a dict")
        pulumi.set(__self__, "extensions", extensions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if signed_key and not isinstance(signed_key, str):
            raise TypeError("Expected argument 'signed_key' to be a str")
        pulumi.set(__self__, "signed_key", signed_key)
        if ttl and not isinstance(ttl, str):
            raise TypeError("Expected argument 'ttl' to be a str")
        pulumi.set(__self__, "ttl", ttl)
        if valid_principals and not isinstance(valid_principals, str):
            raise TypeError("Expected argument 'valid_principals' to be a str")
        pulumi.set(__self__, "valid_principals", valid_principals)

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cert_type")

    @_builtins.property
    @pulumi.getter(name="criticalOptions")
    def critical_options(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "critical_options")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> _builtins.str:
        """
        The serial number of the certificate returned from Vault
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="signedKey")
    def signed_key(self) -> _builtins.str:
        """
        The signed certificate returned from Vault
        """
        return pulumi.get(self, "signed_key")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="validPrincipals")
    def valid_principals(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "valid_principals")


class AwaitableGetSecretBackendSignResult(GetSecretBackendSignResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretBackendSignResult(
            cert_type=self.cert_type,
            critical_options=self.critical_options,
            extensions=self.extensions,
            id=self.id,
            key_id=self.key_id,
            name=self.name,
            namespace=self.namespace,
            path=self.path,
            public_key=self.public_key,
            serial_number=self.serial_number,
            signed_key=self.signed_key,
            ttl=self.ttl,
            valid_principals=self.valid_principals)


def get_secret_backend_sign(cert_type: Optional[_builtins.str] = None,
                            critical_options: Optional[Mapping[str, _builtins.str]] = None,
                            extensions: Optional[Mapping[str, _builtins.str]] = None,
                            key_id: Optional[_builtins.str] = None,
                            name: Optional[_builtins.str] = None,
                            namespace: Optional[_builtins.str] = None,
                            path: Optional[_builtins.str] = None,
                            public_key: Optional[_builtins.str] = None,
                            ttl: Optional[_builtins.str] = None,
                            valid_principals: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretBackendSignResult:
    """
    This is a data source which can be used to sign an SSH public key

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    test = vault.ssh.get_secret_backend_sign(path="ssh",
        public_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDR6q4PTcuIkpdGEqaCaxnR8/REqlbSiEIKaRZkVSjiTXOaiSfUsy9cY2+7+oO9fLMUrhylImerjzEoagX1IjYvc9IeUBaRnfacN7QwUDfstgp2jknbg7rNX9j9nFxwltV/jYQPcRq8Ud0wn1nb4qixq+diM7+Up+xJOeaKxbpjEUJH5dcvaBB+Aa24tJpjOQxtFyQ6dUxlgJu0tcygZR92kKYCVjZDohlSED3i/Ak2KFwqCKx2IZWq9z1vMEgmRzv++4Qt1OsbpW8itiCyWn6lmV33eDCdjMrr9TEThQNnMinPrHdmVUnPZ/OomP+rLDRE9lQR16uaSvKhg5TWOFIXRPyEhX9arEATrE4KSWeQN2qgHOb6P24YqgEm1ZdHJq25q/nBBAa1x0tFMiWqZwOsGeJ9nTeOeyiqFKH5YRBo6DIy3ag3taFsfQSve6oqjnrudUd1hJ8/bNSz8amECfP0ULvAEAgpiurj3eCPc3OcXl4tAld9F6KwabEJV5eelcs= user@example.com",
        name="test",
        valid_principals="my-user")
    ```


    :param _builtins.str cert_type: Specifies the type of certificate to be created; either "user" or "host".
    :param Mapping[str, _builtins.str] critical_options: Specifies a map of the critical options that the certificate should be signed for. Defaults to none.
    :param Mapping[str, _builtins.str] extensions: Specifies a map of the extensions that the certificate should be signed for. Defaults to none.
    :param _builtins.str key_id: Specifies the key id that the created certificate should have. If not specified, the display name of the token will be used.
    :param _builtins.str name: Specifies the name of the role to sign.
    :param _builtins.str path: Full path where SSH backend is mounted.
    :param _builtins.str public_key: Specifies the SSH public key that should be signed.
    :param _builtins.str ttl: Specifies the Requested Time To Live. Cannot be greater than the role's max_ttl value. If not provided, the role's ttl value will be used. Note that the role values default to system values if not explicitly set.
    :param _builtins.str valid_principals: Specifies valid principals, either usernames or hostnames, that the certificate should be signed for. Required unless the role has specified allow_empty_principals or a value has been set for either the default_user or default_user_template role parameters.
    """
    __args__ = dict()
    __args__['certType'] = cert_type
    __args__['criticalOptions'] = critical_options
    __args__['extensions'] = extensions
    __args__['keyId'] = key_id
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['path'] = path
    __args__['publicKey'] = public_key
    __args__['ttl'] = ttl
    __args__['validPrincipals'] = valid_principals
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:ssh/getSecretBackendSign:getSecretBackendSign', __args__, opts=opts, typ=GetSecretBackendSignResult).value

    return AwaitableGetSecretBackendSignResult(
        cert_type=pulumi.get(__ret__, 'cert_type'),
        critical_options=pulumi.get(__ret__, 'critical_options'),
        extensions=pulumi.get(__ret__, 'extensions'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        path=pulumi.get(__ret__, 'path'),
        public_key=pulumi.get(__ret__, 'public_key'),
        serial_number=pulumi.get(__ret__, 'serial_number'),
        signed_key=pulumi.get(__ret__, 'signed_key'),
        ttl=pulumi.get(__ret__, 'ttl'),
        valid_principals=pulumi.get(__ret__, 'valid_principals'))
def get_secret_backend_sign_output(cert_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   critical_options: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                   extensions: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                   key_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   name: Optional[pulumi.Input[_builtins.str]] = None,
                                   namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   path: Optional[pulumi.Input[_builtins.str]] = None,
                                   public_key: Optional[pulumi.Input[_builtins.str]] = None,
                                   ttl: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   valid_principals: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretBackendSignResult]:
    """
    This is a data source which can be used to sign an SSH public key

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    test = vault.ssh.get_secret_backend_sign(path="ssh",
        public_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDR6q4PTcuIkpdGEqaCaxnR8/REqlbSiEIKaRZkVSjiTXOaiSfUsy9cY2+7+oO9fLMUrhylImerjzEoagX1IjYvc9IeUBaRnfacN7QwUDfstgp2jknbg7rNX9j9nFxwltV/jYQPcRq8Ud0wn1nb4qixq+diM7+Up+xJOeaKxbpjEUJH5dcvaBB+Aa24tJpjOQxtFyQ6dUxlgJu0tcygZR92kKYCVjZDohlSED3i/Ak2KFwqCKx2IZWq9z1vMEgmRzv++4Qt1OsbpW8itiCyWn6lmV33eDCdjMrr9TEThQNnMinPrHdmVUnPZ/OomP+rLDRE9lQR16uaSvKhg5TWOFIXRPyEhX9arEATrE4KSWeQN2qgHOb6P24YqgEm1ZdHJq25q/nBBAa1x0tFMiWqZwOsGeJ9nTeOeyiqFKH5YRBo6DIy3ag3taFsfQSve6oqjnrudUd1hJ8/bNSz8amECfP0ULvAEAgpiurj3eCPc3OcXl4tAld9F6KwabEJV5eelcs= user@example.com",
        name="test",
        valid_principals="my-user")
    ```


    :param _builtins.str cert_type: Specifies the type of certificate to be created; either "user" or "host".
    :param Mapping[str, _builtins.str] critical_options: Specifies a map of the critical options that the certificate should be signed for. Defaults to none.
    :param Mapping[str, _builtins.str] extensions: Specifies a map of the extensions that the certificate should be signed for. Defaults to none.
    :param _builtins.str key_id: Specifies the key id that the created certificate should have. If not specified, the display name of the token will be used.
    :param _builtins.str name: Specifies the name of the role to sign.
    :param _builtins.str path: Full path where SSH backend is mounted.
    :param _builtins.str public_key: Specifies the SSH public key that should be signed.
    :param _builtins.str ttl: Specifies the Requested Time To Live. Cannot be greater than the role's max_ttl value. If not provided, the role's ttl value will be used. Note that the role values default to system values if not explicitly set.
    :param _builtins.str valid_principals: Specifies valid principals, either usernames or hostnames, that the certificate should be signed for. Required unless the role has specified allow_empty_principals or a value has been set for either the default_user or default_user_template role parameters.
    """
    __args__ = dict()
    __args__['certType'] = cert_type
    __args__['criticalOptions'] = critical_options
    __args__['extensions'] = extensions
    __args__['keyId'] = key_id
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['path'] = path
    __args__['publicKey'] = public_key
    __args__['ttl'] = ttl
    __args__['validPrincipals'] = valid_principals
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vault:ssh/getSecretBackendSign:getSecretBackendSign', __args__, opts=opts, typ=GetSecretBackendSignResult)
    return __ret__.apply(lambda __response__: GetSecretBackendSignResult(
        cert_type=pulumi.get(__response__, 'cert_type'),
        critical_options=pulumi.get(__response__, 'critical_options'),
        extensions=pulumi.get(__response__, 'extensions'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        path=pulumi.get(__response__, 'path'),
        public_key=pulumi.get(__response__, 'public_key'),
        serial_number=pulumi.get(__response__, 'serial_number'),
        signed_key=pulumi.get(__response__, 'signed_key'),
        ttl=pulumi.get(__response__, 'ttl'),
        valid_principals=pulumi.get(__response__, 'valid_principals')))
