# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretBackendCaArgs', 'SecretBackendCa']

@pulumi.input_type
class SecretBackendCaArgs:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_signing_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretBackendCa resource.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted. Defaults to 'ssh'
        :param pulumi.Input[_builtins.bool] generate_signing_key: Whether Vault should generate the signing key pair internally. Defaults to true
        :param pulumi.Input[_builtins.int] key_bits: Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] key_type: Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] managed_key_id: The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] private_key: The private key part the SSH CA key pair; required if generate_signing_key is false.
        :param pulumi.Input[_builtins.str] public_key: The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if generate_signing_key is not None:
            pulumi.set(__self__, "generate_signing_key", generate_signing_key)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if managed_key_id is not None:
            pulumi.set(__self__, "managed_key_id", managed_key_id)
        if managed_key_name is not None:
            pulumi.set(__self__, "managed_key_name", managed_key_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the SSH secret backend is mounted. Defaults to 'ssh'
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="generateSigningKey")
    def generate_signing_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Vault should generate the signing key pair internally. Defaults to true
        """
        return pulumi.get(self, "generate_signing_key")

    @generate_signing_key.setter
    def generate_signing_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_signing_key", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        """
        return pulumi.get(self, "managed_key_id")

    @managed_key_id.setter
    def managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        """
        return pulumi.get(self, "managed_key_name")

    @managed_key_name.setter
    def managed_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key part the SSH CA key pair; required if generate_signing_key is false.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)


@pulumi.input_type
class _SecretBackendCaState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_signing_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendCa resources.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted. Defaults to 'ssh'
        :param pulumi.Input[_builtins.bool] generate_signing_key: Whether Vault should generate the signing key pair internally. Defaults to true
        :param pulumi.Input[_builtins.int] key_bits: Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] key_type: Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] managed_key_id: The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] private_key: The private key part the SSH CA key pair; required if generate_signing_key is false.
        :param pulumi.Input[_builtins.str] public_key: The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if generate_signing_key is not None:
            pulumi.set(__self__, "generate_signing_key", generate_signing_key)
        if key_bits is not None:
            pulumi.set(__self__, "key_bits", key_bits)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if managed_key_id is not None:
            pulumi.set(__self__, "managed_key_id", managed_key_id)
        if managed_key_name is not None:
            pulumi.set(__self__, "managed_key_name", managed_key_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path where the SSH secret backend is mounted. Defaults to 'ssh'
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend", value)

    @_builtins.property
    @pulumi.getter(name="generateSigningKey")
    def generate_signing_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Vault should generate the signing key pair internally. Defaults to true
        """
        return pulumi.get(self, "generate_signing_key")

    @generate_signing_key.setter
    def generate_signing_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_signing_key", value)

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        """
        return pulumi.get(self, "key_bits")

    @key_bits.setter
    def key_bits(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_bits", value)

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_type", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        """
        return pulumi.get(self, "managed_key_id")

    @managed_key_id.setter
    def managed_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        """
        return pulumi.get(self, "managed_key_name")

    @managed_key_name.setter
    def managed_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_key_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key part the SSH CA key pair; required if generate_signing_key is false.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)


@pulumi.type_token("vault:ssh/secretBackendCa:SecretBackendCa")
class SecretBackendCa(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_signing_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage CA information in an SSH secret backend
        [SSH secret backend within Vault](https://www.vaultproject.io/docs/secrets/ssh/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Mount("example", type="ssh")
        foo = vault.ssh.SecretBackendCa("foo", backend=example.path)
        ```

        ## Import

        SSH secret backend CAs can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ssh/secretBackendCa:SecretBackendCa foo ssh
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted. Defaults to 'ssh'
        :param pulumi.Input[_builtins.bool] generate_signing_key: Whether Vault should generate the signing key pair internally. Defaults to true
        :param pulumi.Input[_builtins.int] key_bits: Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] key_type: Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] managed_key_id: The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] private_key: The private key part the SSH CA key pair; required if generate_signing_key is false.
        :param pulumi.Input[_builtins.str] public_key: The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecretBackendCaArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage CA information in an SSH secret backend
        [SSH secret backend within Vault](https://www.vaultproject.io/docs/secrets/ssh/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Mount("example", type="ssh")
        foo = vault.ssh.SecretBackendCa("foo", backend=example.path)
        ```

        ## Import

        SSH secret backend CAs can be imported using the `path`, e.g.

        ```sh
        $ pulumi import vault:ssh/secretBackendCa:SecretBackendCa foo ssh
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendCaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendCaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_signing_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_bits: Optional[pulumi.Input[_builtins.int]] = None,
                 key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendCaArgs.__new__(SecretBackendCaArgs)

            __props__.__dict__["backend"] = backend
            __props__.__dict__["generate_signing_key"] = generate_signing_key
            __props__.__dict__["key_bits"] = key_bits
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["managed_key_id"] = managed_key_id
            __props__.__dict__["managed_key_name"] = managed_key_name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["public_key"] = public_key
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretBackendCa, __self__).__init__(
            'vault:ssh/secretBackendCa:SecretBackendCa',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[_builtins.str]] = None,
            generate_signing_key: Optional[pulumi.Input[_builtins.bool]] = None,
            key_bits: Optional[pulumi.Input[_builtins.int]] = None,
            key_type: Optional[pulumi.Input[_builtins.str]] = None,
            managed_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretBackendCa':
        """
        Get an existing SecretBackendCa resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend: The path where the SSH secret backend is mounted. Defaults to 'ssh'
        :param pulumi.Input[_builtins.bool] generate_signing_key: Whether Vault should generate the signing key pair internally. Defaults to true
        :param pulumi.Input[_builtins.int] key_bits: Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] key_type: Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        :param pulumi.Input[_builtins.str] managed_key_id: The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        :param pulumi.Input[_builtins.str] managed_key_name: The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        :param pulumi.Input[_builtins.str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[_builtins.str] private_key: The private key part the SSH CA key pair; required if generate_signing_key is false.
        :param pulumi.Input[_builtins.str] public_key: The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendCaState.__new__(_SecretBackendCaState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["generate_signing_key"] = generate_signing_key
        __props__.__dict__["key_bits"] = key_bits
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["managed_key_id"] = managed_key_id
        __props__.__dict__["managed_key_name"] = managed_key_name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_key"] = public_key
        return SecretBackendCa(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path where the SSH secret backend is mounted. Defaults to 'ssh'
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="generateSigningKey")
    def generate_signing_key(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Vault should generate the signing key pair internally. Defaults to true
        """
        return pulumi.get(self, "generate_signing_key")

    @_builtins.property
    @pulumi.getter(name="keyBits")
    def key_bits(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the desired key bits for the generated SSH CA key when `generate_signing_key` is set to `true`.
        """
        return pulumi.get(self, "key_bits")

    @_builtins.property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the desired key type for the generated SSH CA key when `generate_signing_key` is set to `true`.
        """
        return pulumi.get(self, "key_type")

    @_builtins.property
    @pulumi.getter(name="managedKeyId")
    def managed_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of the managed key to use. When using a managed key, this field or managed_key_name is required.
        """
        return pulumi.get(self, "managed_key_id")

    @_builtins.property
    @pulumi.getter(name="managedKeyName")
    def managed_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the managed key to use. When using a managed key, this field or managed_key_id is required.
        """
        return pulumi.get(self, "managed_key_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault/index.html#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key part the SSH CA key pair; required if generate_signing_key is false.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        The public key part the SSH CA key pair; required if generate_signing_key is false.
        """
        return pulumi.get(self, "public_key")

