The **seeq-spy** Python module is the recommended programming interface for interacting with the Seeq Server.

Use of this module requires a
[Seeq Data Lab license](https://support.seeq.com/space/KB/113723667/Requesting+and+Installing+a+License+File).

Documentation can be found at
[https://python-docs.seeq.com](https://python-docs.seeq.com/).

The Seeq **SPy** module is a friendly set of functions that are optimized for use with
[Jupyter](https://jupyter.org), [Pandas](https://pandas.pydata.org/) and [NumPy](https://www.numpy.org/).

The SPy module is the best choice if you're trying to do any of the following:

- Search for signals, conditions, scalars, assets
- Pull data out of Seeq
- Import data in a programmatic way (when Seeq Workbench's *CSV Import* capability won't cut it)
- Calculate new data in Python and push it into Seeq
- Create an asset model
- Programmatically create and manipulate Workbench Analyses or Organizer Topics

**Use of the SPy module requires Python 3.8 or later.**

**SPy version 187 and higher is compatible with Pandas 2.x.**

To start exploring the SPy module, execute the following lines of code in Jupyter:

```
from seeq import spy
spy.docs.copy()
```

Your Jupyter folder will now contain a `SPy Documentation` folder that has a *Tutorial* and *Command Reference*
notebook that will walk you through common activities.

For more advanced tasks, you may need to use the `seeq.sdk` module directly as described at
[https://pypi.org/project/seeq](https://pypi.org/project/seeq).

# Upgrade Considerations

The `seeq-spy` module can/should be upgraded separately from the main `seeq` module by doing `pip install -U
seeq-spy`. It is written to be compatible with Seeq Server version R60 and later.

## DataFrame Metadata

In **SPy v183** and later, the DataFrame metadata that is described in the *Properties stored in the output DataFrame*
section of the **spy.search.ipynb** documentation notebook has been moved into a top-level `spy` namespace on the
DataFrame (as opposed to each variable being at the top level). For example, in order to access the function name that
was used to produce the DataFrame, you would use `search_df.spy.func` instead of just `search_df.func`. This change was
made to avoid collisions with native DataFrame properties and functions.

## spy.assets

In **SPy v183** and later, `spy.assets.build()` conducts the build process in two passes instead of one. This generally
has no repercussions for your Asset- or Mixin-derived classes, but you will notice that
`@Asset.Component`-decorated functions are called twice per asset. In the first pass, the framework is expecting the
component asset classes to be instantiated, and in the second pass it is expecting all attributes to be evaluated and
built. This new behavior generally does not require you to make any changes to your classes, with one exception: If you
were using `@Asset.Component` as a means by which you could generate multiple signals/conditions/scalars/metrics from a
single function, you should instead use `@Asset.Attribute` to achieve that.

## spy.workbooks

In **Seeq Server R22.0.49.00**, the ability to schedule the update of an Organizer Topic was added. As a result, much of
the internals of how Organizer Topic embedded content and date ranges are represented changed.

If you have used `spy.workbooks.save()` in R22.0.48.XX and earlier to save a set of Organizer Topic workbooks to disk,
you will not be able to use those files in R22.0.49.00 and later.

Live Docs must now be specified by a `schedule` on the `TopicDocument` object. The `@Asset.DateRange`
decorator no longer honors the `Auto Refresh Rate` property. To specify a Live Doc, you must specify a
`schedule` dict for a TopicDocument by setting `document.schedule['Background'] = False` and then specifying a Cron
expression like `schedule['Cron Schedule'] = ['*/30 * * * * *']` (every thirty seconds). Alternatively, you can specify
a Scheduled Doc by setting `document.schedule['Background'] = True`.
