# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRuleEnforcementResult',
    'AwaitableGetRuleEnforcementResult',
    'get_rule_enforcement',
    'get_rule_enforcement_output',
]

@pulumi.output_type
class GetRuleEnforcementResult:
    """
    A collection of values returned by getRuleEnforcement.
    """
    def __init__(__self__, cloud_provider=None, description=None, enforcement_id=None, execution_schedule=None, execution_timezone=None, id=None, is_dry_run=None, is_enabled=None, name=None, rule_ids=None, rule_set_ids=None, target_accounts=None, target_regions=None):
        if cloud_provider and not isinstance(cloud_provider, str):
            raise TypeError("Expected argument 'cloud_provider' to be a str")
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enforcement_id and not isinstance(enforcement_id, str):
            raise TypeError("Expected argument 'enforcement_id' to be a str")
        pulumi.set(__self__, "enforcement_id", enforcement_id)
        if execution_schedule and not isinstance(execution_schedule, str):
            raise TypeError("Expected argument 'execution_schedule' to be a str")
        pulumi.set(__self__, "execution_schedule", execution_schedule)
        if execution_timezone and not isinstance(execution_timezone, str):
            raise TypeError("Expected argument 'execution_timezone' to be a str")
        pulumi.set(__self__, "execution_timezone", execution_timezone)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_dry_run and not isinstance(is_dry_run, bool):
            raise TypeError("Expected argument 'is_dry_run' to be a bool")
        pulumi.set(__self__, "is_dry_run", is_dry_run)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rule_ids and not isinstance(rule_ids, dict):
            raise TypeError("Expected argument 'rule_ids' to be a dict")
        pulumi.set(__self__, "rule_ids", rule_ids)
        if rule_set_ids and not isinstance(rule_set_ids, dict):
            raise TypeError("Expected argument 'rule_set_ids' to be a dict")
        pulumi.set(__self__, "rule_set_ids", rule_set_ids)
        if target_accounts and not isinstance(target_accounts, list):
            raise TypeError("Expected argument 'target_accounts' to be a list")
        pulumi.set(__self__, "target_accounts", target_accounts)
        if target_regions and not isinstance(target_regions, list):
            raise TypeError("Expected argument 'target_regions' to be a list")
        pulumi.set(__self__, "target_regions", target_regions)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> _builtins.str:
        """
        The cloud provider for the rule enforcement.
        """
        return pulumi.get(self, "cloud_provider")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description for rule enforcement.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enforcementId")
    def enforcement_id(self) -> _builtins.str:
        """
        Id of rule enforcement.
        """
        return pulumi.get(self, "enforcement_id")

    @_builtins.property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> _builtins.str:
        """
        Execution schedule in cron format.
        """
        return pulumi.get(self, "execution_schedule")

    @_builtins.property
    @pulumi.getter(name="executionTimezone")
    def execution_timezone(self) -> _builtins.str:
        """
        Timezone for the execution schedule.
        """
        return pulumi.get(self, "execution_timezone")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDryRun")
    def is_dry_run(self) -> _builtins.bool:
        """
        Indicates if the rule enforcement is a dry run.
        """
        return pulumi.get(self, "is_dry_run")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Indicates if the rule enforcement is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the rule enforcement.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleIds")
    def rule_ids(self) -> Mapping[str, _builtins.str]:
        """
        List of rule IDs.
        """
        return pulumi.get(self, "rule_ids")

    @_builtins.property
    @pulumi.getter(name="ruleSetIds")
    def rule_set_ids(self) -> Mapping[str, _builtins.str]:
        """
        List of rule set IDs.
        """
        return pulumi.get(self, "rule_set_ids")

    @_builtins.property
    @pulumi.getter(name="targetAccounts")
    def target_accounts(self) -> Sequence[_builtins.str]:
        """
        List of target accounts.
        """
        return pulumi.get(self, "target_accounts")

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Sequence[_builtins.str]:
        """
        List of target regions.
        """
        return pulumi.get(self, "target_regions")


class AwaitableGetRuleEnforcementResult(GetRuleEnforcementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleEnforcementResult(
            cloud_provider=self.cloud_provider,
            description=self.description,
            enforcement_id=self.enforcement_id,
            execution_schedule=self.execution_schedule,
            execution_timezone=self.execution_timezone,
            id=self.id,
            is_dry_run=self.is_dry_run,
            is_enabled=self.is_enabled,
            name=self.name,
            rule_ids=self.rule_ids,
            rule_set_ids=self.rule_set_ids,
            target_accounts=self.target_accounts,
            target_regions=self.target_regions)


def get_rule_enforcement(enforcement_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleEnforcementResult:
    """
    Datasource for looking up a rule enforcement.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.governance.get_rule_enforcement(enforcement_id="enforcement_id")
    ```


    :param _builtins.str enforcement_id: Id of rule enforcement.
    """
    __args__ = dict()
    __args__['enforcementId'] = enforcement_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:governance/getRuleEnforcement:getRuleEnforcement', __args__, opts=opts, typ=GetRuleEnforcementResult).value

    return AwaitableGetRuleEnforcementResult(
        cloud_provider=pulumi.get(__ret__, 'cloud_provider'),
        description=pulumi.get(__ret__, 'description'),
        enforcement_id=pulumi.get(__ret__, 'enforcement_id'),
        execution_schedule=pulumi.get(__ret__, 'execution_schedule'),
        execution_timezone=pulumi.get(__ret__, 'execution_timezone'),
        id=pulumi.get(__ret__, 'id'),
        is_dry_run=pulumi.get(__ret__, 'is_dry_run'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        name=pulumi.get(__ret__, 'name'),
        rule_ids=pulumi.get(__ret__, 'rule_ids'),
        rule_set_ids=pulumi.get(__ret__, 'rule_set_ids'),
        target_accounts=pulumi.get(__ret__, 'target_accounts'),
        target_regions=pulumi.get(__ret__, 'target_regions'))
def get_rule_enforcement_output(enforcement_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleEnforcementResult]:
    """
    Datasource for looking up a rule enforcement.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    example = harness.governance.get_rule_enforcement(enforcement_id="enforcement_id")
    ```


    :param _builtins.str enforcement_id: Id of rule enforcement.
    """
    __args__ = dict()
    __args__['enforcementId'] = enforcement_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:governance/getRuleEnforcement:getRuleEnforcement', __args__, opts=opts, typ=GetRuleEnforcementResult)
    return __ret__.apply(lambda __response__: GetRuleEnforcementResult(
        cloud_provider=pulumi.get(__response__, 'cloud_provider'),
        description=pulumi.get(__response__, 'description'),
        enforcement_id=pulumi.get(__response__, 'enforcement_id'),
        execution_schedule=pulumi.get(__response__, 'execution_schedule'),
        execution_timezone=pulumi.get(__response__, 'execution_timezone'),
        id=pulumi.get(__response__, 'id'),
        is_dry_run=pulumi.get(__response__, 'is_dry_run'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        name=pulumi.get(__response__, 'name'),
        rule_ids=pulumi.get(__response__, 'rule_ids'),
        rule_set_ids=pulumi.get(__response__, 'rule_set_ids'),
        target_accounts=pulumi.get(__response__, 'target_accounts'),
        target_regions=pulumi.get(__response__, 'target_regions')))
