# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorCustomhealthsourceArgs', 'ConnectorCustomhealthsource']

@pulumi.input_type
class ConnectorCustomhealthsourceArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 method: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validation_body: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectorCustomhealthsource resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] method: HTTP Verb Method for the API Call
        :param pulumi.Input[_builtins.str] url: URL of the Custom Healthsource controller.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]] headers: Headers.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]] params: Parameters
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] validation_body: Body to be sent with the API Call
        :param pulumi.Input[_builtins.str] validation_path: Path to be added to the base URL for the API Call
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "url", url)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validation_body is not None:
            pulumi.set(__self__, "validation_body", validation_body)
        if validation_path is not None:
            pulumi.set(__self__, "validation_path", validation_path)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Input[_builtins.str]:
        """
        HTTP Verb Method for the API Call
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        URL of the Custom Healthsource controller.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]]]:
        """
        Headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]]]:
        """
        Parameters
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validationBody")
    def validation_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Body to be sent with the API Call
        """
        return pulumi.get(self, "validation_body")

    @validation_body.setter
    def validation_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_body", value)

    @_builtins.property
    @pulumi.getter(name="validationPath")
    def validation_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to be added to the base URL for the API Call
        """
        return pulumi.get(self, "validation_path")

    @validation_path.setter
    def validation_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_path", value)


@pulumi.input_type
class _ConnectorCustomhealthsourceState:
    def __init__(__self__, *,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_body: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectorCustomhealthsource resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]] headers: Headers.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] method: HTTP Verb Method for the API Call
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]] params: Parameters
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] url: URL of the Custom Healthsource controller.
        :param pulumi.Input[_builtins.str] validation_body: Body to be sent with the API Call
        :param pulumi.Input[_builtins.str] validation_path: Path to be added to the base URL for the API Call
        """
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if validation_body is not None:
            pulumi.set(__self__, "validation_body", validation_body)
        if validation_path is not None:
            pulumi.set(__self__, "validation_path", validation_path)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]]]:
        """
        Headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP Verb Method for the API Call
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]]]:
        """
        Parameters
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorCustomhealthsourceParamArgs']]]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the Custom Healthsource controller.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="validationBody")
    def validation_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Body to be sent with the API Call
        """
        return pulumi.get(self, "validation_body")

    @validation_body.setter
    def validation_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_body", value)

    @_builtins.property
    @pulumi.getter(name="validationPath")
    def validation_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to be added to the base URL for the API Call
        """
        return pulumi.get(self, "validation_path")

    @validation_path.setter
    def validation_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_path", value)


@pulumi.type_token("harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource")
class ConnectorCustomhealthsource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceHeaderArgs', 'ConnectorCustomhealthsourceHeaderArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceParamArgs', 'ConnectorCustomhealthsourceParamArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_body: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Custom Health source connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Authentication mechanism as username and password
        test = harness.platform.ConnectorCustomhealthsource("test",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            url="https://prometheus.com/",
            delegate_selectors=["harness-delegate"],
            method="GET",
            validation_path="loki/api/v1/labels",
            headers=[{
                "encrypted_value_ref": "account.doNotDeleteHSM",
                "value_encrypted": True,
                "key": "key",
                "value": "value",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level elasticsearch connector

        ```sh
        $ pulumi import harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource example <connector_id>
        ```

        Import org level elasticsearch connector

        ```sh
        $ pulumi import harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource example <ord_id>/<connector_id>
        ```

        Import project level elasticsearch connector

        ```sh
        $ pulumi import harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceHeaderArgs', 'ConnectorCustomhealthsourceHeaderArgsDict']]]] headers: Headers.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] method: HTTP Verb Method for the API Call
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceParamArgs', 'ConnectorCustomhealthsourceParamArgsDict']]]] params: Parameters
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] url: URL of the Custom Healthsource controller.
        :param pulumi.Input[_builtins.str] validation_body: Body to be sent with the API Call
        :param pulumi.Input[_builtins.str] validation_path: Path to be added to the base URL for the API Call
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorCustomhealthsourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Custom Health source connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Authentication mechanism as username and password
        test = harness.platform.ConnectorCustomhealthsource("test",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            url="https://prometheus.com/",
            delegate_selectors=["harness-delegate"],
            method="GET",
            validation_path="loki/api/v1/labels",
            headers=[{
                "encrypted_value_ref": "account.doNotDeleteHSM",
                "value_encrypted": True,
                "key": "key",
                "value": "value",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level elasticsearch connector

        ```sh
        $ pulumi import harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource example <connector_id>
        ```

        Import org level elasticsearch connector

        ```sh
        $ pulumi import harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource example <ord_id>/<connector_id>
        ```

        Import project level elasticsearch connector

        ```sh
        $ pulumi import harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorCustomhealthsourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorCustomhealthsourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceHeaderArgs', 'ConnectorCustomhealthsourceHeaderArgsDict']]]]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceParamArgs', 'ConnectorCustomhealthsourceParamArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_body: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorCustomhealthsourceArgs.__new__(ConnectorCustomhealthsourceArgs)

            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            __props__.__dict__["headers"] = headers
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if method is None and not opts.urn:
                raise TypeError("Missing required property 'method'")
            __props__.__dict__["method"] = method
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["params"] = params
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["validation_body"] = validation_body
            __props__.__dict__["validation_path"] = validation_path
        super(ConnectorCustomhealthsource, __self__).__init__(
            'harness:platform/connectorCustomhealthsource:ConnectorCustomhealthsource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            headers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceHeaderArgs', 'ConnectorCustomhealthsourceHeaderArgsDict']]]]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            method: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceParamArgs', 'ConnectorCustomhealthsourceParamArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            validation_body: Optional[pulumi.Input[_builtins.str]] = None,
            validation_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConnectorCustomhealthsource':
        """
        Get an existing ConnectorCustomhealthsource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: Tags to filter delegates for connection.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceHeaderArgs', 'ConnectorCustomhealthsourceHeaderArgsDict']]]] headers: Headers.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] method: HTTP Verb Method for the API Call
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorCustomhealthsourceParamArgs', 'ConnectorCustomhealthsourceParamArgsDict']]]] params: Parameters
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        :param pulumi.Input[_builtins.str] url: URL of the Custom Healthsource controller.
        :param pulumi.Input[_builtins.str] validation_body: Body to be sent with the API Call
        :param pulumi.Input[_builtins.str] validation_path: Path to be added to the base URL for the API Call
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorCustomhealthsourceState.__new__(_ConnectorCustomhealthsourceState)

        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["headers"] = headers
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["method"] = method
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["params"] = params
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["url"] = url
        __props__.__dict__["validation_body"] = validation_body
        __props__.__dict__["validation_path"] = validation_path
        return ConnectorCustomhealthsource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to filter delegates for connection.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectorCustomhealthsourceHeader']]]:
        """
        Headers.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Output[_builtins.str]:
        """
        HTTP Verb Method for the API Call
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectorCustomhealthsourceParam']]]:
        """
        Parameters
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the Custom Healthsource controller.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="validationBody")
    def validation_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Body to be sent with the API Call
        """
        return pulumi.get(self, "validation_body")

    @_builtins.property
    @pulumi.getter(name="validationPath")
    def validation_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to be added to the base URL for the API Call
        """
        return pulumi.get(self, "validation_path")

