# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GcpSecretManagerConnectorArgs', 'GcpSecretManagerConnector']

@pulumi.input_type
class GcpSecretManagerConnectorArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a GcpSecretManagerConnector resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] credentials_ref: Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: The delegates to inherit the credentials from.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.bool] inherit_from_delegate: Inherit configuration from delegate.
        :param pulumi.Input[_builtins.bool] is_default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "identifier", identifier)
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_authentications is not None:
            pulumi.set(__self__, "oidc_authentications", oidc_authentications)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "credentials_ref")

    @credentials_ref.setter
    def credentials_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_ref", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Inherit configuration from delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @inherit_from_delegate.setter
    def inherit_from_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inherit_from_delegate", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]]]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @oidc_authentications.setter
    def oidc_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]]]):
        pulumi.set(self, "oidc_authentications", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GcpSecretManagerConnectorState:
    def __init__(__self__, *,
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering GcpSecretManagerConnector resources.
        :param pulumi.Input[_builtins.str] credentials_ref: Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: The delegates to inherit the credentials from.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.bool] inherit_from_delegate: Inherit configuration from delegate.
        :param pulumi.Input[_builtins.bool] is_default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        if credentials_ref is not None:
            pulumi.set(__self__, "credentials_ref", credentials_ref)
        if delegate_selectors is not None:
            pulumi.set(__self__, "delegate_selectors", delegate_selectors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_authentications is not None:
            pulumi.set(__self__, "oidc_authentications", oidc_authentications)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "credentials_ref")

    @credentials_ref.setter
    def credentials_ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_ref", value)

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")

    @delegate_selectors.setter
    def delegate_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delegate_selectors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Inherit configuration from delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @inherit_from_delegate.setter
    def inherit_from_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inherit_from_delegate", value)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]]]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @oidc_authentications.setter
    def oidc_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GcpSecretManagerConnectorOidcAuthenticationArgs']]]]):
        pulumi.set(self, "oidc_authentications", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector")
class GcpSecretManagerConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpSecretManagerConnectorOidcAuthenticationArgs', 'GcpSecretManagerConnectorOidcAuthenticationArgsDict']]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating a GCP Secret Manager connector.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level gcp secret manager connector

        ```sh
        $ pulumi import harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector example <connector_id>
        ```

        Import org level gcp secret manager connector

        ```sh
        $ pulumi import harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector example <ord_id>/<connector_id>
        ```

        Import project level gcp secret manager connector

        ```sh
        $ pulumi import harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credentials_ref: Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: The delegates to inherit the credentials from.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.bool] inherit_from_delegate: Inherit configuration from delegate.
        :param pulumi.Input[_builtins.bool] is_default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GcpSecretManagerConnectorOidcAuthenticationArgs', 'GcpSecretManagerConnectorOidcAuthenticationArgsDict']]]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcpSecretManagerConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a GCP Secret Manager connector.

        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level gcp secret manager connector

        ```sh
        $ pulumi import harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector example <connector_id>
        ```

        Import org level gcp secret manager connector

        ```sh
        $ pulumi import harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector example <ord_id>/<connector_id>
        ```

        Import project level gcp secret manager connector

        ```sh
        $ pulumi import harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param GcpSecretManagerConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcpSecretManagerConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
                 delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpSecretManagerConnectorOidcAuthenticationArgs', 'GcpSecretManagerConnectorOidcAuthenticationArgsDict']]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcpSecretManagerConnectorArgs.__new__(GcpSecretManagerConnectorArgs)

            __props__.__dict__["credentials_ref"] = credentials_ref
            __props__.__dict__["delegate_selectors"] = delegate_selectors
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["inherit_from_delegate"] = inherit_from_delegate
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
            __props__.__dict__["oidc_authentications"] = oidc_authentications
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
        super(GcpSecretManagerConnector, __self__).__init__(
            'harness:platform/gcpSecretManagerConnector:GcpSecretManagerConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials_ref: Optional[pulumi.Input[_builtins.str]] = None,
            delegate_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            inherit_from_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GcpSecretManagerConnectorOidcAuthenticationArgs', 'GcpSecretManagerConnectorOidcAuthenticationArgsDict']]]]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'GcpSecretManagerConnector':
        """
        Get an existing GcpSecretManagerConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credentials_ref: Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delegate_selectors: The delegates to inherit the credentials from.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Execute on delegate or not.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.bool] inherit_from_delegate: Inherit configuration from delegate.
        :param pulumi.Input[_builtins.bool] is_default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GcpSecretManagerConnectorOidcAuthenticationArgs', 'GcpSecretManagerConnectorOidcAuthenticationArgsDict']]]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcpSecretManagerConnectorState.__new__(_GcpSecretManagerConnectorState)

        __props__.__dict__["credentials_ref"] = credentials_ref
        __props__.__dict__["delegate_selectors"] = delegate_selectors
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["inherit_from_delegate"] = inherit_from_delegate
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc_authentications"] = oidc_authentications
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        return GcpSecretManagerConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialsRef")
    def credentials_ref(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reference to the secret containing credentials of IAM service account for Google Secret Manager. To reference a secret at the organization scope, prefix 'org' to the expression: org.{identifier}. To reference a secret at the account scope, prefix 'account` to the expression: account.{identifier}.
        """
        return pulumi.get(self, "credentials_ref")

    @_builtins.property
    @pulumi.getter(name="delegateSelectors")
    def delegate_selectors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The delegates to inherit the credentials from.
        """
        return pulumi.get(self, "delegate_selectors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Execute on delegate or not.
        """
        return pulumi.get(self, "execute_on_delegate")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Inherit configuration from delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> pulumi.Output[Optional[Sequence['outputs.GcpSecretManagerConnectorOidcAuthentication']]]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

