# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDefaultNotificationTemplateSetResult',
    'AwaitableGetDefaultNotificationTemplateSetResult',
    'get_default_notification_template_set',
    'get_default_notification_template_set_output',
]

@pulumi.output_type
class GetDefaultNotificationTemplateSetResult:
    """
    A collection of values returned by getDefaultNotificationTemplateSet.
    """
    def __init__(__self__, created=None, description=None, event_template_configuration_sets=None, id=None, identifier=None, last_modified=None, name=None, notification_channel_type=None, notification_entity=None, tags=None):
        if created and not isinstance(created, int):
            raise TypeError("Expected argument 'created' to be a int")
        pulumi.set(__self__, "created", created)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_template_configuration_sets and not isinstance(event_template_configuration_sets, list):
            raise TypeError("Expected argument 'event_template_configuration_sets' to be a list")
        pulumi.set(__self__, "event_template_configuration_sets", event_template_configuration_sets)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if last_modified and not isinstance(last_modified, int):
            raise TypeError("Expected argument 'last_modified' to be a int")
        pulumi.set(__self__, "last_modified", last_modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_channel_type and not isinstance(notification_channel_type, str):
            raise TypeError("Expected argument 'notification_channel_type' to be a str")
        pulumi.set(__self__, "notification_channel_type", notification_channel_type)
        if notification_entity and not isinstance(notification_entity, str):
            raise TypeError("Expected argument 'notification_entity' to be a str")
        pulumi.set(__self__, "notification_entity", notification_entity)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.int:
        """
        Timestamp when the notification rule was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description for Default Notification Template Set
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eventTemplateConfigurationSets")
    def event_template_configuration_sets(self) -> Sequence['outputs.GetDefaultNotificationTemplateSetEventTemplateConfigurationSetResult']:
        """
        Set of event-template configurations
        """
        return pulumi.get(self, "event_template_configuration_sets")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Identifier of Default Notification Template Set
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.int:
        """
        Timestamp when the notification rule was last modified.
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of Default Notification Template Set
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationChannelType")
    def notification_channel_type(self) -> _builtins.str:
        """
        Type of channel (e.g. SLACK, EMAIL, etc.)
        """
        return pulumi.get(self, "notification_channel_type")

    @_builtins.property
    @pulumi.getter(name="notificationEntity")
    def notification_entity(self) -> _builtins.str:
        """
        Type of the entity (e.g. PIPELINE, SERVICE, etc.)
        """
        return pulumi.get(self, "notification_entity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Key-value tags
        """
        return pulumi.get(self, "tags")


class AwaitableGetDefaultNotificationTemplateSetResult(GetDefaultNotificationTemplateSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDefaultNotificationTemplateSetResult(
            created=self.created,
            description=self.description,
            event_template_configuration_sets=self.event_template_configuration_sets,
            id=self.id,
            identifier=self.identifier,
            last_modified=self.last_modified,
            name=self.name,
            notification_channel_type=self.notification_channel_type,
            notification_entity=self.notification_entity,
            tags=self.tags)


def get_default_notification_template_set(description: Optional[_builtins.str] = None,
                                          event_template_configuration_sets: Optional[Sequence[Union['GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgs', 'GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgsDict']]] = None,
                                          identifier: Optional[_builtins.str] = None,
                                          name: Optional[_builtins.str] = None,
                                          notification_channel_type: Optional[_builtins.str] = None,
                                          notification_entity: Optional[_builtins.str] = None,
                                          tags: Optional[Mapping[str, _builtins.str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDefaultNotificationTemplateSetResult:
    """
    Data source for retrieving a Default Notification Template Set.


    :param _builtins.str description: Description for Default Notification Template Set
    :param Sequence[Union['GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgs', 'GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgsDict']] event_template_configuration_sets: Set of event-template configurations
    :param _builtins.str identifier: Identifier of Default Notification Template Set
    :param _builtins.str name: Name of Default Notification Template Set
    :param _builtins.str notification_channel_type: Type of channel (e.g. SLACK, EMAIL, etc.)
    :param _builtins.str notification_entity: Type of the entity (e.g. PIPELINE, SERVICE, etc.)
    :param Mapping[str, _builtins.str] tags: Key-value tags
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['eventTemplateConfigurationSets'] = event_template_configuration_sets
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['notificationChannelType'] = notification_channel_type
    __args__['notificationEntity'] = notification_entity
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getDefaultNotificationTemplateSet:getDefaultNotificationTemplateSet', __args__, opts=opts, typ=GetDefaultNotificationTemplateSetResult).value

    return AwaitableGetDefaultNotificationTemplateSetResult(
        created=pulumi.get(__ret__, 'created'),
        description=pulumi.get(__ret__, 'description'),
        event_template_configuration_sets=pulumi.get(__ret__, 'event_template_configuration_sets'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        name=pulumi.get(__ret__, 'name'),
        notification_channel_type=pulumi.get(__ret__, 'notification_channel_type'),
        notification_entity=pulumi.get(__ret__, 'notification_entity'),
        tags=pulumi.get(__ret__, 'tags'))
def get_default_notification_template_set_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 event_template_configuration_sets: Optional[pulumi.Input[Sequence[Union['GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgs', 'GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgsDict']]]] = None,
                                                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                                                 name: Optional[pulumi.Input[_builtins.str]] = None,
                                                 notification_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                                                 notification_entity: Optional[pulumi.Input[_builtins.str]] = None,
                                                 tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDefaultNotificationTemplateSetResult]:
    """
    Data source for retrieving a Default Notification Template Set.


    :param _builtins.str description: Description for Default Notification Template Set
    :param Sequence[Union['GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgs', 'GetDefaultNotificationTemplateSetEventTemplateConfigurationSetArgsDict']] event_template_configuration_sets: Set of event-template configurations
    :param _builtins.str identifier: Identifier of Default Notification Template Set
    :param _builtins.str name: Name of Default Notification Template Set
    :param _builtins.str notification_channel_type: Type of channel (e.g. SLACK, EMAIL, etc.)
    :param _builtins.str notification_entity: Type of the entity (e.g. PIPELINE, SERVICE, etc.)
    :param Mapping[str, _builtins.str] tags: Key-value tags
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['eventTemplateConfigurationSets'] = event_template_configuration_sets
    __args__['identifier'] = identifier
    __args__['name'] = name
    __args__['notificationChannelType'] = notification_channel_type
    __args__['notificationEntity'] = notification_entity
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getDefaultNotificationTemplateSet:getDefaultNotificationTemplateSet', __args__, opts=opts, typ=GetDefaultNotificationTemplateSetResult)
    return __ret__.apply(lambda __response__: GetDefaultNotificationTemplateSetResult(
        created=pulumi.get(__response__, 'created'),
        description=pulumi.get(__response__, 'description'),
        event_template_configuration_sets=pulumi.get(__response__, 'event_template_configuration_sets'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        name=pulumi.get(__response__, 'name'),
        notification_channel_type=pulumi.get(__response__, 'notification_channel_type'),
        notification_entity=pulumi.get(__response__, 'notification_entity'),
        tags=pulumi.get(__response__, 'tags')))
