# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitOpsApplicationsArgs', 'GitOpsApplications']

@pulumi.input_type
class GitOpsApplicationsArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 applications: pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]],
                 cluster_id: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_remove_existing_finalizers: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 request_cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 request_propagation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_repo_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GitOpsApplications resource.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps application.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]] applications: Definition of the GitOps application resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] kind: Kind of the GitOps application.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps application.
        :param pulumi.Input[_builtins.bool] options_remove_existing_finalizers: Options to remove existing finalizers to delete the GitOps application.
        :param pulumi.Input[_builtins.str] project: The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        :param pulumi.Input[_builtins.str] repo_id: Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repo_ids: List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        :param pulumi.Input[_builtins.bool] request_cascade: Request cascade to delete the GitOps application.
        :param pulumi.Input[_builtins.str] request_propagation_policy: Request propagation policy to delete the GitOps application.
        :param pulumi.Input[_builtins.bool] skip_repo_validation: Indicates if the GitOps application should skip validate repository definition exists.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        :param pulumi.Input[_builtins.bool] validate: Indicates if the GitOps application yaml has to be validated.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if identifier is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""identifier is deprecated: This field is deprecated and will be removed in a future release.""")
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_remove_existing_finalizers is not None:
            pulumi.set(__self__, "options_remove_existing_finalizers", options_remove_existing_finalizers)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if repo_ids is not None:
            pulumi.set(__self__, "repo_ids", repo_ids)
        if request_cascade is not None:
            pulumi.set(__self__, "request_cascade", request_cascade)
        if request_propagation_policy is not None:
            pulumi.set(__self__, "request_propagation_policy", request_propagation_policy)
        if skip_repo_validation is not None:
            pulumi.set(__self__, "skip_repo_validation", skip_repo_validation)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Agent identifier of the GitOps application.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]]:
        """
        Definition of the GitOps application resource.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Cluster identifier of the GitOps application.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Organization identifier of the GitOps application.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project identifier of the GitOps application.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier of the GitOps application.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the GitOps application.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind of the GitOps application.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GitOps application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionsRemoveExistingFinalizers")
    def options_remove_existing_finalizers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Options to remove existing finalizers to delete the GitOps application.
        """
        return pulumi.get(self, "options_remove_existing_finalizers")

    @options_remove_existing_finalizers.setter
    def options_remove_existing_finalizers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "options_remove_existing_finalizers", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_id", value)

    @_builtins.property
    @pulumi.getter(name="repoIds")
    def repo_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        """
        return pulumi.get(self, "repo_ids")

    @repo_ids.setter
    def repo_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "repo_ids", value)

    @_builtins.property
    @pulumi.getter(name="requestCascade")
    def request_cascade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Request cascade to delete the GitOps application.
        """
        return pulumi.get(self, "request_cascade")

    @request_cascade.setter
    def request_cascade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_cascade", value)

    @_builtins.property
    @pulumi.getter(name="requestPropagationPolicy")
    def request_propagation_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request propagation policy to delete the GitOps application.
        """
        return pulumi.get(self, "request_propagation_policy")

    @request_propagation_policy.setter
    def request_propagation_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_propagation_policy", value)

    @_builtins.property
    @pulumi.getter(name="skipRepoValidation")
    def skip_repo_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application should skip validate repository definition exists.
        """
        return pulumi.get(self, "skip_repo_validation")

    @skip_repo_validation.setter
    def skip_repo_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_repo_validation", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application yaml has to be validated.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _GitOpsApplicationsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_remove_existing_finalizers: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 request_cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 request_propagation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_repo_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GitOpsApplications resources.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps application.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]] applications: Definition of the GitOps application resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] kind: Kind of the GitOps application.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps application.
        :param pulumi.Input[_builtins.bool] options_remove_existing_finalizers: Options to remove existing finalizers to delete the GitOps application.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] project: The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] repo_id: Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repo_ids: List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        :param pulumi.Input[_builtins.bool] request_cascade: Request cascade to delete the GitOps application.
        :param pulumi.Input[_builtins.str] request_propagation_policy: Request propagation policy to delete the GitOps application.
        :param pulumi.Input[_builtins.bool] skip_repo_validation: Indicates if the GitOps application should skip validate repository definition exists.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        :param pulumi.Input[_builtins.bool] validate: Indicates if the GitOps application yaml has to be validated.
        """
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if identifier is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""identifier is deprecated: This field is deprecated and will be removed in a future release.""")
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_remove_existing_finalizers is not None:
            pulumi.set(__self__, "options_remove_existing_finalizers", options_remove_existing_finalizers)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if repo_ids is not None:
            pulumi.set(__self__, "repo_ids", repo_ids)
        if request_cascade is not None:
            pulumi.set(__self__, "request_cascade", request_cascade)
        if request_propagation_policy is not None:
            pulumi.set(__self__, "request_propagation_policy", request_propagation_policy)
        if skip_repo_validation is not None:
            pulumi.set(__self__, "skip_repo_validation", skip_repo_validation)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier of the GitOps application.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agent identifier of the GitOps application.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]]]:
        """
        Definition of the GitOps application resource.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsApplicationsApplicationArgs']]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster identifier of the GitOps application.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the GitOps application.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kind of the GitOps application.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the GitOps application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionsRemoveExistingFinalizers")
    def options_remove_existing_finalizers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Options to remove existing finalizers to delete the GitOps application.
        """
        return pulumi.get(self, "options_remove_existing_finalizers")

    @options_remove_existing_finalizers.setter
    def options_remove_existing_finalizers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "options_remove_existing_finalizers", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization identifier of the GitOps application.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier of the GitOps application.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repo_id", value)

    @_builtins.property
    @pulumi.getter(name="repoIds")
    def repo_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        """
        return pulumi.get(self, "repo_ids")

    @repo_ids.setter
    def repo_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "repo_ids", value)

    @_builtins.property
    @pulumi.getter(name="requestCascade")
    def request_cascade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Request cascade to delete the GitOps application.
        """
        return pulumi.get(self, "request_cascade")

    @request_cascade.setter
    def request_cascade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "request_cascade", value)

    @_builtins.property
    @pulumi.getter(name="requestPropagationPolicy")
    def request_propagation_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Request propagation policy to delete the GitOps application.
        """
        return pulumi.get(self, "request_propagation_policy")

    @request_propagation_policy.setter
    def request_propagation_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_propagation_policy", value)

    @_builtins.property
    @pulumi.getter(name="skipRepoValidation")
    def skip_repo_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application should skip validate repository definition exists.
        """
        return pulumi.get(self, "skip_repo_validation")

    @skip_repo_validation.setter
    def skip_repo_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_repo_validation", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)

    @_builtins.property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application yaml has to be validated.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate", value)


@pulumi.type_token("harness:platform/gitOpsApplications:GitOpsApplications")
class GitOpsApplications(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsApplicationsApplicationArgs', 'GitOpsApplicationsApplicationArgsDict']]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_remove_existing_finalizers: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 request_cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 request_propagation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_repo_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Gitops Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.GitOpsApplications("example",
            applications=[{
                "metadatas": [{
                    "annotations": {},
                    "labels": {
                        "harness.io/serviceRef": "service_id",
                        "harness.io/envRef": "env_id",
                    },
                    "name": "appname123",
                }],
                "specs": [{
                    "sync_policies": [{
                        "sync_options": [
                            "PrunePropagationPolicy=undefined",
                            "CreateNamespace=false",
                            "Validate=false",
                            "skipSchemaValidations=false",
                            "autoCreateNamespace=false",
                            "pruneLast=false",
                            "applyOutofSyncOnly=false",
                            "Replace=false",
                            "retry=false",
                        ],
                    }],
                    "sources": [{
                        "target_revision": "master",
                        "repo_url": "https://github.com/willycoll/argocd-example-apps.git",
                        "path": "helm-guestbook",
                    }],
                    "destinations": [{
                        "namespace": "namespace-123",
                        "server": "https://1.3.4.5",
                    }],
                }],
            }],
            project_id="project_id",
            org_id="org_id",
            account_id="account_id",
            identifier="identifier",
            cluster_id="cluster_id",
            repo_id="repo_id",
            agent_id="agent_id")
        ```

        ## Import

        Import a Project level Gitops Application

        ```sh
        $ pulumi import harness:platform/gitOpsApplications:GitOpsApplications example <organization_id>/<project_id>/<agent_id>/<app_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsApplicationsApplicationArgs', 'GitOpsApplicationsApplicationArgsDict']]]] applications: Definition of the GitOps application resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] kind: Kind of the GitOps application.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps application.
        :param pulumi.Input[_builtins.bool] options_remove_existing_finalizers: Options to remove existing finalizers to delete the GitOps application.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] project: The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] repo_id: Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repo_ids: List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        :param pulumi.Input[_builtins.bool] request_cascade: Request cascade to delete the GitOps application.
        :param pulumi.Input[_builtins.str] request_propagation_policy: Request propagation policy to delete the GitOps application.
        :param pulumi.Input[_builtins.bool] skip_repo_validation: Indicates if the GitOps application should skip validate repository definition exists.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        :param pulumi.Input[_builtins.bool] validate: Indicates if the GitOps application yaml has to be validated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitOpsApplicationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Gitops Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.GitOpsApplications("example",
            applications=[{
                "metadatas": [{
                    "annotations": {},
                    "labels": {
                        "harness.io/serviceRef": "service_id",
                        "harness.io/envRef": "env_id",
                    },
                    "name": "appname123",
                }],
                "specs": [{
                    "sync_policies": [{
                        "sync_options": [
                            "PrunePropagationPolicy=undefined",
                            "CreateNamespace=false",
                            "Validate=false",
                            "skipSchemaValidations=false",
                            "autoCreateNamespace=false",
                            "pruneLast=false",
                            "applyOutofSyncOnly=false",
                            "Replace=false",
                            "retry=false",
                        ],
                    }],
                    "sources": [{
                        "target_revision": "master",
                        "repo_url": "https://github.com/willycoll/argocd-example-apps.git",
                        "path": "helm-guestbook",
                    }],
                    "destinations": [{
                        "namespace": "namespace-123",
                        "server": "https://1.3.4.5",
                    }],
                }],
            }],
            project_id="project_id",
            org_id="org_id",
            account_id="account_id",
            identifier="identifier",
            cluster_id="cluster_id",
            repo_id="repo_id",
            agent_id="agent_id")
        ```

        ## Import

        Import a Project level Gitops Application

        ```sh
        $ pulumi import harness:platform/gitOpsApplications:GitOpsApplications example <organization_id>/<project_id>/<agent_id>/<app_name>
        ```

        :param str resource_name: The name of the resource.
        :param GitOpsApplicationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitOpsApplicationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsApplicationsApplicationArgs', 'GitOpsApplicationsApplicationArgsDict']]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 options_remove_existing_finalizers: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repo_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 request_cascade: Optional[pulumi.Input[_builtins.bool]] = None,
                 request_propagation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_repo_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 validate: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitOpsApplicationsArgs.__new__(GitOpsApplicationsArgs)

            __props__.__dict__["account_id"] = account_id
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["kind"] = kind
            __props__.__dict__["name"] = name
            __props__.__dict__["options_remove_existing_finalizers"] = options_remove_existing_finalizers
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project"] = project
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["repo_id"] = repo_id
            __props__.__dict__["repo_ids"] = repo_ids
            __props__.__dict__["request_cascade"] = request_cascade
            __props__.__dict__["request_propagation_policy"] = request_propagation_policy
            __props__.__dict__["skip_repo_validation"] = skip_repo_validation
            __props__.__dict__["upsert"] = upsert
            __props__.__dict__["validate"] = validate
        super(GitOpsApplications, __self__).__init__(
            'harness:platform/gitOpsApplications:GitOpsApplications',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsApplicationsApplicationArgs', 'GitOpsApplicationsApplicationArgsDict']]]]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            options_remove_existing_finalizers: Optional[pulumi.Input[_builtins.bool]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_id: Optional[pulumi.Input[_builtins.str]] = None,
            repo_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            request_cascade: Optional[pulumi.Input[_builtins.bool]] = None,
            request_propagation_policy: Optional[pulumi.Input[_builtins.str]] = None,
            skip_repo_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            upsert: Optional[pulumi.Input[_builtins.bool]] = None,
            validate: Optional[pulumi.Input[_builtins.bool]] = None) -> 'GitOpsApplications':
        """
        Get an existing GitOpsApplications resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsApplicationsApplicationArgs', 'GitOpsApplicationsApplicationArgsDict']]]] applications: Definition of the GitOps application resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] kind: Kind of the GitOps application.
        :param pulumi.Input[_builtins.str] name: Name of the GitOps application.
        :param pulumi.Input[_builtins.bool] options_remove_existing_finalizers: Options to remove existing finalizers to delete the GitOps application.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] project: The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps application.
        :param pulumi.Input[_builtins.str] repo_id: Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] repo_ids: List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        :param pulumi.Input[_builtins.bool] request_cascade: Request cascade to delete the GitOps application.
        :param pulumi.Input[_builtins.str] request_propagation_policy: Request propagation policy to delete the GitOps application.
        :param pulumi.Input[_builtins.bool] skip_repo_validation: Indicates if the GitOps application should skip validate repository definition exists.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        :param pulumi.Input[_builtins.bool] validate: Indicates if the GitOps application yaml has to be validated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitOpsApplicationsState.__new__(_GitOpsApplicationsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["applications"] = applications
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["kind"] = kind
        __props__.__dict__["name"] = name
        __props__.__dict__["options_remove_existing_finalizers"] = options_remove_existing_finalizers
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project"] = project
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["repo_id"] = repo_id
        __props__.__dict__["repo_ids"] = repo_ids
        __props__.__dict__["request_cascade"] = request_cascade
        __props__.__dict__["request_propagation_policy"] = request_propagation_policy
        __props__.__dict__["skip_repo_validation"] = skip_repo_validation
        __props__.__dict__["upsert"] = upsert
        __props__.__dict__["validate"] = validate
        return GitOpsApplications(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account identifier of the GitOps application.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Agent identifier of the GitOps application.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence['outputs.GitOpsApplicationsApplication']]:
        """
        Definition of the GitOps application resource.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster identifier of the GitOps application.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifier of the GitOps application.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Kind of the GitOps application.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the GitOps application.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optionsRemoveExistingFinalizers")
    def options_remove_existing_finalizers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Options to remove existing finalizers to delete the GitOps application.
        """
        return pulumi.get(self, "options_remove_existing_finalizers")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization identifier of the GitOps application.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ArgoCD project name corresponding to this GitOps application. An empty string means that the GitOps application belongs to the default project created by Harness.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project identifier of the GitOps application.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Repository identifier of the GitOps application. When using skipRepoValidation, this field is not required.
        """
        return pulumi.get(self, "repo_id")

    @_builtins.property
    @pulumi.getter(name="repoIds")
    def repo_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of repository identifiers of the GitOps for Multi-Source application. Not required if skipRepoValidation is set to true.
        """
        return pulumi.get(self, "repo_ids")

    @_builtins.property
    @pulumi.getter(name="requestCascade")
    def request_cascade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Request cascade to delete the GitOps application.
        """
        return pulumi.get(self, "request_cascade")

    @_builtins.property
    @pulumi.getter(name="requestPropagationPolicy")
    def request_propagation_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Request propagation policy to delete the GitOps application.
        """
        return pulumi.get(self, "request_propagation_policy")

    @_builtins.property
    @pulumi.getter(name="skipRepoValidation")
    def skip_repo_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the GitOps application should skip validate repository definition exists.
        """
        return pulumi.get(self, "skip_repo_validation")

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @_builtins.property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the GitOps application yaml has to be validated.
        """
        return pulumi.get(self, "validate")

