# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitOpsRepositoryArgs', 'GitOpsRepository']

@pulumi.input_type
class GitOpsRepositoryArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 repos: pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creds_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecr_gen: Optional[pulumi.Input['GitOpsRepositoryEcrGenArgs']] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcr_gen: Optional[pulumi.Input['GitOpsRepositoryGcrGenArgs']] = None,
                 gen_type: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GitOpsRepository resource.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps repository.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]] repos: Repo details holding application configurations.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps repository.
        :param pulumi.Input[_builtins.bool] creds_only: Indicates if to operate on credential set instead of repository.
        :param pulumi.Input['GitOpsRepositoryEcrGenArgs'] ecr_gen: ECR access token generator specific configuration.
        :param pulumi.Input[_builtins.bool] force_delete: Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        :param pulumi.Input['GitOpsRepositoryGcrGenArgs'] gcr_gen: GCR access token generator specific configuration.
        :param pulumi.Input[_builtins.str] gen_type: Default: "UNSET"
               Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] refresh_interval: For OCI repos, this is the interval to refresh the token to access the registry.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]] update_masks: Update mask of the repository.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "repos", repos)
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if creds_only is not None:
            pulumi.set(__self__, "creds_only", creds_only)
        if ecr_gen is not None:
            pulumi.set(__self__, "ecr_gen", ecr_gen)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if gcr_gen is not None:
            pulumi.set(__self__, "gcr_gen", gcr_gen)
        if gen_type is not None:
            pulumi.set(__self__, "gen_type", gen_type)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if update_masks is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""update_masks is deprecated: This field is deprecated and will be removed in a future release.""")
        if update_masks is not None:
            pulumi.set(__self__, "update_masks", update_masks)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Agent identifier of the GitOps repository.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the GitOps repository.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def repos(self) -> pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]:
        """
        Repo details holding application configurations.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]):
        pulumi.set(self, "repos", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier of the GitOps repository.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="credsOnly")
    def creds_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if to operate on credential set instead of repository.
        """
        return pulumi.get(self, "creds_only")

    @creds_only.setter
    def creds_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "creds_only", value)

    @_builtins.property
    @pulumi.getter(name="ecrGen")
    def ecr_gen(self) -> Optional[pulumi.Input['GitOpsRepositoryEcrGenArgs']]:
        """
        ECR access token generator specific configuration.
        """
        return pulumi.get(self, "ecr_gen")

    @ecr_gen.setter
    def ecr_gen(self, value: Optional[pulumi.Input['GitOpsRepositoryEcrGenArgs']]):
        pulumi.set(self, "ecr_gen", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="gcrGen")
    def gcr_gen(self) -> Optional[pulumi.Input['GitOpsRepositoryGcrGenArgs']]:
        """
        GCR access token generator specific configuration.
        """
        return pulumi.get(self, "gcr_gen")

    @gcr_gen.setter
    def gcr_gen(self, value: Optional[pulumi.Input['GitOpsRepositoryGcrGenArgs']]):
        pulumi.set(self, "gcr_gen", value)

    @_builtins.property
    @pulumi.getter(name="genType")
    def gen_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default: "UNSET"
        Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        """
        return pulumi.get(self, "gen_type")

    @gen_type.setter
    def gen_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gen_type", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization identifier of the GitOps repository.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier of the GitOps repository.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For OCI repos, this is the interval to refresh the token to access the registry.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="updateMasks")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def update_masks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]:
        """
        Update mask of the repository.
        """
        return pulumi.get(self, "update_masks")

    @update_masks.setter
    def update_masks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]):
        pulumi.set(self, "update_masks", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.input_type
class _GitOpsRepositoryState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creds_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecr_gen: Optional[pulumi.Input['GitOpsRepositoryEcrGenArgs']] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcr_gen: Optional[pulumi.Input['GitOpsRepositoryGcrGenArgs']] = None,
                 gen_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GitOpsRepository resources.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps repository.
        :param pulumi.Input[_builtins.bool] creds_only: Indicates if to operate on credential set instead of repository.
        :param pulumi.Input['GitOpsRepositoryEcrGenArgs'] ecr_gen: ECR access token generator specific configuration.
        :param pulumi.Input[_builtins.bool] force_delete: Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        :param pulumi.Input['GitOpsRepositoryGcrGenArgs'] gcr_gen: GCR access token generator specific configuration.
        :param pulumi.Input[_builtins.str] gen_type: Default: "UNSET"
               Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] refresh_interval: For OCI repos, this is the interval to refresh the token to access the registry.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]] repos: Repo details holding application configurations.
        :param pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]] update_masks: Update mask of the repository.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        if account_id is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: This field is deprecated and will be removed in a future release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if creds_only is not None:
            pulumi.set(__self__, "creds_only", creds_only)
        if ecr_gen is not None:
            pulumi.set(__self__, "ecr_gen", ecr_gen)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if gcr_gen is not None:
            pulumi.set(__self__, "gcr_gen", gcr_gen)
        if gen_type is not None:
            pulumi.set(__self__, "gen_type", gen_type)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if repos is not None:
            pulumi.set(__self__, "repos", repos)
        if update_masks is not None:
            warnings.warn("""This field is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""update_masks is deprecated: This field is deprecated and will be removed in a future release.""")
        if update_masks is not None:
            pulumi.set(__self__, "update_masks", update_masks)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account identifier of the GitOps repository.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agent identifier of the GitOps repository.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="credsOnly")
    def creds_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if to operate on credential set instead of repository.
        """
        return pulumi.get(self, "creds_only")

    @creds_only.setter
    def creds_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "creds_only", value)

    @_builtins.property
    @pulumi.getter(name="ecrGen")
    def ecr_gen(self) -> Optional[pulumi.Input['GitOpsRepositoryEcrGenArgs']]:
        """
        ECR access token generator specific configuration.
        """
        return pulumi.get(self, "ecr_gen")

    @ecr_gen.setter
    def ecr_gen(self, value: Optional[pulumi.Input['GitOpsRepositoryEcrGenArgs']]):
        pulumi.set(self, "ecr_gen", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="gcrGen")
    def gcr_gen(self) -> Optional[pulumi.Input['GitOpsRepositoryGcrGenArgs']]:
        """
        GCR access token generator specific configuration.
        """
        return pulumi.get(self, "gcr_gen")

    @gcr_gen.setter
    def gcr_gen(self, value: Optional[pulumi.Input['GitOpsRepositoryGcrGenArgs']]):
        pulumi.set(self, "gcr_gen", value)

    @_builtins.property
    @pulumi.getter(name="genType")
    def gen_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default: "UNSET"
        Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        """
        return pulumi.get(self, "gen_type")

    @gen_type.setter
    def gen_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gen_type", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the GitOps repository.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization identifier of the GitOps repository.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier of the GitOps repository.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For OCI repos, this is the interval to refresh the token to access the registry.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter
    def repos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]]:
        """
        Repo details holding application configurations.
        """
        return pulumi.get(self, "repos")

    @repos.setter
    def repos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryRepoArgs']]]]):
        pulumi.set(self, "repos", value)

    @_builtins.property
    @pulumi.getter(name="updateMasks")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def update_masks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]:
        """
        Update mask of the repository.
        """
        return pulumi.get(self, "update_masks")

    @update_masks.setter
    def update_masks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GitOpsRepositoryUpdateMaskArgs']]]]):
        pulumi.set(self, "update_masks", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.type_token("harness:platform/gitOpsRepository:GitOpsRepository")
class GitOpsRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creds_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecr_gen: Optional[pulumi.Input[Union['GitOpsRepositoryEcrGenArgs', 'GitOpsRepositoryEcrGenArgsDict']]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcr_gen: Optional[pulumi.Input[Union['GitOpsRepositoryGcrGenArgs', 'GitOpsRepositoryGcrGenArgsDict']]] = None,
                 gen_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryRepoArgs', 'GitOpsRepositoryRepoArgsDict']]]]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryUpdateMaskArgs', 'GitOpsRepositoryUpdateMaskArgsDict']]]]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource for managing Harness Gitops Repository.

        ## Import

        The `pulumi import` command can be used, for example:

        Import an Account level Gitops Repository

        ```sh
        $ pulumi import harness:platform/gitOpsRepository:GitOpsRepository example <agent_id>/<respository_id>
        ```

        Import an Org level Gitops Repository

        ```sh
        $ pulumi import harness:platform/gitOpsRepository:GitOpsRepository example <organization_id>/<agent_id>/<respository_id>
        ```

        Import a Project level Gitops Repository

        ```sh
        $ pulumi import harness:platform/gitOpsRepository:GitOpsRepository example <organization_id>/<project_id>/<agent_id>/<respository_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps repository.
        :param pulumi.Input[_builtins.bool] creds_only: Indicates if to operate on credential set instead of repository.
        :param pulumi.Input[Union['GitOpsRepositoryEcrGenArgs', 'GitOpsRepositoryEcrGenArgsDict']] ecr_gen: ECR access token generator specific configuration.
        :param pulumi.Input[_builtins.bool] force_delete: Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        :param pulumi.Input[Union['GitOpsRepositoryGcrGenArgs', 'GitOpsRepositoryGcrGenArgsDict']] gcr_gen: GCR access token generator specific configuration.
        :param pulumi.Input[_builtins.str] gen_type: Default: "UNSET"
               Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] refresh_interval: For OCI repos, this is the interval to refresh the token to access the registry.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryRepoArgs', 'GitOpsRepositoryRepoArgsDict']]]] repos: Repo details holding application configurations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryUpdateMaskArgs', 'GitOpsRepositoryUpdateMaskArgsDict']]]] update_masks: Update mask of the repository.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitOpsRepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing Harness Gitops Repository.

        ## Import

        The `pulumi import` command can be used, for example:

        Import an Account level Gitops Repository

        ```sh
        $ pulumi import harness:platform/gitOpsRepository:GitOpsRepository example <agent_id>/<respository_id>
        ```

        Import an Org level Gitops Repository

        ```sh
        $ pulumi import harness:platform/gitOpsRepository:GitOpsRepository example <organization_id>/<agent_id>/<respository_id>
        ```

        Import a Project level Gitops Repository

        ```sh
        $ pulumi import harness:platform/gitOpsRepository:GitOpsRepository example <organization_id>/<project_id>/<agent_id>/<respository_id>
        ```

        :param str resource_name: The name of the resource.
        :param GitOpsRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitOpsRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 creds_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 ecr_gen: Optional[pulumi.Input[Union['GitOpsRepositoryEcrGenArgs', 'GitOpsRepositoryEcrGenArgsDict']]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcr_gen: Optional[pulumi.Input[Union['GitOpsRepositoryGcrGenArgs', 'GitOpsRepositoryGcrGenArgsDict']]] = None,
                 gen_type: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 repos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryRepoArgs', 'GitOpsRepositoryRepoArgsDict']]]]] = None,
                 update_masks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryUpdateMaskArgs', 'GitOpsRepositoryUpdateMaskArgsDict']]]]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitOpsRepositoryArgs.__new__(GitOpsRepositoryArgs)

            __props__.__dict__["account_id"] = account_id
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["creds_only"] = creds_only
            __props__.__dict__["ecr_gen"] = ecr_gen
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["gcr_gen"] = gcr_gen
            __props__.__dict__["gen_type"] = gen_type
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["refresh_interval"] = refresh_interval
            if repos is None and not opts.urn:
                raise TypeError("Missing required property 'repos'")
            __props__.__dict__["repos"] = repos
            __props__.__dict__["update_masks"] = update_masks
            __props__.__dict__["upsert"] = upsert
        super(GitOpsRepository, __self__).__init__(
            'harness:platform/gitOpsRepository:GitOpsRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            creds_only: Optional[pulumi.Input[_builtins.bool]] = None,
            ecr_gen: Optional[pulumi.Input[Union['GitOpsRepositoryEcrGenArgs', 'GitOpsRepositoryEcrGenArgsDict']]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            gcr_gen: Optional[pulumi.Input[Union['GitOpsRepositoryGcrGenArgs', 'GitOpsRepositoryGcrGenArgsDict']]] = None,
            gen_type: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_interval: Optional[pulumi.Input[_builtins.str]] = None,
            repos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryRepoArgs', 'GitOpsRepositoryRepoArgsDict']]]]] = None,
            update_masks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryUpdateMaskArgs', 'GitOpsRepositoryUpdateMaskArgsDict']]]]] = None,
            upsert: Optional[pulumi.Input[_builtins.bool]] = None) -> 'GitOpsRepository':
        """
        Get an existing GitOpsRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps repository.
        :param pulumi.Input[_builtins.bool] creds_only: Indicates if to operate on credential set instead of repository.
        :param pulumi.Input[Union['GitOpsRepositoryEcrGenArgs', 'GitOpsRepositoryEcrGenArgsDict']] ecr_gen: ECR access token generator specific configuration.
        :param pulumi.Input[_builtins.bool] force_delete: Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        :param pulumi.Input[Union['GitOpsRepositoryGcrGenArgs', 'GitOpsRepositoryGcrGenArgsDict']] gcr_gen: GCR access token generator specific configuration.
        :param pulumi.Input[_builtins.str] gen_type: Default: "UNSET"
               Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps repository.
        :param pulumi.Input[_builtins.str] refresh_interval: For OCI repos, this is the interval to refresh the token to access the registry.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryRepoArgs', 'GitOpsRepositoryRepoArgsDict']]]] repos: Repo details holding application configurations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GitOpsRepositoryUpdateMaskArgs', 'GitOpsRepositoryUpdateMaskArgsDict']]]] update_masks: Update mask of the repository.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitOpsRepositoryState.__new__(_GitOpsRepositoryState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["creds_only"] = creds_only
        __props__.__dict__["ecr_gen"] = ecr_gen
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["gcr_gen"] = gcr_gen
        __props__.__dict__["gen_type"] = gen_type
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["repos"] = repos
        __props__.__dict__["update_masks"] = update_masks
        __props__.__dict__["upsert"] = upsert
        return GitOpsRepository(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account identifier of the GitOps repository.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Agent identifier of the GitOps repository.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="credsOnly")
    def creds_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if to operate on credential set instead of repository.
        """
        return pulumi.get(self, "creds_only")

    @_builtins.property
    @pulumi.getter(name="ecrGen")
    def ecr_gen(self) -> pulumi.Output[Optional['outputs.GitOpsRepositoryEcrGen']]:
        """
        ECR access token generator specific configuration.
        """
        return pulumi.get(self, "ecr_gen")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the repository should be deleted forcefully, regardless of existing applications using that repo.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="gcrGen")
    def gcr_gen(self) -> pulumi.Output[Optional['outputs.GitOpsRepositoryGcrGen']]:
        """
        GCR access token generator specific configuration.
        """
        return pulumi.get(self, "gcr_gen")

    @_builtins.property
    @pulumi.getter(name="genType")
    def gen_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default: "UNSET"
        Enum: "UNSET" "AWS*ECR" "GOOGLE*GCR"
        """
        return pulumi.get(self, "gen_type")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the GitOps repository.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Organization identifier of the GitOps repository.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Project identifier of the GitOps repository.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For OCI repos, this is the interval to refresh the token to access the registry.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter
    def repos(self) -> pulumi.Output[Sequence['outputs.GitOpsRepositoryRepo']]:
        """
        Repo details holding application configurations.
        """
        return pulumi.get(self, "repos")

    @_builtins.property
    @pulumi.getter(name="updateMasks")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future release.""")
    def update_masks(self) -> pulumi.Output[Optional[Sequence['outputs.GitOpsRepositoryUpdateMask']]]:
        """
        Update mask of the repository.
        """
        return pulumi.get(self, "update_masks")

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the GitOps repository should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

