# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GitopsApplicationsetArgs', 'GitopsApplicationset']

@pulumi.input_type
class GitopsApplicationsetArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 applicationset: pulumi.Input['GitopsApplicationsetApplicationsetArgs'],
                 org_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GitopsApplicationset resource.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps applicationset.
        :param pulumi.Input['GitopsApplicationsetApplicationsetArgs'] applicationset: Definition of the GitOps applicationset resource.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "applicationset", applicationset)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "project_id", project_id)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Agent identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def applicationset(self) -> pulumi.Input['GitopsApplicationsetApplicationsetArgs']:
        """
        Definition of the GitOps applicationset resource.
        """
        return pulumi.get(self, "applicationset")

    @applicationset.setter
    def applicationset(self, value: pulumi.Input['GitopsApplicationsetApplicationsetArgs']):
        pulumi.set(self, "applicationset", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Organization identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.input_type
class _GitopsApplicationsetState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 applicationset: Optional[pulumi.Input['GitopsApplicationsetApplicationsetArgs']] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GitopsApplicationset resources.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps applicationset.
        :param pulumi.Input['GitopsApplicationsetApplicationsetArgs'] applicationset: Definition of the GitOps applicationset resource.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps applicationset. This is a unique identifier for the applicationset generated automatically.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if applicationset is not None:
            pulumi.set(__self__, "applicationset", applicationset)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if upsert is not None:
            pulumi.set(__self__, "upsert", upsert)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Agent identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def applicationset(self) -> Optional[pulumi.Input['GitopsApplicationsetApplicationsetArgs']]:
        """
        Definition of the GitOps applicationset resource.
        """
        return pulumi.get(self, "applicationset")

    @applicationset.setter
    def applicationset(self, value: Optional[pulumi.Input['GitopsApplicationsetApplicationsetArgs']]):
        pulumi.set(self, "applicationset", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the GitOps applicationset. This is a unique identifier for the applicationset generated automatically.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

    @upsert.setter
    def upsert(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upsert", value)


@pulumi.type_token("harness:platform/gitopsApplicationset:GitopsApplicationset")
class GitopsApplicationset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 applicationset: Optional[pulumi.Input[Union['GitopsApplicationsetApplicationsetArgs', 'GitopsApplicationsetApplicationsetArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Resource for managing a Harness Gitops Applicationset. Please note this resource is in an alpha/experimental state and is subject to change.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Example 1: Cluster Generator
        cluster_generator = harness.platform.GitopsApplicationset("cluster_generator",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "cluster-appset",
                    "namespace": "argocd",
                },
                "spec": {
                    "go_template": True,
                    "go_template_options": ["missingkey=error"],
                    "generators": [{
                        "clusters": [{
                            "enabled": True,
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.name}}-guestbook",
                            "labels": {
                                "env": "dev",
                            },
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/argoproj/argocd-example-apps.git",
                                "path": "helm-guestbook",
                                "target_revision": "HEAD",
                            }],
                            "destination": {
                                "server": "{{.url}}",
                                "namespace": "app-ns-{{.name}}",
                            },
                        },
                    },
                },
            })
        # Example 2: List Generator
        list_generator = harness.platform.GitopsApplicationset("list_generator",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "list-appset",
                },
                "spec": {
                    "go_template": True,
                    "go_template_options": ["missingkey=error"],
                    "generators": [{
                        "lists": [{
                            "elements": [
                                {
                                    "cluster": "engineering-dev",
                                    "url": "https://kubernetes.default.svc",
                                },
                                {
                                    "cluster": "engineering-prod",
                                    "url": "https://kubernetes.prod.svc",
                                },
                            ],
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.cluster}}-guestbook",
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/argoproj/argocd-example-apps.git",
                                "path": "helm-guestbook",
                                "target_revision": "HEAD",
                            }],
                            "destination": {
                                "server": "{{.url}}",
                                "namespace": "default",
                            },
                        },
                    },
                },
            })
        # Example 3: Git Generator with Files
        git_files = harness.platform.GitopsApplicationset("git_files",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "git-files-appset",
                },
                "spec": {
                    "generators": [{
                        "gits": [{
                            "repo_url": "https://github.com/example/config-repo",
                            "revision": "main",
                            "files": [{
                                "path": "apps/*/config.json",
                            }],
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.path.basename}}-app",
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/example/app-repo",
                                "path": "{{.path.path}}",
                                "target_revision": "main",
                            }],
                            "destination": {
                                "server": "https://kubernetes.default.svc",
                                "namespace": "{{.path.basename}}",
                            },
                        },
                    },
                },
            })
        # Example 4: Git Generator with Directories
        git_directories = harness.platform.GitopsApplicationset("git_directories",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "git-directories-appset",
                },
                "spec": {
                    "generators": [{
                        "gits": [{
                            "repo_url": "https://github.com/argoproj/argo-cd.git",
                            "revision": "HEAD",
                            "directories": [{
                                "path": "applicationset/examples/git-generator-directory/cluster-addons/*",
                                "exclude": False,
                            }],
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.path.basename}}-addon",
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/argoproj/argo-cd.git",
                                "path": "{{.path.path}}",
                                "target_revision": "HEAD",
                            }],
                            "destination": {
                                "server": "https://kubernetes.default.svc",
                                "namespace": "{{.path.basename}}",
                            },
                            "sync_policy": {
                                "automated": {
                                    "prune": True,
                                    "self_heal": True,
                                },
                            },
                        },
                    },
                },
            })
        ```

        ## Import

        Import gitOps applicationset with account level agent, agent id has account prefix #

        ```sh
        $ pulumi import harness:platform/gitopsApplicationset:GitopsApplicationset example <organization_id>/<project_id>/<agent_id>/<identifier>
        ```

        Import gitOps applicationset with org level agent, agent id has org prefix #

        ```sh
        $ pulumi import harness:platform/gitopsApplicationset:GitopsApplicationset example <organization_id>/<project_id>/<agent_id>/<identifier>
        ```

        Import gitOps applicationset with project level agent #

        ```sh
        $ pulumi import harness:platform/gitopsApplicationset:GitopsApplicationset example <organization_id>/<project_id>/<agent_id>/<identifier>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps applicationset.
        :param pulumi.Input[Union['GitopsApplicationsetApplicationsetArgs', 'GitopsApplicationsetApplicationsetArgsDict']] applicationset: Definition of the GitOps applicationset resource.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitopsApplicationsetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a Harness Gitops Applicationset. Please note this resource is in an alpha/experimental state and is subject to change.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        # Example 1: Cluster Generator
        cluster_generator = harness.platform.GitopsApplicationset("cluster_generator",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "cluster-appset",
                    "namespace": "argocd",
                },
                "spec": {
                    "go_template": True,
                    "go_template_options": ["missingkey=error"],
                    "generators": [{
                        "clusters": [{
                            "enabled": True,
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.name}}-guestbook",
                            "labels": {
                                "env": "dev",
                            },
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/argoproj/argocd-example-apps.git",
                                "path": "helm-guestbook",
                                "target_revision": "HEAD",
                            }],
                            "destination": {
                                "server": "{{.url}}",
                                "namespace": "app-ns-{{.name}}",
                            },
                        },
                    },
                },
            })
        # Example 2: List Generator
        list_generator = harness.platform.GitopsApplicationset("list_generator",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "list-appset",
                },
                "spec": {
                    "go_template": True,
                    "go_template_options": ["missingkey=error"],
                    "generators": [{
                        "lists": [{
                            "elements": [
                                {
                                    "cluster": "engineering-dev",
                                    "url": "https://kubernetes.default.svc",
                                },
                                {
                                    "cluster": "engineering-prod",
                                    "url": "https://kubernetes.prod.svc",
                                },
                            ],
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.cluster}}-guestbook",
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/argoproj/argocd-example-apps.git",
                                "path": "helm-guestbook",
                                "target_revision": "HEAD",
                            }],
                            "destination": {
                                "server": "{{.url}}",
                                "namespace": "default",
                            },
                        },
                    },
                },
            })
        # Example 3: Git Generator with Files
        git_files = harness.platform.GitopsApplicationset("git_files",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "git-files-appset",
                },
                "spec": {
                    "generators": [{
                        "gits": [{
                            "repo_url": "https://github.com/example/config-repo",
                            "revision": "main",
                            "files": [{
                                "path": "apps/*/config.json",
                            }],
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.path.basename}}-app",
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/example/app-repo",
                                "path": "{{.path.path}}",
                                "target_revision": "main",
                            }],
                            "destination": {
                                "server": "https://kubernetes.default.svc",
                                "namespace": "{{.path.basename}}",
                            },
                        },
                    },
                },
            })
        # Example 4: Git Generator with Directories
        git_directories = harness.platform.GitopsApplicationset("git_directories",
            org_id="default",
            project_id="projectId",
            agent_id="account.agentuseast1",
            upsert=True,
            applicationset={
                "metadata": {
                    "name": "git-directories-appset",
                },
                "spec": {
                    "generators": [{
                        "gits": [{
                            "repo_url": "https://github.com/argoproj/argo-cd.git",
                            "revision": "HEAD",
                            "directories": [{
                                "path": "applicationset/examples/git-generator-directory/cluster-addons/*",
                                "exclude": False,
                            }],
                        }],
                    }],
                    "template": {
                        "metadata": {
                            "name": "{{.path.basename}}-addon",
                        },
                        "spec": {
                            "project": "default",
                            "sources": [{
                                "repo_url": "https://github.com/argoproj/argo-cd.git",
                                "path": "{{.path.path}}",
                                "target_revision": "HEAD",
                            }],
                            "destination": {
                                "server": "https://kubernetes.default.svc",
                                "namespace": "{{.path.basename}}",
                            },
                            "sync_policy": {
                                "automated": {
                                    "prune": True,
                                    "self_heal": True,
                                },
                            },
                        },
                    },
                },
            })
        ```

        ## Import

        Import gitOps applicationset with account level agent, agent id has account prefix #

        ```sh
        $ pulumi import harness:platform/gitopsApplicationset:GitopsApplicationset example <organization_id>/<project_id>/<agent_id>/<identifier>
        ```

        Import gitOps applicationset with org level agent, agent id has org prefix #

        ```sh
        $ pulumi import harness:platform/gitopsApplicationset:GitopsApplicationset example <organization_id>/<project_id>/<agent_id>/<identifier>
        ```

        Import gitOps applicationset with project level agent #

        ```sh
        $ pulumi import harness:platform/gitopsApplicationset:GitopsApplicationset example <organization_id>/<project_id>/<agent_id>/<identifier>
        ```

        :param str resource_name: The name of the resource.
        :param GitopsApplicationsetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitopsApplicationsetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 applicationset: Optional[pulumi.Input[Union['GitopsApplicationsetApplicationsetArgs', 'GitopsApplicationsetApplicationsetArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upsert: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitopsApplicationsetArgs.__new__(GitopsApplicationsetArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if applicationset is None and not opts.urn:
                raise TypeError("Missing required property 'applicationset'")
            __props__.__dict__["applicationset"] = applicationset
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["upsert"] = upsert
            __props__.__dict__["identifier"] = None
        super(GitopsApplicationset, __self__).__init__(
            'harness:platform/gitopsApplicationset:GitopsApplicationset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            applicationset: Optional[pulumi.Input[Union['GitopsApplicationsetApplicationsetArgs', 'GitopsApplicationsetApplicationsetArgsDict']]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            upsert: Optional[pulumi.Input[_builtins.bool]] = None) -> 'GitopsApplicationset':
        """
        Get an existing GitopsApplicationset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: Agent identifier of the GitOps applicationset.
        :param pulumi.Input[Union['GitopsApplicationsetApplicationsetArgs', 'GitopsApplicationsetApplicationsetArgsDict']] applicationset: Definition of the GitOps applicationset resource.
        :param pulumi.Input[_builtins.str] identifier: Identifier of the GitOps applicationset. This is a unique identifier for the applicationset generated automatically.
        :param pulumi.Input[_builtins.str] org_id: Organization identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.str] project_id: Project identifier of the GitOps applicationset.
        :param pulumi.Input[_builtins.bool] upsert: Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitopsApplicationsetState.__new__(_GitopsApplicationsetState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["applicationset"] = applicationset
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["upsert"] = upsert
        return GitopsApplicationset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Agent identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter
    def applicationset(self) -> pulumi.Output['outputs.GitopsApplicationsetApplicationset']:
        """
        Definition of the GitOps applicationset resource.
        """
        return pulumi.get(self, "applicationset")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the GitOps applicationset. This is a unique identifier for the applicationset generated automatically.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Organization identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project identifier of the GitOps applicationset.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def upsert(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the GitOps application should be updated if existing and inserted if not.
        """
        return pulumi.get(self, "upsert")

