# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InfraModuleArgs', 'InfraModule']

@pulumi.input_type
class InfraModuleArgs:
    def __init__(__self__, *,
                 system: pulumi.Input[_builtins.str],
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 synced: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a InfraModule resource.
        :param pulumi.Input[_builtins.str] system: Provider of the module.
        :param pulumi.Input[_builtins.int] created: Timestamp when the module was created.
        :param pulumi.Input[_builtins.str] description: Description of the module.
        :param pulumi.Input[_builtins.str] name: Name of the module.
        :param pulumi.Input[_builtins.str] repository: For account connectors, the repository where the module can be found
        :param pulumi.Input[_builtins.str] repository_branch: Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[_builtins.str] repository_commit: Tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[_builtins.str] repository_connector: Reference to the connector to be used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Path to the module within the repository.
        :param pulumi.Input[_builtins.str] repository_url: URL of the repository where the module is stored.
        :param pulumi.Input[_builtins.int] synced: Timestamp when the module was last synced.
        :param pulumi.Input[_builtins.str] tags: Git tags associated with the module.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: List of versions of the module.
        """
        pulumi.set(__self__, "system", system)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_connector is not None:
            pulumi.set(__self__, "repository_connector", repository_connector)
        if repository_path is not None:
            pulumi.set(__self__, "repository_path", repository_path)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if synced is not None:
            pulumi.set(__self__, "synced", synced)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def system(self) -> pulumi.Input[_builtins.str]:
        """
        Provider of the module.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "system", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the module.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the module.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For account connectors, the repository where the module can be found
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_branch", value)

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag to fetch the code from. This cannot be set if repository branch is set.
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_commit", value)

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the connector to be used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_connector", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the module within the repository.
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_path", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the repository where the module is stored.
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter
    def synced(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was last synced.
        """
        return pulumi.get(self, "synced")

    @synced.setter
    def synced(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "synced", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git tags associated with the module.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of versions of the module.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.input_type
class _InfraModuleState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 synced: Optional[pulumi.Input[_builtins.int]] = None,
                 system: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering InfraModule resources.
        :param pulumi.Input[_builtins.int] created: Timestamp when the module was created.
        :param pulumi.Input[_builtins.str] description: Description of the module.
        :param pulumi.Input[_builtins.str] name: Name of the module.
        :param pulumi.Input[_builtins.str] repository: For account connectors, the repository where the module can be found
        :param pulumi.Input[_builtins.str] repository_branch: Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[_builtins.str] repository_commit: Tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[_builtins.str] repository_connector: Reference to the connector to be used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Path to the module within the repository.
        :param pulumi.Input[_builtins.str] repository_url: URL of the repository where the module is stored.
        :param pulumi.Input[_builtins.int] synced: Timestamp when the module was last synced.
        :param pulumi.Input[_builtins.str] system: Provider of the module.
        :param pulumi.Input[_builtins.str] tags: Git tags associated with the module.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: List of versions of the module.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_connector is not None:
            pulumi.set(__self__, "repository_connector", repository_connector)
        if repository_path is not None:
            pulumi.set(__self__, "repository_path", repository_path)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if synced is not None:
            pulumi.set(__self__, "synced", synced)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the module.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the module.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For account connectors, the repository where the module can be found
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_branch", value)

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tag to fetch the code from. This cannot be set if repository branch is set.
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_commit", value)

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to the connector to be used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_connector", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the module within the repository.
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_path", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the repository where the module is stored.
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter
    def synced(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was last synced.
        """
        return pulumi.get(self, "synced")

    @synced.setter
    def synced(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "synced", value)

    @_builtins.property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider of the module.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git tags associated with the module.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of versions of the module.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("harness:platform/infraModule:InfraModule")
class InfraModule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 synced: Optional[pulumi.Input[_builtins.int]] = None,
                 system: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.InfraModule("example",
            description="example",
            name="name",
            system="provider",
            repository="https://github.com/org/repo",
            repository_branch="main",
            repository_path="tf/aws/basic",
            repository_connector=test["id"])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import harness:platform/infraModule:InfraModule example <module_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] created: Timestamp when the module was created.
        :param pulumi.Input[_builtins.str] description: Description of the module.
        :param pulumi.Input[_builtins.str] name: Name of the module.
        :param pulumi.Input[_builtins.str] repository: For account connectors, the repository where the module can be found
        :param pulumi.Input[_builtins.str] repository_branch: Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[_builtins.str] repository_commit: Tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[_builtins.str] repository_connector: Reference to the connector to be used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Path to the module within the repository.
        :param pulumi.Input[_builtins.str] repository_url: URL of the repository where the module is stored.
        :param pulumi.Input[_builtins.int] synced: Timestamp when the module was last synced.
        :param pulumi.Input[_builtins.str] system: Provider of the module.
        :param pulumi.Input[_builtins.str] tags: Git tags associated with the module.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: List of versions of the module.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfraModuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        example = harness.platform.InfraModule("example",
            description="example",
            name="name",
            system="provider",
            repository="https://github.com/org/repo",
            repository_branch="main",
            repository_path="tf/aws/basic",
            repository_connector=test["id"])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import harness:platform/infraModule:InfraModule example <module_id>
        ```

        :param str resource_name: The name of the resource.
        :param InfraModuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfraModuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 synced: Optional[pulumi.Input[_builtins.int]] = None,
                 system: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfraModuleArgs.__new__(InfraModuleArgs)

            __props__.__dict__["created"] = created
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["repository"] = repository
            __props__.__dict__["repository_branch"] = repository_branch
            __props__.__dict__["repository_commit"] = repository_commit
            __props__.__dict__["repository_connector"] = repository_connector
            __props__.__dict__["repository_path"] = repository_path
            __props__.__dict__["repository_url"] = repository_url
            __props__.__dict__["synced"] = synced
            if system is None and not opts.urn:
                raise TypeError("Missing required property 'system'")
            __props__.__dict__["system"] = system
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versions"] = versions
        super(InfraModule, __self__).__init__(
            'harness:platform/infraModule:InfraModule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None,
            repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
            repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
            repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
            repository_path: Optional[pulumi.Input[_builtins.str]] = None,
            repository_url: Optional[pulumi.Input[_builtins.str]] = None,
            synced: Optional[pulumi.Input[_builtins.int]] = None,
            system: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[_builtins.str]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'InfraModule':
        """
        Get an existing InfraModule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] created: Timestamp when the module was created.
        :param pulumi.Input[_builtins.str] description: Description of the module.
        :param pulumi.Input[_builtins.str] name: Name of the module.
        :param pulumi.Input[_builtins.str] repository: For account connectors, the repository where the module can be found
        :param pulumi.Input[_builtins.str] repository_branch: Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        :param pulumi.Input[_builtins.str] repository_commit: Tag to fetch the code from. This cannot be set if repository branch is set.
        :param pulumi.Input[_builtins.str] repository_connector: Reference to the connector to be used to fetch the code.
        :param pulumi.Input[_builtins.str] repository_path: Path to the module within the repository.
        :param pulumi.Input[_builtins.str] repository_url: URL of the repository where the module is stored.
        :param pulumi.Input[_builtins.int] synced: Timestamp when the module was last synced.
        :param pulumi.Input[_builtins.str] system: Provider of the module.
        :param pulumi.Input[_builtins.str] tags: Git tags associated with the module.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: List of versions of the module.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfraModuleState.__new__(_InfraModuleState)

        __props__.__dict__["created"] = created
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["repository"] = repository
        __props__.__dict__["repository_branch"] = repository_branch
        __props__.__dict__["repository_commit"] = repository_commit
        __props__.__dict__["repository_connector"] = repository_connector
        __props__.__dict__["repository_path"] = repository_path
        __props__.__dict__["repository_url"] = repository_url
        __props__.__dict__["synced"] = synced
        __props__.__dict__["system"] = system
        __props__.__dict__["tags"] = tags
        __props__.__dict__["versions"] = versions
        return InfraModule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp when the module was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the module.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the module.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For account connectors, the repository where the module can be found
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the branch to fetch the code from. This cannot be set if repository commit is set.
        """
        return pulumi.get(self, "repository_branch")

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Tag to fetch the code from. This cannot be set if repository branch is set.
        """
        return pulumi.get(self, "repository_commit")

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reference to the connector to be used to fetch the code.
        """
        return pulumi.get(self, "repository_connector")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to the module within the repository.
        """
        return pulumi.get(self, "repository_path")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the repository where the module is stored.
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter
    def synced(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp when the module was last synced.
        """
        return pulumi.get(self, "synced")

    @_builtins.property
    @pulumi.getter
    def system(self) -> pulumi.Output[_builtins.str]:
        """
        Provider of the module.
        """
        return pulumi.get(self, "system")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[_builtins.str]:
        """
        Git tags associated with the module.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of versions of the module.
        """
        return pulumi.get(self, "versions")

